/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.openssh;

import java.net.InetAddress;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface OpenSshCommand {
    public boolean getRedirectStderr();

    public static final class DumpConfig
    implements OpenSshCommand {
        @NotNull
        public static final DumpConfig INSTANCE = new DumpConfig();
        private static final boolean redirectStderr;

        private DumpConfig() {
        }

        @Override
        public boolean getRedirectStderr() {
            return redirectStderr;
        }

        @NotNull
        public String toString() {
            return "DumpConfig";
        }

        public int hashCode() {
            return -1270197081;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DumpConfig)) {
                return false;
            }
            DumpConfig cfr_ignored_0 = (DumpConfig)other;
            return true;
        }
    }

    public static final class Execute
    implements OpenSshCommand {
        @NotNull
        private final List<String> command;
        private final boolean allocatePty;
        private final boolean withDynamicProxy;
        private final boolean redirectStderr;

        public Execute(@NotNull List<String> command2, boolean allocatePty, boolean withDynamicProxy, boolean redirectStderr) {
            Intrinsics.checkNotNullParameter(command2, (String)"command");
            this.command = command2;
            this.allocatePty = allocatePty;
            this.withDynamicProxy = withDynamicProxy;
            this.redirectStderr = redirectStderr;
        }

        @NotNull
        public final List<String> getCommand() {
            return this.command;
        }

        public final boolean getAllocatePty() {
            return this.allocatePty;
        }

        public final boolean getWithDynamicProxy() {
            return this.withDynamicProxy;
        }

        @Override
        public boolean getRedirectStderr() {
            return this.redirectStderr;
        }

        @NotNull
        public String toString() {
            return "Execute(command=" + this.command + ", allocatePty=" + this.allocatePty + ", withDynamicProxy=" + this.withDynamicProxy + ", redirectStderr=" + this.redirectStderr + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.command).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.allocatePty);
            result2 = result2 * 31 + Boolean.hashCode(this.withDynamicProxy);
            result2 = result2 * 31 + Boolean.hashCode(this.redirectStderr);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Execute)) {
                return false;
            }
            Execute execute2 = (Execute)other;
            if (!Intrinsics.areEqual(this.command, execute2.command)) {
                return false;
            }
            if (this.allocatePty != execute2.allocatePty) {
                return false;
            }
            if (this.withDynamicProxy != execute2.withDynamicProxy) {
                return false;
            }
            return this.redirectStderr == execute2.redirectStderr;
        }
    }

    public static final class ForwardLocalPort
    implements OpenSshCommand {
        @NotNull
        private final InetAddress localAddress;
        private final int localPort;
        @NotNull
        private final InetAddress remoteLocalAddress;
        private final int remotePort;
        private final boolean redirectStderr;

        @NotNull
        public final InetAddress getLocalAddress() {
            return this.localAddress;
        }

        public final int getLocalPort() {
            return this.localPort;
        }

        @NotNull
        public final InetAddress getRemoteLocalAddress() {
            return this.remoteLocalAddress;
        }

        public final int getRemotePort() {
            return this.remotePort;
        }

        @Override
        public boolean getRedirectStderr() {
            return this.redirectStderr;
        }

        @NotNull
        public String toString() {
            return "ForwardLocalPort(localAddress=" + this.localAddress + ", localPort=" + this.localPort + ", remoteLocalAddress=" + this.remoteLocalAddress + ", remotePort=" + this.remotePort + ")";
        }

        public int hashCode() {
            int result2 = this.localAddress.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.localPort);
            result2 = result2 * 31 + this.remoteLocalAddress.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.remotePort);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ForwardLocalPort)) {
                return false;
            }
            ForwardLocalPort forwardLocalPort = (ForwardLocalPort)other;
            if (!Intrinsics.areEqual((Object)this.localAddress, (Object)forwardLocalPort.localAddress)) {
                return false;
            }
            if (this.localPort != forwardLocalPort.localPort) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.remoteLocalAddress, (Object)forwardLocalPort.remoteLocalAddress)) {
                return false;
            }
            return this.remotePort == forwardLocalPort.remotePort;
        }
    }
}

