/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.network.httpServer.websocket;

import com.jetbrains.toolbox.network.httpServer.HttpRequestDelegator;
import com.jetbrains.toolbox.network.httpServer.HttpRequestHandler;
import com.jetbrains.toolbox.network.httpServer.websocket.WebSocketProtocolHandler;
import com.jetbrains.toolbox.network.httpServer.websocket.WebsocketClientFactory;
import com.jetbrains.toolbox.network.httpServer.websocket.WebsocketReceiver;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.Future;
import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public final class WebSocketHandshakeHandler
implements HttpRequestHandler {
    @NotNull
    private final WebsocketClientFactory handlerFactory;
    @NotNull
    private final String path;

    public WebSocketHandshakeHandler(@NotNull WebsocketClientFactory handlerFactory) {
        Intrinsics.checkNotNullParameter((Object)handlerFactory, (String)"handlerFactory");
        this.handlerFactory = handlerFactory;
        this.path = this.handlerFactory.getPath();
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    public void process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context2) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        HttpHeaders headers2 = request2.headers();
        String connectionHeader = headers2.get(HttpHeaderNames.CONNECTION);
        String upgradeHeader = headers2.get(HttpHeaderNames.UPGRADE);
        if (StringsKt.equals((String)"Upgrade", (String)connectionHeader, (boolean)true) && StringsKt.equals((String)"WebSocket", (String)upgradeHeader, (boolean)true)) {
            this.handleHandshake(context2, request2);
        }
    }

    private final void handleHandshake(ChannelHandlerContext ctx, HttpRequest msg) {
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(msg), null, true);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(msg);
        Future<Void> future = handshaker == null ? WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(ctx.channel()) : handshaker.handshake(ctx.channel(), msg).addListener(arg_0 -> WebSocketHandshakeHandler.handleHandshake$lambda$0(ctx, msg, this, handshaker, arg_0));
    }

    private final String getWebSocketURL(HttpRequest msg) {
        return "ws://" + msg.headers().get("Host") + msg.uri();
    }

    private static final void handleHandshake$lambda$0(ChannelHandlerContext $ctx, HttpRequest $msg, WebSocketHandshakeHandler this$0, WebSocketServerHandshaker $handshaker, Future it) {
        Channel channel = $ctx.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
        WebSocketProtocolHandler protocolHandler = new WebSocketProtocolHandler(channel);
        QueryStringDecoder params2 = new QueryStringDecoder($msg.uri());
        WebsocketClientFactory websocketClientFactory = this$0.handlerFactory;
        URI uRI = new URI($msg.uri());
        Map<String, List<String>> map2 = params2.parameters();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"parameters(...)");
        WebsocketReceiver websocketReceiver = websocketClientFactory.get(uRI, map2, protocolHandler.getOutlet());
        if (websocketReceiver != null) {
            websocketReceiver.connected();
            protocolHandler.registerReceiver(websocketReceiver);
            HttpRequestDelegator.Companion.replaceDefaultHandler($ctx, protocolHandler);
            ChannelHandlerContext protocolHandlerContext = $ctx.pipeline().context(protocolHandler);
            v4 = $ctx.pipeline().addBefore(protocolHandlerContext.name(), "webSocketFrameAggregator", new WebSocketFrameAggregator(0xB400000));
        } else {
            v4 = $handshaker.close($ctx.channel(), new CloseWebSocketFrame(WebSocketCloseStatus.ENDPOINT_UNAVAILABLE));
        }
    }
}

