/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.network.httpServer;

import com.jetbrains.toolbox.network.httpServer.HttpRequestHandler;
import com.jetbrains.toolbox.network.util.HttpUtilsKt;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nHttpRequestDelegator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestDelegator.kt\ncom/jetbrains/toolbox/network/httpServer/HttpRequestDelegator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1208#2,2:44\n1236#2,4:46\n1#3:50\n*S KotlinDebug\n*F\n+ 1 HttpRequestDelegator.kt\ncom/jetbrains/toolbox/network/httpServer/HttpRequestDelegator\n*L\n14#1:44,2\n14#1:46,4\n*E\n"})
public final class HttpRequestDelegator
extends ChannelInboundHandlerAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, HttpRequestHandler> handlers;
    @NotNull
    private static final Class<HttpRequestDelegator> DEFAULT_HANDLER = HttpRequestDelegator.class;

    /*
     * WARNING - void declaration
     */
    public HttpRequestDelegator(@NotNull List<? extends HttpRequestHandler> handlers2) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(handlers2, (String)"handlers");
        Iterable iterable = handlers2;
        HttpRequestDelegator httpRequestDelegator = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            HttpRequestHandler httpRequestHandler = (HttpRequestHandler)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getPath(), element$iv$iv);
        }
        httpRequestDelegator.handlers = destination$iv$iv;
    }

    @Override
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Logger.INSTANCE.debug("New request to BuiltInServer");
        if (msg instanceof FullHttpRequest) {
            Logger.INSTANCE.debug("Method: " + ((FullHttpRequest)msg).method().name() + " URI: " + ((FullHttpRequest)msg).uri());
            String msgPath = new URI(((FullHttpRequest)msg).uri()).getPath();
            HttpRequestHandler handler2 = this.handlers.get(msgPath);
            if (handler2 != null) {
                Logger.INSTANCE.debug("Selected handler: " + handler2.getClass().getSimpleName());
                handler2.process(new QueryStringDecoder(((FullHttpRequest)msg).uri()), (FullHttpRequest)msg, ctx);
            } else {
                Logger.INSTANCE.debug("Handler not found for path: " + msgPath + ". Available paths: " + CollectionsKt.joinToString$default((Iterable)this.handlers.keySet(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
                HttpResponse it = HttpUtilsKt.createStatusResponse$default(httpResponseStatus, (HttpRequest)msg, null, false, 12, null);
                boolean bl = false;
                ctx.writeAndFlush(it);
            }
        }
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Logger.INSTANCE.warn(cause, "Caught exception during Http request processing");
    }

    public static final class Companion {
        private Companion() {
        }

        public final void replaceDefaultHandler(@NotNull ChannelHandlerContext context2, @NotNull ChannelHandler channelHandler) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)channelHandler, (String)"channelHandler");
            context2.pipeline().replace(DEFAULT_HANDLER, "replacedDefaultHandler", channelHandler);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

