/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.network.httpServer;

import com.jetbrains.toolbox.network.httpServer.BuiltInServer;
import com.jetbrains.toolbox.network.httpServer.HttpRequestDelegator;
import com.jetbrains.toolbox.network.httpServer.HttpRequestHandler;
import com.jetbrains.toolbox.network.util.HttpUtilsKt;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.tinylog.kotlin.Logger;

@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nBuiltInServerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInServerImpl.kt\ncom/jetbrains/toolbox/network/httpServer/BuiltInServerImpl\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,92:1\n126#2:93\n153#2,3:94\n*S KotlinDebug\n*F\n+ 1 BuiltInServerImpl.kt\ncom/jetbrains/toolbox/network/httpServer/BuiltInServerImpl\n*L\n39#1:93\n39#1:94,3\n*E\n"})
public final class BuiltInServerImpl
implements BuiltInServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InetAddress address;
    private final int port;
    @NotNull
    private final EventLoopGroup eventLoopGroup;
    @NotNull
    private final EventLoopGroup childEventLoopGroup;
    @NotNull
    private final Channel channel;
    @NotNull
    private final Map<String, String> handlerNamesMap;
    @NotNull
    private final AtomicBoolean _isWorking;
    @NotNull
    private final String info;

    private BuiltInServerImpl(InetAddress address, int port, EventLoopGroup eventLoopGroup, EventLoopGroup childEventLoopGroup, Channel channel, Map<String, String> handlerNamesMap) {
        this.address = address;
        this.port = port;
        this.eventLoopGroup = eventLoopGroup;
        this.childEventLoopGroup = childEventLoopGroup;
        this.channel = channel;
        this.handlerNamesMap = handlerNamesMap;
        this._isWorking = new AtomicBoolean(true);
        this.info = this.getInfoString();
    }

    @Override
    @NotNull
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @NotNull
    public String getInfo() {
        return this.info;
    }

    /*
     * WARNING - void declaration
     */
    private final String getInfoString() {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = this.handlerNamesMap;
        boolean $i$f$map = false;
        Map<String, String> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey() + ": " + it.getValue());
        }
        String handlersInfo = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return "Address: " + this.getAddress().getHostAddress() + " Port: " + this.getPort() + "\nRegistered handlers:\n" + handlersInfo;
    }

    public /* synthetic */ BuiltInServerImpl(InetAddress address, int port, EventLoopGroup eventLoopGroup, EventLoopGroup childEventLoopGroup, Channel channel, Map handlerNamesMap, DefaultConstructorMarker $constructor_marker) {
        this(address, port, eventLoopGroup, childEventLoopGroup, channel, handlerNamesMap);
    }

    @SourceDebugExtension(value={"SMAP\nBuiltInServerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInServerImpl.kt\ncom/jetbrains/toolbox/network/httpServer/BuiltInServerImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1#2:93\n1193#3,2:94\n1267#3,4:96\n*S KotlinDebug\n*F\n+ 1 BuiltInServerImpl.kt\ncom/jetbrains/toolbox/network/httpServer/BuiltInServerImpl$Companion\n*L\n87#1:94,2\n87#1:96,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ServerBootstrap createServerBootstrap(EventLoopGroup parentEventLoopGroup, EventLoopGroup childEventLoopGroup) {
            ServerBootstrap bootstrap2 = (ServerBootstrap)new ServerBootstrap().group(parentEventLoopGroup, childEventLoopGroup).channel(NioServerSocketChannel.class);
            bootstrap2.childOption(ChannelOption.TCP_NODELAY, true).childOption(ChannelOption.SO_KEEPALIVE, true);
            Intrinsics.checkNotNull((Object)bootstrap2);
            return bootstrap2;
        }

        private final Channel bind(ServerBootstrap bootstrap2) {
            InetAddress address = Inet4Address.getLoopbackAddress();
            ChannelFuture future = bootstrap2.bind(address, 0).sync();
            Channel channel = future.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            return channel;
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        @NotNull
        public final BuiltInServerImpl start(@NotNull List<? extends HttpRequestHandler> handlers2) {
            BuiltInServerImpl builtInServerImpl;
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            Intrinsics.checkNotNullParameter(handlers2, (String)"handlers");
            SelectorProvider provider2 = SelectorProvider.provider();
            BuiltInServerThreadFactory factory2 = new BuiltInServerThreadFactory();
            MultiThreadIoEventLoopGroup eventLoopGroup = new MultiThreadIoEventLoopGroup(2, (ThreadFactory)factory2, NioIoHandler.newFactory(provider2));
            ServerBootstrap bootstrap2 = this.createServerBootstrap(eventLoopGroup, eventLoopGroup);
            bootstrap2.childHandler(new ChannelInitializer<Channel>(handlers2){
                final /* synthetic */ List<HttpRequestHandler> $handlers;
                {
                    this.$handlers = $handlers;
                }

                protected void initChannel(Channel ch) {
                    Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                    ChannelPipeline channelPipeline = ch.pipeline();
                    Intrinsics.checkNotNullExpressionValue((Object)channelPipeline, (String)"pipeline(...)");
                    HttpUtilsKt.addHttpServerCodec(channelPipeline);
                    ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new HttpRequestDelegator(this.$handlers)};
                    ch.pipeline().addLast(channelHandlerArray);
                }
            });
            Channel channel = this.bind(bootstrap2);
            SocketAddress socketAddress = channel.localAddress();
            Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
            InetSocketAddress it = (InetSocketAddress)socketAddress;
            boolean $i$a$-let-BuiltInServerImpl$Companion$start$32 = false;
            Pair pair = TuplesKt.to((Object)it.getAddress(), (Object)it.getPort());
            InetAddress address = (InetAddress)pair.component1();
            int port = ((Number)pair.component2()).intValue();
            Intrinsics.checkNotNull((Object)address);
            Iterable $i$a$-let-BuiltInServerImpl$Companion$start$32 = handlers2;
            Channel channel2 = channel;
            EventLoopGroup eventLoopGroup2 = eventLoopGroup;
            EventLoopGroup eventLoopGroup3 = eventLoopGroup;
            int n = port;
            InetAddress inetAddress = address;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            void var13_21 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                HttpRequestHandler it2 = (HttpRequestHandler)element$iv$iv;
                boolean bl = false;
                Pair pair2 = TuplesKt.to((Object)it2.getPath(), (Object)it2.getClass().getSimpleName());
                map2.put(pair2.getFirst(), pair2.getSecond());
            }
            Map map3 = destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            Map map4 = map3;
            Channel channel3 = channel2;
            EventLoopGroup eventLoopGroup4 = eventLoopGroup2;
            EventLoopGroup eventLoopGroup5 = eventLoopGroup3;
            int n2 = n;
            InetAddress inetAddress2 = inetAddress;
            BuiltInServerImpl it3 = builtInServerImpl = new BuiltInServerImpl(inetAddress2, n2, eventLoopGroup5, eventLoopGroup4, channel3, map4, defaultConstructorMarker);
            boolean bl = false;
            Logger.INSTANCE.info("Built-in server started. " + it3.getInfo());
            return builtInServerImpl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static final class BuiltInServerThreadFactory
        implements ThreadFactory {
            @NotNull
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                return new FastThreadLocalThread(r, "Netty Builtin Server " + this.counter.incrementAndGet());
            }
        }
    }
}

