/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.network;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract sealed class DownloadResult {
    private DownloadResult() {
    }

    public abstract boolean isSuccessful();

    public /* synthetic */ DownloadResult(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class Cancelled
    extends DownloadResult {
        @NotNull
        public static final Cancelled INSTANCE = new Cancelled();
        private static final boolean isSuccessful;

        private Cancelled() {
            super(null);
        }

        @Override
        public boolean isSuccessful() {
            return isSuccessful;
        }

        @NotNull
        public String toString() {
            return "Cancelled";
        }

        public int hashCode() {
            return -947055896;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Cancelled)) {
                return false;
            }
            Cancelled cfr_ignored_0 = (Cancelled)other;
            return true;
        }
    }

    public static final class Downloaded
    extends DownloadResult {
        @Nullable
        private final Boolean supportRanges;
        @Nullable
        private final String lastModified;
        @Nullable
        private final String eTag;
        @Nullable
        private final String contentRange;
        @Nullable
        private final String contentType;
        private final long downloadedSize;
        private final boolean isSuccessful;

        public Downloaded(@Nullable Boolean supportRanges, @Nullable String lastModified, @Nullable String eTag, @Nullable String contentRange, @Nullable String contentType, long downloadedSize) {
            super(null);
            this.supportRanges = supportRanges;
            this.lastModified = lastModified;
            this.eTag = eTag;
            this.contentRange = contentRange;
            this.contentType = contentType;
            this.downloadedSize = downloadedSize;
            this.isSuccessful = true;
        }

        @Nullable
        public final String getETag() {
            return this.eTag;
        }

        @Nullable
        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public boolean isSuccessful() {
            return this.isSuccessful;
        }

        @NotNull
        public String toString() {
            return "Downloaded(supportRanges=" + this.supportRanges + ", lastModified=" + this.lastModified + ", eTag=" + this.eTag + ", contentRange=" + this.contentRange + ", contentType=" + this.contentType + ", downloadedSize=" + this.downloadedSize + ")";
        }

        public int hashCode() {
            int result2 = this.supportRanges == null ? 0 : ((Object)this.supportRanges).hashCode();
            result2 = result2 * 31 + (this.lastModified == null ? 0 : this.lastModified.hashCode());
            result2 = result2 * 31 + (this.eTag == null ? 0 : this.eTag.hashCode());
            result2 = result2 * 31 + (this.contentRange == null ? 0 : this.contentRange.hashCode());
            result2 = result2 * 31 + (this.contentType == null ? 0 : this.contentType.hashCode());
            result2 = result2 * 31 + Long.hashCode(this.downloadedSize);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Downloaded)) {
                return false;
            }
            Downloaded downloaded = (Downloaded)other;
            if (!Intrinsics.areEqual((Object)this.supportRanges, (Object)downloaded.supportRanges)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastModified, (Object)downloaded.lastModified)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.eTag, (Object)downloaded.eTag)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.contentRange, (Object)downloaded.contentRange)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.contentType, (Object)downloaded.contentType)) {
                return false;
            }
            return this.downloadedSize == downloaded.downloadedSize;
        }
    }

    public static final class Failed
    extends DownloadResult {
        @NotNull
        private final String error;
        @Nullable
        private final Integer code;
        private final boolean hasHeaders;
        @Nullable
        private final String lastModified;
        @Nullable
        private final String eTag;
        private final boolean isSuccessful;

        public Failed(@NotNull String error2, @Nullable Integer code, boolean hasHeaders, @Nullable String lastModified, @Nullable String eTag) {
            Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
            super(null);
            this.error = error2;
            this.code = code;
            this.hasHeaders = hasHeaders;
            this.lastModified = lastModified;
            this.eTag = eTag;
        }

        public /* synthetic */ Failed(String string, Integer n, boolean bl, String string2, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = null;
            }
            if ((n2 & 4) != 0) {
                bl = false;
            }
            if ((n2 & 8) != 0) {
                string2 = null;
            }
            if ((n2 & 0x10) != 0) {
                string3 = null;
            }
            this(string, n, bl, string2, string3);
        }

        @NotNull
        public final String getError() {
            return this.error;
        }

        @Nullable
        public final Integer getCode() {
            return this.code;
        }

        @Override
        public boolean isSuccessful() {
            return this.isSuccessful;
        }

        @NotNull
        public String toString() {
            return "Failed(error=" + this.error + ", code=" + this.code + ", hasHeaders=" + this.hasHeaders + ", lastModified=" + this.lastModified + ", eTag=" + this.eTag + ")";
        }

        public int hashCode() {
            int result2 = this.error.hashCode();
            result2 = result2 * 31 + (this.code == null ? 0 : ((Object)this.code).hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.hasHeaders);
            result2 = result2 * 31 + (this.lastModified == null ? 0 : this.lastModified.hashCode());
            result2 = result2 * 31 + (this.eTag == null ? 0 : this.eTag.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Failed)) {
                return false;
            }
            Failed failed = (Failed)other;
            if (!Intrinsics.areEqual((Object)this.error, (Object)failed.error)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.code, (Object)failed.code)) {
                return false;
            }
            if (this.hasHeaders != failed.hasHeaders) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastModified, (Object)failed.lastModified)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.eTag, (Object)failed.eTag);
        }
    }

    public static final class NotConnected
    extends DownloadResult {
        @NotNull
        private final String error;
        private final boolean isSuccessful;

        public NotConnected(@NotNull String error2) {
            Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
            super(null);
            this.error = error2;
        }

        @NotNull
        public final String getError() {
            return this.error;
        }

        @Override
        public boolean isSuccessful() {
            return this.isSuccessful;
        }

        @NotNull
        public String toString() {
            return "NotConnected(error=" + this.error + ")";
        }

        public int hashCode() {
            return this.error.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NotConnected)) {
                return false;
            }
            NotConnected notConnected = (NotConnected)other;
            return Intrinsics.areEqual((Object)this.error, (Object)notConnected.error);
        }
    }

    public static final class NotModified
    extends DownloadResult {
        @NotNull
        public static final NotModified INSTANCE = new NotModified();
        private static final boolean isSuccessful = true;

        private NotModified() {
            super(null);
        }

        @Override
        public boolean isSuccessful() {
            return isSuccessful;
        }

        @NotNull
        public String toString() {
            return "NotModified";
        }

        public int hashCode() {
            return 1775922835;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NotModified)) {
                return false;
            }
            NotModified cfr_ignored_0 = (NotModified)other;
            return true;
        }
    }
}

