/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.network;

import com.jetbrains.toolbox.common.WellKnownPaths;
import com.jetbrains.toolbox.network.AuthInterceptor;
import com.jetbrains.toolbox.network.BasicDownloadManager;
import com.jetbrains.toolbox.network.CertificateManager;
import com.jetbrains.toolbox.network.CustomHeaderContributor;
import com.jetbrains.toolbox.network.DownloadManagerImpl;
import com.jetbrains.toolbox.network.DownloadManagerImpl$1$invokeSuspend$;
import com.jetbrains.toolbox.network.DownloadManagerImplKt;
import com.jetbrains.toolbox.network.DownloadSession;
import com.jetbrains.toolbox.network.DownloadSessionImpl;
import com.jetbrains.toolbox.network.FileDownloader;
import com.jetbrains.toolbox.network.FileDownloaderImpl;
import com.jetbrains.toolbox.network.ProxyAuthenticator;
import com.jetbrains.toolbox.settings.AdvancedSettings;
import com.jetbrains.toolbox.settings.NetworkSettings;
import com.jetbrains.toolbox.settings.ProxySettings;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import okhttp3.Cache;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nDownloadManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadManagerImpl.kt\ncom/jetbrains/toolbox/network/DownloadManagerImpl\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n116#2,11:168\n116#2,11:179\n1869#3:190\n1870#3:192\n1#4:191\n*S KotlinDebug\n*F\n+ 1 DownloadManagerImpl.kt\ncom/jetbrains/toolbox/network/DownloadManagerImpl\n*L\n67#1:168,11\n77#1:179,11\n131#1:190\n131#1:192\n*E\n"})
public final class DownloadManagerImpl
implements BasicDownloadManager {
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final CertificateManager certificateManager;
    @NotNull
    private final ProxyAuthenticator proxyAuthenticator;
    @NotNull
    private final List<CustomHeaderContributor> customHeaderContributors;
    @Nullable
    private final Interceptor regionUrlMapperInterceptor;
    @NotNull
    private final List<AuthInterceptor> authInterceptors;
    @NotNull
    private final WellKnownPaths wellKnownPaths;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Dispatcher dispatcher;
    @NotNull
    private final Mutex lock;
    @NotNull
    private WeakReference<DownloadSession> currentSession;
    @NotNull
    private final FileDownloader fileDownloader;

    public DownloadManagerImpl(@NotNull SettingsManager settingsManager, @NotNull CertificateManager certificateManager, @NotNull ProxyAuthenticator proxyAuthenticator, @NotNull List<? extends CustomHeaderContributor> customHeaderContributors, @Nullable Interceptor regionUrlMapperInterceptor, @NotNull List<? extends AuthInterceptor> authInterceptors, @NotNull WellKnownPaths wellKnownPaths, @NotNull FileSystem fileSystem, @NotNull Clock clock, @NotNull Dispatcher dispatcher, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)certificateManager, (String)"certificateManager");
        Intrinsics.checkNotNullParameter((Object)proxyAuthenticator, (String)"proxyAuthenticator");
        Intrinsics.checkNotNullParameter(customHeaderContributors, (String)"customHeaderContributors");
        Intrinsics.checkNotNullParameter(authInterceptors, (String)"authInterceptors");
        Intrinsics.checkNotNullParameter((Object)wellKnownPaths, (String)"wellKnownPaths");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.settingsManager = settingsManager;
        this.certificateManager = certificateManager;
        this.proxyAuthenticator = proxyAuthenticator;
        this.customHeaderContributors = customHeaderContributors;
        this.regionUrlMapperInterceptor = regionUrlMapperInterceptor;
        this.authInterceptors = authInterceptors;
        this.wellKnownPaths = wellKnownPaths;
        this.fileSystem = fileSystem;
        this.clock = clock;
        this.dispatcher = dispatcher;
        this.lock = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.currentSession = new WeakReference<Object>(null);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DownloadManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Flow $this$map$iv = (Flow)this.this$0.settingsManager.getSettings();
                        boolean $i$f$map = false;
                        Flow $this$unsafeTransform$iv$iv = $this$map$iv;
                        boolean $i$f$unsafeTransform = false;
                        boolean $i$f$unsafeFlow = false;
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)FlowKt.drop((Flow)FlowKt.distinctUntilChanged((Flow)((Flow)new Flow<Triple<? extends ProxySettings, ? extends NetworkSettings, ? extends AdvancedSettings>>($this$unsafeTransform$iv$iv){
                            final /* synthetic */ Flow $this_unsafeTransform$inlined;
                            {
                                this.$this_unsafeTransform$inlined = flow2;
                            }

                            public Object collect(FlowCollector collector, Continuation $completion) {
                                Continuation continuation = $completion;
                                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                                boolean bl = false;
                                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240){
                                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                                    {
                                        this.$this_unsafeFlow = $receiver;
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object emit(Object value, Continuation $completion) {
                                        if (!($completion instanceof 1$invokeSuspend$$inlined$map$1$2$1)) ** GOTO lbl-1000
                                        var3_3 = $completion;
                                        if ((var3_3.label & -2147483648) != 0) {
                                            var3_3.label -= -2147483648;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            $continuation = new ContinuationImpl(this, $completion){
                                                /* synthetic */ Object result;
                                                int label;
                                                Object L$0;
                                                final /* synthetic */ 1$invokeSuspend$$inlined$map$1$2 this$0;
                                                Object L$1;
                                                Object L$2;
                                                Object L$3;
                                                int I$0;
                                                {
                                                    this.this$0 = this$0;
                                                    super($completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    this.result = $result;
                                                    this.label |= Integer.MIN_VALUE;
                                                    return this.this$0.emit(null, (Continuation)this);
                                                }
                                            };
                                        }
                                        $result = $continuation.result;
                                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch ($continuation.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                var6_6 = $continuation;
                                                var7_8 = value;
                                                $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = 0;
                                                var10_14 = $this$map_u24lambda_u245;
                                                var11_15 = (Continuation)$continuation;
                                                it = (SelfSettings)value;
                                                $i$a$-map-DownloadManagerImpl$1$1 = false;
                                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)value);
                                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)value);
                                                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$map_u24lambda_u245);
                                                $continuation.I$0 = $i$a$-unsafeTransform-FlowKt__TransformKt$map$1;
                                                $continuation.label = 1;
                                                v0 = var10_14.emit((Object)new Triple((Object)it.getProxy(), (Object)it.getNetwork(), (Object)it.getAdvanced()), (Continuation)$continuation);
                                                if (v0 == var5_5) {
                                                    return var5_5;
                                                }
                                                ** GOTO lbl38
                                            }
                                            case 1: {
                                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = $continuation.I$0;
                                                $this$map_u24lambda_u245 = (FlowCollector)$continuation.L$3;
                                                value = $continuation.L$2;
                                                $completion = $continuation.L$1;
                                                value = $continuation.L$0;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl38:
                                                // 2 sources

                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                }, $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        })), (int)1), (Function2)((Function2)new Function2<Triple<? extends ProxySettings, ? extends NetworkSettings, ? extends AdvancedSettings>, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ DownloadManagerImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Logger.INSTANCE.info("Resetting download session on settings change");
                                        this.label = 1;
                                        Object object2 = this.this$0.resetSession((Continuation<? super Unit>)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Triple<ProxySettings, NetworkSettings, AdvancedSettings> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DownloadManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.certificateManager.getCertificatesChanged()), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ DownloadManagerImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Logger.INSTANCE.debug("Resetting download session on certificates change");
                                        this.label = 1;
                                        Object object2 = this.this$0.resetSession((Continuation<? super Unit>)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.fileDownloader = new FileDownloaderImpl(this, this.fileSystem, coroutineScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object resetSession(Continuation<? super Unit> $completion) {
        if (!($completion instanceof resetSession.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ DownloadManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DownloadManagerImpl.access$resetSession(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.lock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                try {
                    $i$a$-withLock$default-DownloadManagerImpl$resetSession$2 = false;
                    try {
                        var6_11 = this.currentSession.get();
                        v1 = var6_11 instanceof Closeable != false ? (Closeable)var6_11 : null;
                        if (v1 != null) {
                            v1.close();
                        }
                    }
                    catch (Exception e) {
                        Logger.INSTANCE.warn((Throwable)e, "Failed to close session");
                    }
                    this.currentSession = new WeakReference<Object>(null);
                    var7_13 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object createSession(@NotNull Continuation<? super DownloadSession> $completion) {
        if (!($completion instanceof createSession.1)) ** GOTO lbl-1000
        var10_2 = $completion;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ DownloadManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createSession((Continuation<? super DownloadSession>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.lock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                try {
                    $i$a$-withLock$default-DownloadManagerImpl$createSession$2 = false;
                    session = (DownloadSession)this.currentSession.get();
                    if (session != null) {
                        v1 = session;
                    } else {
                        Logger.INSTANCE.debug("Starting new download session");
                        result = new DownloadSessionImpl(this.settingsManager, this.certificateManager.currentContext(), this.proxyAuthenticator, this.getDownloadDirectory(), this.regionUrlMapperInterceptor, this.authInterceptors, this.customHeaderContributors, this.dispatcher);
                        this.currentSession = new WeakReference<DownloadSessionImpl>(result);
                        v1 = result;
                    }
                    var8_13 = v1;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var8_13;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public FileDownloader getFileDownloader() {
        return this.fileDownloader;
    }

    @Override
    @NotNull
    public Path getDownloadDirectory() {
        return this.wellKnownPaths.getToolboxCacheLocation().resolve("download");
    }

    @Override
    @Nullable
    public Object cleanupDownloadDirectory(boolean force, @NotNull Continuation<? super Unit> $completion) {
        Cache cache2;
        Logger.INSTANCE.info("Starting to clean download directory");
        Object object = (DownloadSession)this.currentSession.get();
        Cache cache3 = object != null && (object = object.getHttpClient()) != null ? ((OkHttpClient)object).cache() : (cache2 = null);
        if (cache2 != null) {
            Iterator<String> urlIterator = cache2.urls();
            while (urlIterator.hasNext()) {
                String url = urlIterator.next();
                try {
                    urlIterator.remove();
                }
                catch (Exception e) {
                    Logger.INSTANCE.debug("Failed to remove url '" + url + "' from cache: " + e.getMessage());
                }
            }
        }
        long cacheTTL = ((SelfSettings)this.settingsManager.getSettings().getValue()).getInternal().getDownloadCacheTTL-UwyO8pc();
        Instant threshold = this.clock.now().minus-LRDsOJo(cacheTTL);
        List cachedFiles = this.fileSystem.listOrNull(this.getDownloadDirectory());
        if (cachedFiles == null) {
            Logger.INSTANCE.warn("List of the files inside the download directory can't be obtained");
        } else if (cachedFiles.isEmpty()) {
            Logger.INSTANCE.info("There are no files in the download directory");
        }
        List list2 = cachedFiles;
        if (list2 != null) {
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Instant lastModified;
                Path it = (Path)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.name(), (Object)"journal")) continue;
                if (force) {
                    try {
                        this.fileSystem.deleteRecursively(it);
                    }
                    catch (IOException e) {
                        Logger.INSTANCE.error((Throwable)e, "Can't remove " + it + " from the download cache");
                    }
                    continue;
                }
                Object object2 = this.fileSystem.metadataOrNull(it);
                if (object2 != null && (object2 = object2.getLastModifiedAtMillis()) != null) {
                    Object object3 = object2;
                    Instant.Companion companion = Instant.Companion;
                    long p0 = ((Number)object3).longValue();
                    boolean bl2 = false;
                    v4 = companion.fromEpochMilliseconds(p0);
                } else {
                    v4 = lastModified = null;
                }
                if (lastModified == null) {
                    Logger.INSTANCE.info("lastModifiedAtMillis can't be obtained for " + it);
                }
                if (lastModified == null || lastModified.compareTo(threshold) >= 0) continue;
                try {
                    this.fileSystem.deleteRecursively(it);
                }
                catch (IOException e) {
                    Logger.INSTANCE.error((Throwable)e, "Can't remove " + it + " from the download cache");
                }
            }
        }
        Logger.INSTANCE.info("Finishing to clean download directory");
        return Unit.INSTANCE;
    }

    @Override
    public long getNetworkDownloadTimeout-UwyO8pc() {
        Duration duration = Duration.box-impl((long)((SelfSettings)this.settingsManager.getSettings().getValue()).getNetwork().getTimeout-UwyO8pc());
        long it = duration.unbox-impl();
        boolean bl = false;
        Object object = Duration.compareTo-LRDsOJo((long)it, (long)Duration.Companion.getZERO-UwyO8pc()) > 0 ? duration : null;
        return object != null ? object.unbox-impl() : DownloadManagerImplKt.getDEFAULT_DOWNLOAD_TIMEOUT();
    }
}

