/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.markdown.renderer.code.higlighting.textmate;

import com.intellij.util.xml.dom.XmlDomReader;
import com.intellij.util.xml.dom.XmlElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReaderCore;
import org.jetbrains.plugins.textmate.plist.PlistValueType;

public final class XmlPlistReader
implements PlistReaderCore {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Plist read(@NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        return XmlPlistReader.Companion.internalRead(XmlDomReader.readXmlAsModel(bytes2));
    }

    @SourceDebugExtension(value={"SMAP\nXmlPlistReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlPlistReader.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/XmlPlistReader$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1617#2,9:101\n1869#2:110\n1870#2:112\n1626#2:113\n1#3:111\n*S KotlinDebug\n*F\n+ 1 XmlPlistReader.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/XmlPlistReader$Companion\n*L\n73#1:101,9\n73#1:110\n73#1:112\n73#1:113\n73#1:111\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Plist internalRead(XmlElement root) {
            XmlElement dictElement;
            if (root.children.isEmpty()) {
                return Plist.Companion.getEMPTY_PLIST();
            }
            if (!Intrinsics.areEqual((Object)"plist", (Object)root.name)) {
                throw new IOException("Unknown xml format. Root element is '" + root.name + "'");
            }
            XmlElement xmlElement = dictElement = root.getChild("dict");
            return xmlElement != null ? this.readDict(xmlElement).getPlist() : Plist.Companion.getEMPTY_PLIST();
        }

        private final PListValue readDict(XmlElement dictElement) {
            Map map2;
            List<XmlElement> children = dictElement.children;
            Map $this$readDict_u24lambda_u240 = map2 = MapsKt.createMapBuilder();
            boolean bl = false;
            for (int i2 = 0; i2 < children.size(); ++i2) {
                PListValue value2;
                XmlElement keyElement = children.get(i2);
                if (!Intrinsics.areEqual((Object)"key", (Object)keyElement.name)) continue;
                String attributeKey = keyElement.content;
                ++i2;
                if (attributeKey == null) continue;
                if (Companion.readValue(attributeKey, children.get(i2)) == null) continue;
                boolean bl2 = false;
                $this$readDict_u24lambda_u240.put(attributeKey, value2);
            }
            Map map3 = MapsKt.build((Map)map2);
            return PListValue.Companion.value(new Plist(map3), PlistValueType.DICT);
        }

        private final PListValue readValue(String key, XmlElement valueElement) {
            String type2 = valueElement.name;
            return Intrinsics.areEqual((Object)type2, (Object)"dict") ? this.readDict(valueElement) : (Intrinsics.areEqual((Object)type2, (Object)"array") ? this.readArray(key, valueElement) : this.readBasicValue(type2, valueElement));
        }

        /*
         * WARNING - void declaration
         */
        private final PListValue readArray(String key, XmlElement element) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = element.children;
            PListValue.Companion companion = PListValue.Companion;
            boolean $i$f$mapNotNull = false;
            void var5_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PListValue it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                XmlElement it = (XmlElement)element$iv$iv;
                boolean bl2 = false;
                if (Companion.readValue(key, it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return companion.value((List)destination$iv$iv, PlistValueType.ARRAY);
        }

        private final PListValue readBasicValue(String type2, XmlElement valueElement) {
            String content2 = valueElement.content;
            return switch (type2) {
                case "string" -> {
                    String v0 = content2;
                    if (v0 == null) {
                        v0 = "";
                    }
                    yield PListValue.Companion.value(v0, PlistValueType.STRING);
                }
                case "true" -> PListValue.Companion.value(true, PlistValueType.BOOLEAN);
                case "false" -> PListValue.Companion.value(false, PlistValueType.BOOLEAN);
                case "integer" -> {
                    Object v2 = content2;
                    yield PListValue.Companion.value(v2 != null && (v2 = StringsKt.toIntOrNull((String)v2)) != null ? (Integer)v2 : 0, PlistValueType.INTEGER);
                }
                case "real" -> {
                    Object v3 = content2;
                    yield PListValue.Companion.value(v3 != null && (v3 = StringsKt.toDoubleOrNull((String)v3)) != null ? (Double)v3 : 0.0, PlistValueType.REAL);
                }
                default -> null;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

