/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.markdown.renderer.code.higlighting.textmate;

import com.intellij.textmate.joni.JoniRegexFactory;
import com.jetbrains.toolbox.common.code.LanguageId;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTableCore;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateCachingSyntaxMatcherCore;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateCachingSyntaxMatcherCoreKt;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerCore;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateSyntaxMatcherImpl;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateCachingSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateCachingSelectorWeigherKt;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigherImpl;
import org.jetbrains.plugins.textmate.regex.RememberingLastMatchRegexFactory;
import org.jetbrains.plugins.textmate.regex.TextMateCachingRegexProvider;
import org.jetbrains.plugins.textmate.regex.TextMateCachingRegexProviderKt;

public final class TextMateLexerProvider {
    @NotNull
    private final LanguageId languageId;
    @NotNull
    private final CharSequence scope;
    @NotNull
    private final TextMateSyntaxTableCore table;
    public static final int $stable = 8;

    public TextMateLexerProvider(@NotNull LanguageId languageId, @NotNull CharSequence scope2, @NotNull TextMateSyntaxTableCore table) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.languageId = languageId;
        this.scope = scope2;
        this.table = table;
    }

    @NotNull
    public final TextMateLexerCore getLexer() {
        TextMateLanguageDescriptor descriptor = this.table.getLanguageDescriptor(this.scope);
        TextMateCachingRegexProvider regexFactory = TextMateCachingRegexProviderKt.cachingRegexProvider(new RememberingLastMatchRegexFactory(new JoniRegexFactory()));
        TextMateCachingSelectorWeigher weigher = TextMateCachingSelectorWeigherKt.caching(new TextMateSelectorWeigherImpl());
        TextMateCachingSyntaxMatcherCore matcher = TextMateCachingSyntaxMatcherCoreKt.caching(new TextMateSyntaxMatcherImpl(regexFactory, weigher));
        return new TextMateLexerCore(descriptor, matcher, -1, false);
    }
}

