/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.markdown.renderer.code.higlighting.textmate;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.jetbrains.toolbox.common.code.LanguageId;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.CodeHighlightingEngine;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.CodeHighlightingToken;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.CodeHighlightingType;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.textmate.BundleCollection;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.textmate.TextMateLexerProviderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerCore;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextmateToken;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nTextMateHighlighting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateHighlighting.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/TextMateHighlighting\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n*L\n1#1,94:1\n170#2,6:95\n1617#3,9:101\n1869#3:110\n1870#3:112\n1626#3:113\n1056#3:121\n1#4:111\n7#5,7:114\n*S KotlinDebug\n*F\n+ 1 TextMateHighlighting.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/TextMateHighlighting\n*L\n73#1:95,6\n78#1:101,9\n78#1:110\n78#1:112\n78#1:113\n34#1:121\n78#1:111\n59#1:114,7\n*E\n"})
public final class TextMateHighlighting
implements CodeHighlightingEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BundleCollection bundle;
    @NotNull
    private final LoadingCache<LanguageId, Result<TextMateLexerCore>> lexers;
    public static final int $stable = 8;
    @NotNull
    private static final Map<Set<String>, CodeHighlightingType> mapping;
    @NotNull
    private static final List<String> selectors;

    public TextMateHighlighting(@NotNull BundleCollection bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        this.bundle = bundle;
        LoadingCache loadingCache = Caffeine.newBuilder().softValues().build(arg_0 -> TextMateHighlighting.lexers$lambda$1(arg_0 -> TextMateHighlighting.lexers$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.lexers = loadingCache;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CodeHighlightingEngine.HighlightedCode highlight(@NotNull LanguageId languageId, @NotNull String code, @NotNull CodeHighlightingEngine.HighlightedCode previous) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        if (Intrinsics.areEqual((Object)previous.getCode(), (Object)code)) {
            return previous;
        }
        Object object = this.lexers.get((Object)languageId);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Object object2 = ((Result)object).unbox-impl();
        TextMateLexerCore lexer = (TextMateLexerCore)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (lexer != null) {
            int n;
            block6: {
                CharSequence $this$indexOfLast$iv = previous.getCode();
                boolean $i$f$indexOfLast = false;
                int n2 = $this$indexOfLast$iv.length() + -1;
                if (0 <= n2) {
                    do {
                        int index$iv = n2--;
                        char it = $this$indexOfLast$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(it == '\n')) continue;
                        n = index$iv;
                        break block6;
                    } while (0 <= n2);
                }
                n = -1;
            }
            int offset = n + 1;
            String string = code.substring(RangesKt.coerceIn((int)offset, (int)0, (int)code.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String toHighlight = string;
            if (((CharSequence)toHighlight).length() > 0) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                List<TextmateToken> tokens = TextMateLexerProviderKt.tokenize(lexer, toHighlight);
                Iterable iterable = tokens;
                Collection collection = previous.getTokens();
                LanguageId languageId2 = languageId;
                String string2 = code;
                boolean $i$f$mapNotNull = false;
                void it = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    CodeHighlightingToken it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    TextmateToken it2 = (TextmateToken)element$iv$iv;
                    boolean bl2 = false;
                    if (this.toHighlightingToken(it2, offset) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                List list3 = CollectionsKt.plus((Collection)collection, (Iterable)list2);
                LanguageId languageId3 = languageId2;
                String string3 = string2;
                return new CodeHighlightingEngine.HighlightedCode(string3, languageId3, list3);
            }
        }
        return new CodeHighlightingEngine.HighlightedCode(code, languageId, previous.getTokens());
    }

    private final CodeHighlightingToken toHighlightingToken(TextmateToken $this$toHighlightingToken, int offset) {
        CodeHighlightingType codeHighlightingType = TextMateHighlighting.Companion.select($this$toHighlightingToken.getScope());
        if (codeHighlightingType == null) {
            return null;
        }
        return new CodeHighlightingToken(new IntRange(offset + $this$toHighlightingToken.getStartOffset(), offset + $this$toHighlightingToken.getEndOffset()), codeHighlightingType);
    }

    private static final Result lexers$lambda$0(TextMateHighlighting this$0, LanguageId it) {
        Object object;
        if (this$0.bundle.isLexerAvailable(it.getName())) {
            Object object2;
            boolean $i$f$catching = false;
            try {
                boolean bl = false;
                object2 = Result.constructor-impl((Object)this$0.bundle.createLexerProvider(it.getName()).getLexer());
            }
            catch (CancellationException c$iv) {
                throw c$iv;
            }
            catch (Throwable t$iv) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
            }
            Object object3 = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable != null) {
                Throwable throwable2;
                Throwable throwable3 = throwable2 = throwable;
                boolean bl = false;
                Logger.INSTANCE.error(throwable3, "Failed to load lexer provider");
            }
            object = object3;
        } else {
            Logger.INSTANCE.debug("Lexer for " + it.getName() + " is not available");
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Throwable)((Object)new AssertionError((Object)"Lexer provider not found")))));
        }
        return Result.box-impl((Object)object);
    }

    private static final Result lexers$lambda$1(Function1 $tmp0, Object p0) {
        return (Result)$tmp0.invoke(p0);
    }

    static {
        Pair[] pairArray = new Pair[8];
        Object[] objectArray = new String[]{"comment", "comment.line", "comment.block", "comment.documentation"};
        pairArray[0] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), (Object)((Object)CodeHighlightingType.COMMENT));
        pairArray[1] = TuplesKt.to((Object)SetsKt.setOf((Object)"string"), (Object)((Object)CodeHighlightingType.STRING));
        objectArray = new String[]{"constant", "constant.number", "constant.numeric", "constant.character.escape", "constant.character.entity"};
        pairArray[2] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), (Object)((Object)CodeHighlightingType.CONSTANT));
        objectArray = new String[]{"keyword", "keyword.function", "keyword.declaration", "keyword.operator", "storage", "storage.type"};
        pairArray[3] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), (Object)((Object)CodeHighlightingType.KEYWORD));
        pairArray[4] = TuplesKt.to((Object)SetsKt.setOf((Object)"entity.name.function"), (Object)((Object)CodeHighlightingType.FUNCTION_NAME));
        objectArray = new String[]{"entity.name", "entity.name.class"};
        pairArray[5] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), (Object)((Object)CodeHighlightingType.CLASS_NAME));
        pairArray[6] = TuplesKt.to((Object)SetsKt.setOf((Object)"entity"), (Object)((Object)CodeHighlightingType.IDENTIFIER));
        objectArray = new String[]{"variable", "variable.parameter"};
        pairArray[7] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), (Object)((Object)CodeHighlightingType.VARIABLE));
        mapping = MapsKt.mapOf((Pair[])pairArray);
        Iterable $this$sortedBy$iv = CollectionsKt.flatten((Iterable)mapping.keySet());
        boolean $i$f$sortedBy = false;
        selectors = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                String it = (String)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(-it.length());
                it = (String)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(-it.length()));
            }
        });
    }

    @SourceDebugExtension(value={"SMAP\nTextMateHighlighting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateHighlighting.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/TextMateHighlighting$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n295#2,2:95\n1#3:97\n*S KotlinDebug\n*F\n+ 1 TextMateHighlighting.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/TextMateHighlighting$Companion\n*L\n39#1:95,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final CodeHighlightingType select(TextMateScope scopes) {
            Object v4;
            block5: {
                Object v2;
                Object it;
                block4: {
                    if (scopes == null) {
                        return null;
                    }
                    Iterable $this$firstOrNull$iv = selectors;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (String)element$iv;
                        boolean bl = false;
                        CharSequence charSequence = scopes.getScopeName();
                        boolean bl2 = charSequence != null ? StringsKt.startsWith$default((CharSequence)charSequence, (CharSequence)((CharSequence)it), (boolean)false, (int)2, null) : false;
                        if (!bl2) continue;
                        v2 = element$iv;
                        break block4;
                    }
                    v2 = null;
                }
                String string = v2;
                if (string == null) {
                    return this.select(scopes.getParent());
                }
                String selector = string;
                Iterable iterable = mapping.entrySet();
                for (Object t2 : iterable) {
                    it = (Map.Entry)t2;
                    boolean bl = false;
                    if (!((Set)it.getKey()).contains(selector)) continue;
                    v4 = t2;
                    break block5;
                }
                v4 = null;
            }
            Map.Entry entry = v4;
            return entry != null ? (CodeHighlightingType)((Object)entry.getValue()) : null;
        }

        @NotNull
        public final CodeHighlightingEngine create() {
            try {
                return new TextMateHighlighting(BundleCollection.Companion.read());
            }
            catch (Exception e) {
                Logger.INSTANCE.error((Throwable)e);
                return CodeHighlightingEngine.Empty.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

