/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.markdown.renderer.code.higlighting.textmate;

import com.jetbrains.toolbox.markdown.utils.Resources;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nCustomBundleReaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomBundleReaders.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/ResourcePath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,331:1\n774#2:332\n865#2,2:333\n1740#2,3:335\n*S KotlinDebug\n*F\n+ 1 CustomBundleReaders.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/ResourcePath\n*L\n55#1:332\n55#1:333,2\n64#1:335,3\n*E\n"})
final class ResourcePath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> parts;

    public ResourcePath(@NotNull List<String> parts) {
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        this.parts = parts;
    }

    @NotNull
    public final String name() {
        return (String)CollectionsKt.last(this.parts);
    }

    @NotNull
    public final String absolute() {
        return CollectionsKt.joinToString$default((Iterable)this.parts, (CharSequence)"/", (CharSequence)"/", null, (int)0, null, null, (int)60, null);
    }

    @Nullable
    public final InputStream streamOrNull() {
        return ResourcePath.class.getResourceAsStream(this.absolute());
    }

    @NotNull
    public final InputStream stream() {
        InputStream inputStream = this.streamOrNull();
        if (inputStream == null) {
            throw new IllegalStateException(("Can't find " + this.absolute()).toString());
        }
        return inputStream;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> lines() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = StringsKt.lines((CharSequence)Resources.INSTANCE.text(this.absolute()));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ResourcePath resolve(String ... path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String[] stringArray = Arrays.copyOf(path2, path2.length);
        Path path3 = Paths.get(this.absolute(), Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        Path path4 = path3;
        CharSequence charSequence = ((Object)path4.normalize()).toString();
        String[] stringArray2 = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.separator, (String)"separator");
        return Companion.of(StringsKt.split$default((CharSequence)charSequence, (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
    }

    public final boolean endsWith(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return StringsKt.endsWith((String)this.absolute(), (String)path2, (boolean)true);
    }

    public final boolean contains(@NotNull ResourcePath path2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)path2.parts, (Iterable)this.parts);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getFirst(), (Object)it.getSecond())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final ResourcePath div(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String[] stringArray = new String[]{path2};
        return this.resolve(stringArray);
    }

    @NotNull
    public String toString() {
        return "ResourcePath(parts=" + this.parts + ")";
    }

    public int hashCode() {
        return ((Object)this.parts).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResourcePath)) {
            return false;
        }
        ResourcePath resourcePath = (ResourcePath)other;
        return Intrinsics.areEqual(this.parts, resourcePath.parts);
    }

    @SourceDebugExtension(value={"SMAP\nCustomBundleReaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomBundleReaders.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/ResourcePath$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,331:1\n1374#2:332\n1460#2,5:333\n774#2:338\n865#2,2:339\n774#2:341\n865#2,2:342\n*S KotlinDebug\n*F\n+ 1 CustomBundleReaders.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/ResourcePath$Companion\n*L\n42#1:332\n42#1:333,5\n42#1:338\n42#1:339,2\n42#1:341\n42#1:342,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourcePath of(@NotNull List<String> paths) {
            Iterable $this$filterTo$iv$iv;
            String it;
            Iterable $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            Iterable $this$flatMap$iv = paths;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                String[] stringArray = new String[]{"/"};
                Iterable list$iv$iv = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)"."))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            return new ResourcePath(list2);
        }

        @NotNull
        public final ResourcePath of(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return this.of(CollectionsKt.listOf((Object)path2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

