/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.markdown.renderer.code.higlighting.textmate;

import com.jetbrains.toolbox.common.code.LanguageId;
import com.jetbrains.toolbox.common.code.LanguageManager;
import com.jetbrains.toolbox.common.code.Languages;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.textmate.BundleCollection;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.textmate.CustomBundleReadersKt;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.textmate.ResourcePath;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.textmate.TextMateLexerProvider;
import com.jetbrains.toolbox.markdown.renderer.code.higlighting.textmate.XmlPlistReader;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.bundles.BundleType;
import org.jetbrains.plugins.textmate.bundles.TextMateBundleReader;
import org.jetbrains.plugins.textmate.bundles.TextMateFileNameMatcher;
import org.jetbrains.plugins.textmate.bundles.TextMateGrammar;
import org.jetbrains.plugins.textmate.bundles.TextMateResourceReader;
import org.jetbrains.plugins.textmate.bundles.VSCBundleReaderKt;
import org.jetbrains.plugins.textmate.language.TextMateConcurrentMapInterner;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTableBuilder;
import org.jetbrains.plugins.textmate.plist.JsonOrXmlPlistReader;
import org.jetbrains.plugins.textmate.plist.JsonPlistReader;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReaderCore;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nCustomBundleReaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomBundleReaders.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/BundleCollection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n*L\n1#1,331:1\n1761#2,3:332\n774#2:335\n865#2,2:336\n1761#2,3:338\n774#2:344\n865#2,2:345\n1563#2:359\n1634#2,3:360\n1563#2:363\n1634#2,3:364\n1#3:341\n7#4,2:342\n9#4,5:347\n7#4,7:352\n*S KotlinDebug\n*F\n+ 1 CustomBundleReaders.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/BundleCollection\n*L\n80#1:332,3\n147#1:335\n147#1:336,2\n156#1:338,3\n220#1:344\n220#1:345,2\n302#1:359\n302#1:360,3\n306#1:363\n306#1:364,3\n219#1:342,2\n219#1:347,5\n289#1:352,7\n*E\n"})
public final class BundleCollection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ResourcePath> paths;
    @NotNull
    private final List<String> langs;
    public static final int $stable = 8;
    @NotNull
    private static final ResourcePath prefix = CustomBundleReadersKt.access$div("code", "bundles");

    private BundleCollection(List<ResourcePath> paths, List<String> langs) {
        this.paths = paths;
        this.langs = langs;
    }

    public final boolean isLexerAvailable(@NotNull String name2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Iterable $this$any$iv = this.langs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)name2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final TextMateLexerProvider createLexerProvider(@NotNull String name2) {
        CharSequence charSequence;
        TextMateSyntaxTableBuilder stBuilder;
        block9: {
            TextMateBundleReader textMateBundleReader;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            ResourcePath bundlePath = prefix.div(name2);
            BundleType bundleType = this.detectBundleType(bundlePath);
            switch (WhenMappings.$EnumSwitchMapping$0[bundleType.ordinal()]) {
                case 1: {
                    textMateBundleReader = this.readTextMateBundle(bundlePath);
                    break;
                }
                case 2: {
                    textMateBundleReader = this.readSublimeBundle(bundlePath);
                    break;
                }
                case 3: {
                    textMateBundleReader = VSCBundleReaderKt.readVSCBundle(new JsonOrXmlPlistReader(new JsonPlistReader(), new XmlPlistReader()), new TextMateResourceReader(bundlePath){
                        final /* synthetic */ ResourcePath $bundlePath;
                        {
                            this.$bundlePath = $bundlePath;
                        }

                        public byte[] read(String relativePath) {
                            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
                            return this.$bundlePath.div(relativePath).stream().readAllBytes();
                        }
                    });
                    if (textMateBundleReader != null) break;
                    throw new IllegalStateException("Invalid VSC bundle".toString());
                }
                case 4: {
                    throw new IllegalStateException(("Bundle isn't found. name: " + name2).toString());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            TextMateBundleReader reader2 = textMateBundleReader;
            stBuilder = new TextMateSyntaxTableBuilder(new TextMateConcurrentMapInterner());
            for (TextMateGrammar it : reader2.readGrammars()) {
                boolean bl = false;
                charSequence = stBuilder.addSyntax((Plist)it.getPlist().getValue());
                if (charSequence == null) {
                    continue;
                }
                break block9;
            }
            charSequence = null;
        }
        if (charSequence == null) {
            throw new NoSuchElementException("No element of the sequence was transformed to a non-null value.");
        }
        CharSequence rootScope = charSequence;
        LanguageId language = this.getLanguage(name2);
        return new TextMateLexerProvider(language, rootScope, stBuilder.build());
    }

    private final LanguageId getLanguage(String name2) {
        switch (name2) {
            case "bat": {
                return Languages.INSTANCE.getBatch();
            }
            case "markdown-basics": {
                return Languages.INSTANCE.getMarkdown();
            }
            case "restructuredtext": {
                return Languages.INSTANCE.getRst();
            }
            case "shellscript": {
                return Languages.INSTANCE.getShell();
            }
            case "latex": {
                return Languages.INSTANCE.getTex();
            }
            case "typescript-basics": {
                return Languages.INSTANCE.getTypeScript();
            }
        }
        return LanguageManager.INSTANCE.registerLanguage(name2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ResourcePath> list(ResourcePath folder) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.paths;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResourcePath it = (ResourcePath)element$iv$iv;
            boolean bl = false;
            if (!folder.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean exists(ResourcePath path2) {
        return this.paths.contains(path2);
    }

    private final BundleType detectBundleType(ResourcePath directory) {
        BundleType bundleType;
        if (this.exists(directory.div("package.json"))) {
            bundleType = BundleType.VSCODE;
        } else {
            boolean bl;
            block5: {
                Iterable $this$any$iv = this.list(directory);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ResourcePath it = (ResourcePath)element$iv;
                        boolean bl2 = false;
                        if (!(it.endsWith(".tmLanguage") || it.endsWith(".tmPreferences"))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            bundleType = bl ? BundleType.SUBLIME : (this.exists(directory.div("info.plist")) ? BundleType.TEXTMATE : BundleType.UNDEFINED);
        }
        return bundleType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TextMateBundleReader readTextMateBundle(ResourcePath path2) {
        Plist plist;
        JsonOrXmlPlistReader plistReader = new JsonOrXmlPlistReader(new JsonPlistReader(), new XmlPlistReader());
        String[] stringArray = new String[]{"info.plist"};
        ResourcePath infoPlistPath = path2.resolve(stringArray);
        AutoCloseable autoCloseable = infoPlistPath.stream();
        int n = 8192;
        autoCloseable = autoCloseable instanceof BufferedInputStream ? (BufferedInputStream)autoCloseable : new BufferedInputStream((InputStream)autoCloseable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream it = (BufferedInputStream)autoCloseable;
            boolean bl = false;
            byte[] byArray = it.readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            plist = plistReader.read(byArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Plist infoPlist = plist;
        String string = infoPlist.getPlistValue("name", path2.name()).getString();
        if (string == null) {
            throw new IllegalStateException(("Can't read bundle name for " + path2.absolute()).toString());
        }
        String bundleName = string;
        return new TextMateBundleReader(bundleName, this, path2, plistReader){
            private final String bundleName;
            final /* synthetic */ BundleCollection this$0;
            final /* synthetic */ ResourcePath $path;
            final /* synthetic */ JsonOrXmlPlistReader $plistReader;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                this.$plistReader = $plistReader;
                this.bundleName = $bundleName;
            }

            public Sequence<TextMateGrammar> readGrammars() {
                String[] stringArray = new String[]{"Syntaxes"};
                return SequencesKt.map((Sequence)BundleCollection.access$readPlistInDirectory(this.this$0, this.$path.resolve(stringArray), this.$plistReader, readTextMateBundle.1::readGrammars$lambda$0), readTextMateBundle.1::readGrammars$lambda$1);
            }

            private static final boolean readGrammars$lambda$0(ResourcePath it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.endsWith("tmLanguage") || it.endsWith("plist") || it.endsWith("tmLanguage.json");
            }

            /*
             * WARNING - void declaration
             */
            private static final TextMateGrammar readGrammars$lambda$1(Plist plist) {
                void $this$flatMapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
                Iterable $this$flatMap$iv = CollectionsKt.filterNotNull((Iterable)plist.getPlistValue("fileTypes", CollectionsKt.emptyList()).getStringArray());
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    String s = (String)element$iv$iv;
                    boolean bl = false;
                    Object[] objectArray = new TextMateFileNameMatcher[]{new TextMateFileNameMatcher.Name(s), new TextMateFileNameMatcher.Extension(s)};
                    Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List fileNameMatchers = (List)destination$iv$iv;
                PListValue pListValue = plist.getPlistValue("firstLineMatch");
                String firstLinePattern = pListValue != null ? pListValue.getString() : null;
                return new TextMateGrammar(fileNameMatchers, firstLinePattern, (Lazy<Plist>)LazyKt.lazy(() -> readTextMateBundle.1.readGrammars$lambda$1$1(plist)), null, null);
            }

            private static final Plist readGrammars$lambda$1$1(Plist $plist) {
                return $plist;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<Plist> readPlistInDirectory(ResourcePath directory, PlistReaderCore plistReader, Function1<? super ResourcePath, Boolean> filter2) {
        Object object;
        Object object2;
        boolean $i$f$catching = false;
        try {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = this.list(directory);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                if (!((Boolean)filter2.invoke(element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object2 = Result.constructor-impl((Object)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((List)destination$iv$iv)), arg_0 -> BundleCollection.readPlistInDirectory$lambda$1$0(this, plistReader, arg_0)));
        }
        catch (CancellationException c$iv) {
            throw c$iv;
        }
        catch (Throwable t$iv) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
        }
        Object object3 = object2;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable == null) {
            object = object3;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            if (!(e instanceof NoSuchFileException)) {
                Logger.INSTANCE.warn(e, "Can't load plists from directory: " + directory.absolute());
            }
            object = SequencesKt.emptySequence();
        }
        return (Sequence)object;
    }

    private final TextMateBundleReader readSublimeBundle(ResourcePath path2) {
        JsonOrXmlPlistReader plistReader = new JsonOrXmlPlistReader(new JsonPlistReader(), new XmlPlistReader());
        return new TextMateBundleReader(path2, this, plistReader){
            private final String bundleName;
            final /* synthetic */ ResourcePath $path;
            final /* synthetic */ BundleCollection this$0;
            final /* synthetic */ JsonOrXmlPlistReader $plistReader;
            {
                this.$path = $path;
                this.this$0 = $receiver;
                this.$plistReader = $plistReader;
                this.bundleName = $path.name();
            }

            public Sequence<TextMateGrammar> readGrammars() {
                return SequencesKt.map((Sequence)BundleCollection.access$readPlistInDirectory(this.this$0, this.$path, this.$plistReader, readSublimeBundle.1::readGrammars$lambda$0), readSublimeBundle.1::readGrammars$lambda$1);
            }

            private static final boolean readGrammars$lambda$0(ResourcePath it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.endsWith("tmLanguage") || it.endsWith("plist") || it.endsWith("tmLanguage.json");
            }

            /*
             * WARNING - void declaration
             */
            private static final TextMateGrammar readGrammars$lambda$1(Plist plist) {
                void $this$flatMapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
                Iterable $this$flatMap$iv = CollectionsKt.filterNotNull((Iterable)plist.getPlistValue("fileTypes", CollectionsKt.emptyList()).getStringArray());
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    String s = (String)element$iv$iv;
                    boolean bl = false;
                    Object[] objectArray = new TextMateFileNameMatcher[]{new TextMateFileNameMatcher.Name(s), new TextMateFileNameMatcher.Extension(s)};
                    Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List fileNameMatchers = (List)destination$iv$iv;
                PListValue pListValue = plist.getPlistValue("firstLineMatch");
                String firstLinePattern = pListValue != null ? pListValue.getString() : null;
                return new TextMateGrammar(fileNameMatchers, firstLinePattern, (Lazy<Plist>)LazyKt.lazy(() -> readSublimeBundle.1.readGrammars$lambda$1$1(plist)), null, null);
            }

            private static final Plist readGrammars$lambda$1$1(Plist $plist) {
                return $plist;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Plist readPlist(InputStream inputStream, PlistReaderCore plistReader, String debugName) {
        Object object;
        block9: {
            Throwable throwable;
            Object object2;
            boolean $i$f$catching = false;
            try {
                Plist plist;
                boolean bl = false;
                AutoCloseable autoCloseable = inputStream;
                Throwable throwable2 = null;
                try {
                    InputStream it = (InputStream)autoCloseable;
                    boolean bl2 = false;
                    byte[] byArray = it.readAllBytes();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                    plist = plistReader.read(byArray);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
                object2 = Result.constructor-impl((Object)plist);
            }
            catch (CancellationException c$iv) {
                throw c$iv;
            }
            catch (Throwable t$iv) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
            }
            object = object2;
            Throwable throwable4 = Result.exceptionOrNull-impl((Object)object);
            if (throwable4 == null) break block9;
            Throwable e = throwable = throwable4;
            boolean bl = false;
            Logger.INSTANCE.warn(e, "Can't load plist from file: " + debugName);
        }
        return (Plist)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static final Plist readPlistInDirectory$lambda$1$0(BundleCollection this$0, PlistReaderCore $plistReader, ResourcePath child2) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child");
        InputStream inputStream = child2.stream();
        int n = 8192;
        return this$0.readPlist(inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n), $plistReader, child2.absolute());
    }

    public /* synthetic */ BundleCollection(List paths, List langs, DefaultConstructorMarker $constructor_marker) {
        this(paths, langs);
    }

    public static final /* synthetic */ Sequence access$readPlistInDirectory(BundleCollection $this, ResourcePath directory, PlistReaderCore plistReader, Function1 filter2) {
        return $this.readPlistInDirectory(directory, plistReader, (Function1<? super ResourcePath, Boolean>)filter2);
    }

    @SourceDebugExtension(value={"SMAP\nCustomBundleReaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomBundleReaders.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/BundleCollection$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,331:1\n1563#2:332\n1634#2,3:333\n*S KotlinDebug\n*F\n+ 1 CustomBundleReaders.kt\ncom/jetbrains/toolbox/markdown/renderer/code/higlighting/textmate/BundleCollection$Companion\n*L\n76#1:332\n76#1:333,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BundleCollection read() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = prefix.div("list.dat").lines();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(prefix.div((String)it));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            List<String> list2 = prefix.div("lang.dat").lines();
            List list3 = (List)destination$iv$iv;
            return new BundleCollection(list3, list2, defaultConstructorMarker);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BundleType.values().length];
            try {
                nArray[BundleType.TEXTMATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BundleType.SUBLIME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BundleType.VSCODE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BundleType.UNDEFINED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

