/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.markdown.renderer.animation.caret;

import com.jetbrains.toolbox.markdown.renderer.animation.caret.ExtensionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class MarkdownCaret {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int offset;
    @NotNull
    private static final MarkdownCaret INITIAL = ExtensionsKt.getCaret(0);

    public MarkdownCaret(int offset) {
        this.offset = offset;
    }

    public final int getOffset() {
        return this.offset;
    }

    @NotNull
    public final MarkdownCaret forwardTo(@NotNull MarkdownCaret index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        if (index.compareTo(this.offset) <= 0) {
            Logger.INSTANCE.error(() -> MarkdownCaret.forwardTo$lambda$0(index, this));
        }
        return index;
    }

    public final int compareTo(int index) {
        return Intrinsics.compare((int)this.offset, (int)index);
    }

    @NotNull
    public String toString() {
        return "MarkdownCaret(offset=" + this.offset + ")";
    }

    public int hashCode() {
        return Integer.hashCode(this.offset);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MarkdownCaret)) {
            return false;
        }
        MarkdownCaret markdownCaret = (MarkdownCaret)other;
        return this.offset == markdownCaret.offset;
    }

    private static final String forwardTo$lambda$0(MarkdownCaret $index, MarkdownCaret this$0) {
        return "Cannot forward " + $index + " to " + this$0.offset + ", since expected " + $index + " > " + this$0.offset;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MarkdownCaret getINITIAL() {
            return INITIAL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

