/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.markdown.renderer.animation;

import com.jetbrains.toolbox.markdown.skeleton.MarkdownSkeletonBlock;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MarkdownAnimatedElementDescriptor {
    @NotNull
    private final IntRange range;
    @NotNull
    private final IElementType type;
    private final boolean finished;
    public static final int $stable = 8;

    public MarkdownAnimatedElementDescriptor(@NotNull IntRange range, @NotNull IElementType type2, boolean finished) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.range = range;
        this.type = type2;
        this.finished = finished;
    }

    @NotNull
    public final IntRange getRange() {
        return this.range;
    }

    @NotNull
    public final IElementType getType() {
        return this.type;
    }

    public final boolean getFinished() {
        return this.finished;
    }

    public MarkdownAnimatedElementDescriptor(@NotNull MarkdownSkeletonBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this(block.getRange(), block.getType(), block.getFinished());
    }

    @NotNull
    public String toString() {
        return "MarkdownAnimatedElementDescriptor(range=" + this.range + ", type=" + this.type + ", finished=" + this.finished + ")";
    }

    public int hashCode() {
        int result2 = this.range.hashCode();
        result2 = result2 * 31 + this.type.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.finished);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MarkdownAnimatedElementDescriptor)) {
            return false;
        }
        MarkdownAnimatedElementDescriptor markdownAnimatedElementDescriptor = (MarkdownAnimatedElementDescriptor)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)markdownAnimatedElementDescriptor.range)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)markdownAnimatedElementDescriptor.type)) {
            return false;
        }
        return this.finished == markdownAnimatedElementDescriptor.finished;
    }
}

