/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.markdown.renderer;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import com.jetbrains.toolbox.common.ai.TextGenerationSpeed;
import com.jetbrains.toolbox.markdown.configuration.MarkdownConfiguration;
import com.jetbrains.toolbox.markdown.renderer.animation.caret.MarkdownCaret;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MarkdownRenderingContext {
    @NotNull
    private final MarkdownConfiguration configuration;
    @NotNull
    private final TextGenerationSpeed speed;
    @NotNull
    private final MutableState<MarkdownCaret> caret;
    private final boolean compact;
    public static final int $stable = 8;

    public MarkdownRenderingContext(@NotNull MarkdownConfiguration configuration, @NotNull TextGenerationSpeed speed, @NotNull MutableState<MarkdownCaret> caret, boolean compact) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)speed, (String)"speed");
        Intrinsics.checkNotNullParameter(caret, (String)"caret");
        this.configuration = configuration;
        this.speed = speed;
        this.caret = caret;
        this.compact = compact;
    }

    public /* synthetic */ MarkdownRenderingContext(MarkdownConfiguration markdownConfiguration, TextGenerationSpeed textGenerationSpeed, MutableState mutableState, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            mutableState = SnapshotStateKt.mutableStateOf$default(MarkdownCaret.Companion.getINITIAL(), null, 2, null);
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(markdownConfiguration, textGenerationSpeed, mutableState, bl);
    }

    @NotNull
    public final MarkdownConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final TextGenerationSpeed getSpeed() {
        return this.speed;
    }

    @NotNull
    public final MutableState<MarkdownCaret> getCaret() {
        return this.caret;
    }

    public final boolean getCompact() {
        return this.compact;
    }

    @NotNull
    public final MarkdownRenderingContext withCompact() {
        return MarkdownRenderingContext.copy$default(this, null, null, null, true, 7, null);
    }

    @NotNull
    public final MarkdownRenderingContext copy(@NotNull MarkdownConfiguration configuration, @NotNull TextGenerationSpeed speed, @NotNull MutableState<MarkdownCaret> caret, boolean compact) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)speed, (String)"speed");
        Intrinsics.checkNotNullParameter(caret, (String)"caret");
        return new MarkdownRenderingContext(configuration, speed, caret, compact);
    }

    public static /* synthetic */ MarkdownRenderingContext copy$default(MarkdownRenderingContext markdownRenderingContext, MarkdownConfiguration markdownConfiguration, TextGenerationSpeed textGenerationSpeed, MutableState mutableState, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            markdownConfiguration = markdownRenderingContext.configuration;
        }
        if ((n & 2) != 0) {
            textGenerationSpeed = markdownRenderingContext.speed;
        }
        if ((n & 4) != 0) {
            mutableState = markdownRenderingContext.caret;
        }
        if ((n & 8) != 0) {
            bl = markdownRenderingContext.compact;
        }
        return markdownRenderingContext.copy(markdownConfiguration, textGenerationSpeed, mutableState, bl);
    }

    @NotNull
    public String toString() {
        return "MarkdownRenderingContext(configuration=" + this.configuration + ", speed=" + this.speed + ", caret=" + this.caret + ", compact=" + this.compact + ")";
    }

    public int hashCode() {
        int result2 = this.configuration.hashCode();
        result2 = result2 * 31 + this.speed.hashCode();
        result2 = result2 * 31 + this.caret.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.compact);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MarkdownRenderingContext)) {
            return false;
        }
        MarkdownRenderingContext markdownRenderingContext = (MarkdownRenderingContext)other;
        if (!Intrinsics.areEqual((Object)this.configuration, (Object)markdownRenderingContext.configuration)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.speed, (Object)markdownRenderingContext.speed)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.caret, markdownRenderingContext.caret)) {
            return false;
        }
        return this.compact == markdownRenderingContext.compact;
    }
}

