/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.managers;

import com.jetbrains.toolbox.managers.VerificationStateWorkerKt;
import com.jetbrains.toolbox.tools.ChannelStateWorker;
import com.jetbrains.toolbox.tools.model.ChannelEvent;
import com.jetbrains.toolbox.tools.model.ChannelState;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class VerificationStateWorker
implements ChannelStateWorker<ChannelState.Verifying> {
    @NotNull
    private final FileSystem fileSystem;

    public VerificationStateWorker(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
    }

    @Override
    @NotNull
    public KClass<ChannelState.Verifying> getState() {
        return Reflection.getOrCreateKotlinClass(ChannelState.Verifying.class);
    }

    @Override
    @Nullable
    public Object handle(@NotNull ChannelState.Verifying state2, @NotNull Continuation<? super ChannelEvent> $completion) {
        FileMetadata metadata2 = this.fileSystem.metadataOrNull(state2.getFile());
        if (metadata2 == null || !metadata2.isRegularFile()) {
            Logger.INSTANCE.error("File " + state2 + ".file doesn't exist or is not a regular file");
            return ChannelEvent.VerificationFailed.INSTANCE;
        }
        Long l = metadata2.getSize();
        long l2 = state2.getBuild().getBuild().getDownloadSize();
        if (l == null || l != l2) {
            Logger.INSTANCE.error("Verification failed due to file size mismatch: expected " + state2.getBuild().getBuild().getDownloadSize() + " actual " + metadata2.getSize());
            this.removeFile(state2.getFile());
            return ChannelEvent.VerificationFailed.INSTANCE;
        }
        ChannelEvent result2 = VerificationStateWorkerKt.verifyChecksums(this.fileSystem, state2.getFile(), state2.getBuild().getBuild().getChecksums());
        if (!Intrinsics.areEqual((Object)result2, (Object)ChannelEvent.VerificationSuccessful.INSTANCE)) {
            this.removeFile(state2.getFile());
        }
        return result2;
    }

    private final void removeFile(Path file) {
        try {
            this.fileSystem.delete(file);
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Failed to delete " + file);
        }
    }
}

