/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.managers;

import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.tools.ChannelStateWorker;
import com.jetbrains.toolbox.tools.model.ChannelEvent;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.FailedUpdate;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.time.Duration;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class UpdateFailedStateWorker
implements ChannelStateWorker<ChannelState.UpdateFailed> {
    @NotNull
    private final StateFlow<SelfSettings> settings;
    @NotNull
    private final Clock clock;

    public UpdateFailedStateWorker(@NotNull StateFlow<SelfSettings> settings2, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(settings2, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.settings = settings2;
        this.clock = clock;
    }

    @Override
    @NotNull
    public KClass<ChannelState.UpdateFailed> getState() {
        return Reflection.getOrCreateKotlinClass(ChannelState.UpdateFailed.class);
    }

    @Override
    @Nullable
    public Object handle(@NotNull ChannelState.UpdateFailed state2, @NotNull Continuation<? super ChannelEvent> $completion) {
        ChannelEvent channelEvent;
        FailedUpdate.Reason reason = state2.getReason();
        if (reason instanceof FailedUpdate.Reason.Failed) {
            long postponeDuration = ((SelfSettings)this.settings.getValue()).getInternal().getFailedUpdatePostponeDuration-UwyO8pc();
            Logger.INSTANCE.info("Updating " + InstalledToolKt.displayNameWithVersion(state2.getChannel(), state2.getTool()) + " to " + state2.getBuild().getDisplayName() + " has failed, postponing by " + Duration.toString-impl((long)postponeDuration));
            channelEvent = new ChannelEvent.UpdatePostponed(new FailedUpdate(state2.getBuild().getBuild().getId-Y_E1uuk(), this.clock.now().plus-LRDsOJo(postponeDuration), reason, null));
        } else if (reason instanceof FailedUpdate.Reason.Cancelled) {
            Logger.INSTANCE.info("Updating " + InstalledToolKt.displayNameWithVersion(state2.getChannel(), state2.getTool()) + " to " + state2.getBuild().getDisplayName() + " has been cancelled, postponing indefinitely");
            channelEvent = new ChannelEvent.UpdatePostponed(new FailedUpdate(state2.getBuild().getBuild().getId-Y_E1uuk(), null, reason, null));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return channelEvent;
    }
}

