/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.managers;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.feed.LicenseAgreement;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.jbclient.ClientInstallPathProvider;
import com.jetbrains.toolbox.managers.PrepareInstallationStateWorker;
import com.jetbrains.toolbox.settings.SettingsManager;
import com.jetbrains.toolbox.tools.ChannelStateWorker;
import com.jetbrains.toolbox.tools.LicenseAgreementManager;
import com.jetbrains.toolbox.tools.model.ChannelEvent;
import com.jetbrains.toolbox.tools.model.InstallSource;
import com.jetbrains.toolbox.tools.model.State;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.UpdateFilter;
import com.jetbrains.toolbox.tools.provider.LocalToolPathManager;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.datetime.Clock;
import okio.FileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class PrepareInstallationWithoutFeedStateWorker
implements ChannelStateWorker<State.PrepareInstallationWithoutFeed> {
    @Nullable
    private final ClientInstallPathProvider clientInstallPathProvider;
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final LocalToolPathManager localToolPathManager;
    @NotNull
    private final LicenseAgreementManager licenseAgreementManager;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final OS.Type os;
    @NotNull
    private final Clock clock;

    public PrepareInstallationWithoutFeedStateWorker(@Nullable ClientInstallPathProvider clientInstallPathProvider, @NotNull SettingsManager settingsManager, @NotNull LocalToolPathManager localToolPathManager, @NotNull LicenseAgreementManager licenseAgreementManager, @NotNull FileSystem fileSystem, @NotNull OS.Type os, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)localToolPathManager, (String)"localToolPathManager");
        Intrinsics.checkNotNullParameter((Object)licenseAgreementManager, (String)"licenseAgreementManager");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)((Object)os), (String)"os");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clientInstallPathProvider = clientInstallPathProvider;
        this.settingsManager = settingsManager;
        this.localToolPathManager = localToolPathManager;
        this.licenseAgreementManager = licenseAgreementManager;
        this.fileSystem = fileSystem;
        this.os = os;
        this.clock = clock;
    }

    @Override
    @NotNull
    public KClass<State.PrepareInstallationWithoutFeed> getState() {
        return Reflection.getOrCreateKotlinClass(State.PrepareInstallationWithoutFeed.class);
    }

    @Override
    @Nullable
    public Object handle(@NotNull State.PrepareInstallationWithoutFeed state2, @NotNull Continuation<? super ChannelEvent> $completion) {
        ToolBuild toolBuild2 = state2.getToolBuild();
        LicenseAgreement licenseAgreement = toolBuild2.getTool().getLicenseAgreement();
        if (licenseAgreement != null && !this.licenseAgreementManager.isAccepted(licenseAgreement)) {
            Logger.INSTANCE.warn("License agreement is not accepted " + ApplicationType.toString-impl(state2.getTool().getToolId-UtVBrGo()) + " (" + BuildNumber.toString-impl(toolBuild2.getBuild().getId-Y_E1uuk()) + ").");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toolName", (Object)toolBuild2.getDisplayName())};
            return new ChannelEvent.Failed(LocalizableStringExKt.trl("Failed to install {{toolName}}: License agreement is not accepted.", pairArray));
        }
        UpdateFilter updateFilter = PrepareInstallationStateWorker.Companion.calculateUpdateFilter$core(toolBuild2, toolBuild2.getVersion());
        return PrepareInstallationStateWorker.Companion.handleToolBuild-VNzfoQw$core(toolBuild2, updateFilter, null, InstallSource.InstalledByUser, state2.isUnmanaged(), state2.getChannelId-5CZByfs(), this.settingsManager, this.clock, this.localToolPathManager, this.fileSystem, this.clientInstallPathProvider, this.os);
    }
}

