/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.managers;

import com.jetbrains.toolbox.managers.VerificationStateWorkerKt;
import com.jetbrains.toolbox.tools.ChannelStateWorker;
import com.jetbrains.toolbox.tools.model.ChannelEvent;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.ToolPatch;
import java.util.Iterator;
import java.util.List;
import kotlin.Pair;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class PatchVerificationStateWorker
implements ChannelStateWorker<ChannelState.PatchVerifying> {
    @NotNull
    private final FileSystem fileSystem;

    public PatchVerificationStateWorker(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
    }

    @Override
    @NotNull
    public KClass<ChannelState.PatchVerifying> getState() {
        return Reflection.getOrCreateKotlinClass(ChannelState.PatchVerifying.class);
    }

    @Override
    @Nullable
    public Object handle(@NotNull ChannelState.PatchVerifying state2, @NotNull Continuation<? super ChannelEvent> $completion) {
        for (Pair<ToolPatch, Path> pair : state2.getPatches()) {
            ToolPatch patch = (ToolPatch)pair.component1();
            Path file = (Path)pair.component2();
            FileMetadata metadata2 = this.fileSystem.metadataOrNull(file);
            if (metadata2 == null || !metadata2.isRegularFile()) {
                Logger.INSTANCE.error("File " + state2 + ".file doesn't exist or is not a regular file");
                return ChannelEvent.VerificationFailed.INSTANCE;
            }
            Long l = metadata2.getSize();
            long l2 = patch.getDownloadSize();
            if (l == null || l != l2) {
                Logger.INSTANCE.error("Verification failed due to file size mismatch: expected " + patch.getDownloadSize() + " actual " + metadata2.getSize());
                this.removeFiles(state2.getPatches());
                return ChannelEvent.VerificationFailed.INSTANCE;
            }
            ChannelEvent result2 = VerificationStateWorkerKt.verifyChecksums(this.fileSystem, file, patch.getChecksums());
            if (Intrinsics.areEqual((Object)result2, (Object)ChannelEvent.VerificationSuccessful.INSTANCE)) continue;
            this.removeFiles(state2.getPatches());
            return result2;
        }
        return ChannelEvent.VerificationSuccessful.INSTANCE;
    }

    private final void removeFiles(List<Pair<ToolPatch, Path>> patches) {
        Iterator<Pair<ToolPatch, Path>> iterator2 = patches.iterator();
        while (iterator2.hasNext()) {
            Path file = (Path)iterator2.next().component2();
            try {
                this.fileSystem.delete(file);
            }
            catch (Exception e) {
                Logger.INSTANCE.error((Throwable)e, "Failed to delete " + file);
            }
        }
    }
}

