/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.managers;

import com.jetbrains.toolbox.StorageUtils;
import com.jetbrains.toolbox.common.FilenameFromUrlKt;
import com.jetbrains.toolbox.feed.RemoteChecksum;
import com.jetbrains.toolbox.fus.IDESMetrics;
import com.jetbrains.toolbox.managers.DownloadStateWorker;
import com.jetbrains.toolbox.network.DownloadManager;
import com.jetbrains.toolbox.network.DownloadResult;
import com.jetbrains.toolbox.network.DownloadSession;
import com.jetbrains.toolbox.network.FileDownloader;
import com.jetbrains.toolbox.tools.ChannelStateWorker;
import com.jetbrains.toolbox.tools.model.AvailableBuild;
import com.jetbrains.toolbox.tools.model.ChannelEvent;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.FailedUpdate;
import java.util.concurrent.CancellationException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class DownloadStateWorker
implements ChannelStateWorker<ChannelState.Downloading> {
    @NotNull
    private final DownloadManager downloadManager;
    @NotNull
    private final StorageUtils storageUtils;
    @NotNull
    private final IDESMetrics idesMetrics;

    public DownloadStateWorker(@NotNull DownloadManager downloadManager, @NotNull StorageUtils storageUtils, @NotNull IDESMetrics idesMetrics) {
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)storageUtils, (String)"storageUtils");
        Intrinsics.checkNotNullParameter((Object)idesMetrics, (String)"idesMetrics");
        this.downloadManager = downloadManager;
        this.storageUtils = storageUtils;
        this.idesMetrics = idesMetrics;
    }

    @Override
    @NotNull
    public KClass<ChannelState.Downloading> getState() {
        return Reflection.getOrCreateKotlinClass(ChannelState.Downloading.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object handle(@NotNull ChannelState.Downloading state, @NotNull Continuation<? super ChannelEvent> $completion) {
        if (!($completion instanceof handle.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ DownloadStateWorker this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handle((ChannelState.Downloading)null, (Continuation<? super ChannelEvent>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                build = state.getBuild().getBuild();
                downloadedFile = this.downloadManager.getDownloadDirectory().resolve(((v0 = (RemoteChecksum)CollectionsKt.firstOrNull(build.getChecksums())) != null && (v0 = v0.getValue()) != null ? StringsKt.substring((String)v0, (IntRange)new IntRange(0, 8)) : null) + "-" + FilenameFromUrlKt.filenameFromUrl(build.getDownloadUrl()));
                availableSpace = this.storageUtils.getFreeSpace(this.downloadManager.getDownloadDirectory(), true);
                if (availableSpace <= build.getDownloadSize()) {
                    Logger.INSTANCE.error("Downloading from " + build.getDownloadUrl() + " failed: not enough space, required " + build.getDownloadSize() + ", available " + availableSpace);
                    return new ChannelEvent.InstallFailed(new FailedUpdate.Reason.Failed.NotEnoughDiskSpace(build.getDownloadSize(), availableSpace));
                }
                $continuation.L$0 = state;
                $continuation.L$1 = build;
                $continuation.L$2 = downloadedFile;
                $continuation.J$0 = availableSpace;
                $continuation.label = 1;
                v1 = this.downloadManager.createSession((Continuation<? super DownloadSession>)$continuation);
                ** if (v1 != var11_5) goto lbl28
lbl27:
                // 1 sources

                return var11_5;
lbl28:
                // 1 sources

                ** GOTO lbl38
            }
            case 1: {
                availableSpace = $continuation.J$0;
                downloadedFile = (Path)$continuation.L$2;
                build = (AvailableBuild)$continuation.L$1;
                state = (ChannelState.Downloading)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl38:
                // 2 sources

                $continuation.L$0 = state;
                $continuation.L$1 = build;
                $continuation.L$2 = downloadedFile;
                $continuation.J$0 = availableSpace;
                $continuation.label = 2;
                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)v1), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DownloadResult>, Object>(this, build, downloadedFile, state, null){
                    int label;
                    final /* synthetic */ DownloadStateWorker this$0;
                    final /* synthetic */ AvailableBuild $build;
                    final /* synthetic */ Path $downloadedFile;
                    final /* synthetic */ ChannelState.Downloading $state;
                    {
                        this.this$0 = $receiver;
                        this.$build = $build;
                        this.$downloadedFile = $downloadedFile;
                        this.$state = $state;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = DownloadStateWorker.access$getIdesMetrics$p(this.this$0).measureDuration("tool_download", (Function1)new Function1<Continuation<? super DownloadResult>, Object>(this.this$0, this.$build, this.$downloadedFile, this.$state, null){
                                    int label;
                                    final /* synthetic */ DownloadStateWorker this$0;
                                    final /* synthetic */ AvailableBuild $build;
                                    final /* synthetic */ Path $downloadedFile;
                                    final /* synthetic */ ChannelState.Downloading $state;
                                    {
                                        this.this$0 = $receiver;
                                        this.$build = $build;
                                        this.$downloadedFile = $downloadedFile;
                                        this.$state = $state;
                                        super(1, $completion);
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.label = 1;
                                                Object object2 = FileDownloader.getFile$default(DownloadStateWorker.access$getDownloadManager$p(this.this$0).getFileDownloader(), this.$build.getDownloadUrl(), this.$downloadedFile, this.$build.getDownloadSize(), this.$state.getProgress(), null, false, false, (Continuation)this, 112, null);
                                                if (object2 != object) return object2;
                                                return object;
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object2 = $result;
                                                return object2;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(Continuation<? super DownloadResult> p1) {
                                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super DownloadResult> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v2 != var11_5) goto lbl46
lbl45:
                // 1 sources

                return var11_5;
lbl46:
                // 1 sources

                ** GOTO lbl56
            }
            case 2: {
                availableSpace = $continuation.J$0;
                downloadedFile = (Path)$continuation.L$2;
                build = (AvailableBuild)$continuation.L$1;
                state = (ChannelState.Downloading)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl56:
                    // 2 sources

                    if ((var8_11 = (result = (DownloadResult)v2)) instanceof DownloadResult.Downloaded) {
                        v3 = new ChannelEvent.Downloaded(downloadedFile);
                    } else if (var8_11 instanceof DownloadResult.Failed) {
                        Logger.INSTANCE.error("Downloading from " + build.getDownloadUrl() + " failed: " + ((DownloadResult.Failed)result).getError());
                        v3 = new ChannelEvent.InstallFailed(new FailedUpdate.Reason.Failed.ServerError(build.getDownloadUrl(), ((DownloadResult.Failed)result).getError()));
                    } else {
                        v3 = ChannelEvent.Request.Cancel.INSTANCE;
                    }
                    var7_10 = v3;
                }
                catch (CancellationException <unused var>) {
                    var7_10 = ChannelEvent.Request.Cancel.INSTANCE;
                }
                catch (Exception e) {
                    Logger.INSTANCE.warn((Throwable)e, "Download failed");
                    var7_10 = new ChannelEvent.InstallFailed(new FailedUpdate.Reason.Failed.Other(Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName() + ": " + e.getMessage()));
                    {
                        catch (Throwable var8_14) {
                            throw var8_14;
                        }
                    }
                }
                state.getProgress().close();
                ** GOTO lbl81
            }
            {
                finally {
                    state.getProgress().close();
                }
            }
lbl81:
            // 3 sources

            return var7_10;
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ IDESMetrics access$getIdesMetrics$p(DownloadStateWorker $this) {
        return $this.idesMetrics;
    }

    public static final /* synthetic */ DownloadManager access$getDownloadManager$p(DownloadStateWorker $this) {
        return $this.downloadManager;
    }
}

