/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.manager;

import com.jetbrains.toolbox.InAppNotificationDuration;
import com.jetbrains.toolbox.SnackbarInfo;
import com.jetbrains.toolbox.SnackbarResult;
import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.network.CertificateTrustRequest;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public interface SnackbarManager {
    @Nullable
    public Object showSnackbar(@NotNull SnackbarInfo var1, @NotNull Continuation<? super SnackbarResult> var2);

    @Nullable
    public Object closeSnackbar(@NotNull SnackbarInfo var1, @NotNull Continuation<? super Unit> var2);

    @NotNull
    public I18n getI18n();

    @NotNull
    default public SnackbarInfo inAppNotification(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        return new SnackbarInfo("", message2, null, null, false, null, InAppNotificationDuration.Short, message2 + " (in-app)", 60, null);
    }

    @NotNull
    default public SnackbarInfo editProxySettings(@NotNull String proxyUrl) {
        Intrinsics.checkNotNullParameter((Object)proxyUrl, (String)"proxyUrl");
        String string = this.getI18n().tr("Edit Proxy Settings");
        Object object = new Pair[]{TuplesKt.to((Object)"proxyAddress", (Object)proxyUrl), TuplesKt.to((Object)"appName", (Object)"Toolbox App")};
        String string2 = this.getI18n().tr("The proxy server {{proxyAddress}} requires authentication. Enter your credentials to allow {{appName}} to connect through it.", (Pair<String, String>)object);
        object = this.getI18n().tr("Disable proxy");
        String string3 = this.getI18n().tr("Change settings\u2026");
        FusEnums.NotificationType notificationType = FusEnums.NotificationType.EDIT_PROXY_SETTINGS_PROMPT;
        String string4 = "edit proxy " + proxyUrl + " settings";
        return new SnackbarInfo(string, string2, (String)object, string3, true, notificationType, null, string4, 64, null);
    }

    @NotNull
    default public SnackbarInfo toolLogsNotFound(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"appName", (Object)toolName)};
        return new SnackbarInfo(this.getI18n().tr("Log Files Not Found"), this.getI18n().tr("Failed to locate the log files for {{appName}}", pairArray), this.getI18n().tr("OK"), null, false, null, InAppNotificationDuration.Short, "log files for " + toolName + " not found", 56, null);
    }

    @NotNull
    default public SnackbarInfo uninstallFeedback(@NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Object object = new Pair[]{TuplesKt.to((Object)"appName", (Object)toolName)};
        String string = this.getI18n().tr("{{appName}} Is Uninstalled", (Pair<String, String>)object);
        Object object2 = new Pair[]{TuplesKt.to((Object)"appName", (Object)toolName)};
        object = this.getI18n().tr("Tell us about your experience to help improve {{appName}}", (Pair<String, String>)object2);
        object2 = this.getI18n().tr("Provide feedback\u2026");
        String string2 = this.getI18n().tr("No, thanks");
        InAppNotificationDuration inAppNotificationDuration = InAppNotificationDuration.Long;
        FusEnums.NotificationType notificationType = FusEnums.NotificationType.UNINSTALL_FEEDBACK_PROMPT;
        String string3 = toolName + " is uninstalling";
        return new SnackbarInfo(string, (String)object, (String)object2, string2, false, notificationType, inAppNotificationDuration, string3, 16, null);
    }

    @NotNull
    default public SnackbarInfo untrustedCertificate(@NotNull CertificateTrustRequest certInfo) {
        Intrinsics.checkNotNullParameter((Object)certInfo, (String)"certInfo");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ideServicesName", (Object)"JetBrains IDE Services"), TuplesKt.to((Object)"subjectName", (Object)certInfo.getSubject()), TuplesKt.to((Object)"issuerName", (Object)certInfo.getIssuer()), TuplesKt.to((Object)"date", (Object)certInfo.getValidTo()), TuplesKt.to((Object)"sha256Fingerprint", (Object)certInfo.getSha256fingerprint())};
        return new SnackbarInfo(this.getI18n().tr("Untrusted Certificate"), this.getI18n().tr("You are joining an organization in {{ideServicesName}}. This organization uses self-signed HTTPS certificates. Importing an unrecognized certificate can lead to security and usability issues. We recommend accepting and importing the certificate only if you fully understand the potential risks involved.\nIssued to: {{subjectName}}\nIssued by: {{issuerName}}\nValid until: {{date}}\nSHA256 Fingerprint: {{sha256Fingerprint}}", pairArray), this.getI18n().tr("Accept"), this.getI18n().tr("Reject"), false, FusEnums.NotificationType.UNTRUSTED_CERTIFICATE_PROMPT, null, "untrusted certificate (fingerprint " + certInfo.getSha256fingerprint() + ")", 80, null);
    }

    @NotNull
    default public SnackbarInfo installationError(@NotNull String error2) {
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        return new SnackbarInfo(this.getI18n().tr("Installation Error"), error2, null, null, false, null, InAppNotificationDuration.Long, "'" + error2 + "' installation error", 60, null);
    }

    @NotNull
    default public SnackbarInfo updateError(@NotNull String error2) {
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        return new SnackbarInfo(this.getI18n().tr("Update Error"), error2, this.getI18n().tr("Try again"), this.getI18n().tr("Cancel"), false, FusEnums.NotificationType.PROGRESS_ERROR_PROMPT, InAppNotificationDuration.Long, "'" + error2 + "' update error", 16, null);
    }

    @NotNull
    default public SnackbarInfo failedToFetchPluginUpdates(@NotNull String error2) {
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        return new SnackbarInfo(this.getI18n().tr("Failed to fetch plugin updates"), error2, null, null, false, null, InAppNotificationDuration.Long, "'" + error2 + "' plugins update error", 60, null);
    }

    @NotNull
    default public SnackbarInfo statisticsWasSent() {
        return new SnackbarInfo(this.getI18n().tr("Statistics"), this.getI18n().tr("Statistics successfully submitted"), this.getI18n().tr("OK"), null, false, null, null, "statistics was sent", 120, null);
    }

    @NotNull
    default public SnackbarInfo enterpriseOrgJoinError(@NotNull String joinedOrganization) {
        Intrinsics.checkNotNullParameter((Object)joinedOrganization, (String)"joinedOrganization");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ideServicesName", (Object)"JetBrains IDE Services"), TuplesKt.to((Object)"org", (Object)joinedOrganization)};
        return new SnackbarInfo("", this.getI18n().tr("{{ideServicesName}} is already configured for {{org}}. Leave {{org}} to connect to the new organization.", pairArray), null, null, false, null, InAppNotificationDuration.Long, "enterprise org join error", 60, null);
    }

    @NotNull
    default public SnackbarInfo accountsRemoved(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"email", (Object)email)};
        return new SnackbarInfo(this.getI18n().tr("Multiple Accounts Are No Longer Supported"), this.getI18n().tr("Your current account is {{email}}. You have been logged out of all other accounts.", pairArray), this.getI18n().tr("OK"), this.getI18n().tr("Learn more\u2026"), false, null, null, "removed all JBA except " + email, 112, null);
    }

    @NotNull
    default public SnackbarInfo test(@NotNull String body, boolean textOnly) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return textOnly ? new SnackbarInfo("", body, null, null, false, null, null, "test (text-only)", 124, null) : new SnackbarInfo("Snackbar Title", body, "OK", "Cancel", false, null, null, "test", 112, null);
    }

    @NotNull
    default public SnackbarInfo exceptionOccurred(@Nullable String firstExceptionName, int count) {
        String string;
        if (count == 1 && firstExceptionName != null) {
            var4_3 = new Pair[]{TuplesKt.to((Object)"exceptionName", (Object)firstExceptionName)};
            string = this.getI18n().tr("{{exceptionName}} occurred", var4_3);
        } else {
            var4_3 = new Pair[]{TuplesKt.to((Object)"count", (Object)String.valueOf(count))};
            string = this.getI18n().trn("Exception occurred", "{{count}} exceptions occurred", count, var4_3);
        }
        String bodyText = string;
        return new SnackbarInfo(this.getI18n().tr("Internal Error"), bodyText, this.getI18n().tr("Report to JetBrains"), this.getI18n().tr("Clear all"), false, null, null, "exception occurred", 112, null);
    }

    @NotNull
    default public SnackbarInfo exceptionSubmitted(int count) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"count", (Object)String.valueOf(count))};
        return new SnackbarInfo(this.getI18n().tr("Thank you!"), this.getI18n().trn("Error report submitted", "{{count}} reports submitted", count, pairArray), this.getI18n().tr("Open"), this.getI18n().tr("Dismiss"), false, null, null, "exception submitted", 112, null);
    }

    @NotNull
    default public SnackbarInfo cwmClientInstallationError-nDJfUvo(@NotNull String stage, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        Intrinsics.checkNotNullParameter((Object)string, (String)"$v$c$com-jetbrains-toolbox-BuildNumber$-buildNumber$0");
        String string2 = this.getI18n().tr("Failed to join Code With Me session");
        String string3 = "jbc installation " + string;
        FusEnums.NotificationType notificationType = FusEnums.NotificationType.PROGRESS_ERROR_PROMPT;
        InAppNotificationDuration inAppNotificationDuration = InAppNotificationDuration.Long;
        return new SnackbarInfo(string2, stage, null, null, false, notificationType, inAppNotificationDuration, string3, 28, null);
    }

    @NotNull
    default public SnackbarInfo environmentNotAvailable(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String string = this.getI18n().tr("Unavailable environment");
        Object object = new Pair[]{TuplesKt.to((Object)"id", (Object)id)};
        String string2 = this.getI18n().tr("Couldn't find the selected environment with id: {{id}}. Falling back to main screen", (Pair<String, String>)object);
        object = this.getI18n().tr("Dismiss");
        InAppNotificationDuration inAppNotificationDuration = InAppNotificationDuration.Short;
        return new SnackbarInfo(string, string2, null, (String)object, false, null, inAppNotificationDuration, "environment unavailable", 52, null);
    }

    @NotNull
    default public SnackbarInfo environmentError(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        String string = this.getI18n().tr("");
        Object object = new Pair[]{TuplesKt.to((Object)"error", (Object)message2)};
        String string2 = this.getI18n().tr("Error: {{error}}", (Pair<String, String>)object);
        object = "environment error " + message2;
        String string3 = this.getI18n().tr("Show more information");
        String string4 = this.getI18n().tr("Dismiss");
        return new SnackbarInfo(string, string2, string3, string4, false, null, null, (String)object, 112, null);
    }

    @NotNull
    default public SnackbarInfo toolboxAgentBuildUnavailable(@NotNull String build2) {
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        String string = this.getI18n().tr("Toolbox Agent distribution unavailable");
        Object object = new Pair[]{TuplesKt.to((Object)"build", (Object)build2)};
        String string2 = this.getI18n().tr("Failed to get Toolbox Agent {{build}} distribution. Check logs for more information", (Pair<String, String>)object);
        object = "toolbox agent " + build2;
        String string3 = this.getI18n().tr("Dismiss");
        return new SnackbarInfo(string, string2, null, string3, false, null, null, (String)object, 116, null);
    }

    @NotNull
    default public SnackbarInfo failedToCollectLogs() {
        String string = this.getI18n().tr("Failed to collect Toolbox App logs");
        String string2 = this.getI18n().tr("Failed to collect logs. Check logs for more information");
        String string3 = this.getI18n().tr("Dismiss");
        return new SnackbarInfo(string, string2, null, string3, false, null, null, "failed to collect logs", 116, null);
    }

    @NotNull
    default public SnackbarInfo remoteIdeFailedToStart(@NotNull String ideName, @Nullable String projectPath) {
        String string;
        Object object;
        Intrinsics.checkNotNullParameter((Object)ideName, (String)"ideName");
        String string2 = this.getI18n().tr("Failed to start remote IDE");
        if (projectPath != null) {
            object = new Pair[]{TuplesKt.to((Object)"ideName", (Object)ideName), TuplesKt.to((Object)"projectPath", (Object)projectPath)};
            string = this.getI18n().tr("Failed to start remote IDE {{ideName}} for project {{projectPath}}. Check remote IDE logs", (Pair<String, String>)object);
        } else {
            object = new Pair[]{TuplesKt.to((Object)"ideName", (Object)ideName)};
            string = this.getI18n().tr("Failed to start remote IDE {{ideName}}. Check remote IDE logs", (Pair<String, String>)object);
        }
        String string3 = string;
        object = "remote ide " + ideName + ", " + projectPath + " failed to start";
        String string4 = this.getI18n().tr("Dismiss");
        return new SnackbarInfo(string2, string3, null, string4, false, null, null, (String)object, 116, null);
    }
}

