/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.linux;

import java.awt.Window;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;
import sun.awt.AWTAccessor;

public final class WindowKt {
    @Nullable
    public static final Long linuxWindowPtr(@NotNull Window awtWindow) {
        Intrinsics.checkNotNullParameter((Object)awtWindow, (String)"awtWindow");
        AWTAccessor.ComponentAccessor componentAccessor = AWTAccessor.getComponentAccessor();
        if (componentAccessor == null) {
            Logger.INSTANCE.error("Could not get component accessor");
            return null;
        }
        Object peer = componentAccessor.getPeer(awtWindow);
        if (peer == null) {
            Logger.INSTANCE.error("Could not get component peer");
            return null;
        }
        try {
            Class<?> x11ComponentPeerClass = Class.forName("sun.awt.X11ComponentPeer");
            if (!x11ComponentPeerClass.isInstance(peer)) {
                Logger.INSTANCE.error("Component peer is not an instance of X11ComponentPeer");
                return null;
            }
            Object object = x11ComponentPeerClass.getDeclaredMethod("getWindow", new Class[0]).invoke(peer, new Object[0]);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            return (Long)object;
        }
        catch (Throwable e) {
            Logger.INSTANCE.error(e, "Failed to access X11 window ID using reflection");
            return null;
        }
    }
}

