/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.linux;

import com.jetbrains.toolbox.linux.ISettings;
import java.lang.invoke.LambdaMetafactory;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.Variant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class ThemeKt {
    @NotNull
    private static final Flow<Boolean> linuxThemeFlow = FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super Boolean>, Continuation<? super Unit>, Object>(null){
        Object L$1;
        Object L$2;
        boolean Z$0;
        int label;
        private /* synthetic */ Object L$0;

        /*
         * Unable to fully structure code
         */
        public final Object invokeSuspend(Object $result) {
            var2_2 = (ProducerScope)this.L$0;
            var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch (this.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = ThemeKt.getLinuxThemeIsDark();
                    Intrinsics.checkNotNull((Object)v0);
                    initialDark = v0;
                    this.L$0 = $this$callbackFlow;
                    this.Z$0 = initialDark;
                    this.label = 1;
                    v1 = $this$callbackFlow.send((Object)Boxing.boxBoolean((boolean)(initialDark != false)), (Continuation)this);
                    if (v1 == var6_3) {
                        return var6_3;
                    }
                    ** GOTO lbl20
                }
                case 1: {
                    initialDark = this.Z$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl20:
                    // 2 sources

                    Logger.INSTANCE.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(boolean ), ()Ljava/lang/String;)((boolean)(initialDark != false)));
                    colorSchemeHandler = (DBusSigHandler)LambdaMetafactory.metafactory(null, null, null, (Lorg/freedesktop/dbus/messages/DBusSignal;)V, invokeSuspend$lambda$1(kotlinx.coroutines.channels.ProducerScope com.jetbrains.toolbox.linux.ISettings$SettingChanged ), (Lcom/jetbrains/toolbox/linux/ISettings$SettingChanged;)V)((ProducerScope)$this$callbackFlow);
                    sessionBus = ThemeKt.access$getSessionBus();
                    sessionBus.addSigHandler(ISettings.SettingChanged.class, colorSchemeHandler);
                    Logger.INSTANCE.debug("Linux theme listener set");
                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$callbackFlow);
                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)colorSchemeHandler);
                    this.L$2 = SpillingKt.nullOutSpilledVariable((Object)sessionBus);
                    this.Z$0 = initialDark;
                    this.label = 2;
                    v2 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$2(org.freedesktop.dbus.connections.impl.DBusConnection org.freedesktop.dbus.interfaces.DBusSigHandler ), ()Lkotlin/Unit;)((DBusConnection)sessionBus, (DBusSigHandler)colorSchemeHandler), (Continuation)((Continuation)this));
                    if (v2 == var6_3) {
                        return var6_3;
                    }
                    ** GOTO lbl40
                }
                case 2: {
                    initialDark = this.Z$0;
                    sessionBus = (DBusConnection)this.L$2;
                    colorSchemeHandler = (DBusSigHandler)this.L$1;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl40:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
            var var3_3 = new /* invalid duplicate definition of identical inner class */;
            var3_3.L$0 = value2;
            return (Continuation)var3_3;
        }

        public final Object invoke(ProducerScope<? super Boolean> p1, Continuation<? super Unit> p2) {
            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
        }

        private static final String invokeSuspend$lambda$0(boolean $initialDark) {
            return "Initial Linux theme set to isDark=" + $initialDark;
        }

        private static final void invokeSuspend$lambda$1(ProducerScope $$this$callbackFlow, ISettings.SettingChanged signal) {
            Logger.INSTANCE.debug("Received signal: " + signal);
            if (Intrinsics.areEqual((Object)signal.getNamespace(), (Object)"org.freedesktop.appearance") && Intrinsics.areEqual((Object)signal.getKey(), (Object)"color-scheme")) {
                Boolean bl = ThemeKt.access$isDark(signal.getValue());
                boolean isDark = bl != null ? bl : false;
                $$this$callbackFlow.trySend-JP2dKIU((Object)isDark);
                Logger.INSTANCE.debug("Linux theme changed to isDark=" + isDark);
            }
        }

        private static final Unit invokeSuspend$lambda$2(DBusConnection $sessionBus, DBusSigHandler $colorSchemeHandler) {
            try {
                $sessionBus.removeSigHandler(ISettings.SettingChanged.class, $colorSchemeHandler);
                Logger.INSTANCE.debug("Linux theme listener removed");
            }
            catch (Throwable e) {
                Logger.INSTANCE.warn(e, "Error removing Linux theme listener: " + e.getMessage());
            }
            return Unit.INSTANCE;
        }
    }));
    @NotNull
    private static final String THEME_NAMESPACE = "org.freedesktop.appearance";
    @NotNull
    private static final String THEME_KEY = "color-scheme";

    @Nullable
    public static final Boolean getLinuxThemeIsDark() {
        Variant colorScheme;
        Variant variant;
        try {
            ISettings remoteObject = (ISettings)ThemeKt.getSessionBus().getRemoteObject("org.freedesktop.portal.Desktop", "/org/freedesktop/portal/desktop", ISettings.class);
            variant = remoteObject.Read(THEME_NAMESPACE, THEME_KEY);
        }
        catch (Throwable e) {
            Logger.INSTANCE.debug(e, ThemeKt::_get_linuxThemeIsDark_$lambda$0);
            variant = null;
        }
        Variant variant2 = colorScheme = variant;
        return variant2 != null ? ThemeKt.isDark(variant2) : null;
    }

    @NotNull
    public static final Flow<Boolean> getLinuxThemeFlow() {
        return linuxThemeFlow;
    }

    private static final DBusConnection getSessionBus() {
        return DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
    }

    private static final UInt32 unpackUInt32(Variant<?> $this$unpackUInt32) {
        Object value2 = $this$unpackUInt32.getValue();
        return value2 instanceof UInt32 ? (UInt32)value2 : (value2 instanceof Variant ? ThemeKt.unpackUInt32((Variant)value2) : null);
    }

    private static final boolean isDark(UInt32 $this$isDark) {
        return switch ($this$isDark.intValue()) {
            case 0 -> {
                Logger.INSTANCE.debug("The system reports there is no preference for color-scheme, treating it as isDark=false");
                yield false;
            }
            case 1 -> true;
            case 2 -> false;
            default -> {
                Logger.INSTANCE.debug("Unknown UInt32 for color-scheme (" + $this$isDark + "), treating it as isDark=false");
                yield false;
            }
        };
    }

    private static final Boolean isDark(Variant<?> $this$isDark) {
        UInt32 uInt32 = ThemeKt.unpackUInt32($this$isDark);
        if (uInt32 == null) {
            Logger.INSTANCE.warn("Can't unpack UInt32 for " + $this$isDark);
            return null;
        }
        return ThemeKt.isDark(uInt32);
    }

    private static final String _get_linuxThemeIsDark_$lambda$0() {
        return "Can't get theme from remote";
    }

    public static final /* synthetic */ DBusConnection access$getSessionBus() {
        return ThemeKt.getSessionBus();
    }

    public static final /* synthetic */ Boolean access$isDark(Variant $receiver) {
        return ThemeKt.isDark($receiver);
    }
}

