/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.jbclient;

import com.intellij.station.comms.common.recents.RecentProjectsRequest;
import com.intellij.station.comms.common.recents.RecentProjectsResponse;
import com.jetbrains.toolbox.UIEvent;
import com.jetbrains.toolbox.UIGlobalState;
import com.jetbrains.toolbox.gateway.DevEnvironment;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.DevEnvironmentManager;
import com.jetbrains.toolbox.gateway.DevEnvironmentProvider;
import com.jetbrains.toolbox.gateway.log.RemoteDevLogArchiveCollector;
import com.jetbrains.toolbox.gateway.project.UtilsKt;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.project.ProjectManager;
import com.jetbrains.toolbox.project.RemoteProject;
import com.jetbrains.toolbox.tools.model.ProjectId;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nRecentProjectActionsRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentProjectActionsRunner.kt\ncom/jetbrains/toolbox/jbclient/RecentProjectActionsRunner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1#2:100\n1869#3:101\n1869#3,2:102\n1870#3:104\n*S KotlinDebug\n*F\n+ 1 RecentProjectActionsRunner.kt\ncom/jetbrains/toolbox/jbclient/RecentProjectActionsRunner\n*L\n90#1:101\n91#1:102,2\n90#1:104\n*E\n"})
public final class RecentProjectActionsRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DevEnvironmentManager environmentManager;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final UIGlobalState uiGlobalState;
    @NotNull
    private final RemoteDevLogArchiveCollector remoteDevLogArchiveCollector;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private static final Map<String, RecentProjectActionInfo> actions;

    public RecentProjectActionsRunner(@NotNull DevEnvironmentManager environmentManager, @NotNull ProjectManager projectManager, @NotNull UIGlobalState uiGlobalState, @NotNull RemoteDevLogArchiveCollector remoteDevLogArchiveCollector, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)environmentManager, (String)"environmentManager");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)uiGlobalState, (String)"uiGlobalState");
        Intrinsics.checkNotNullParameter((Object)remoteDevLogArchiveCollector, (String)"remoteDevLogArchiveCollector");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.environmentManager = environmentManager;
        this.projectManager = projectManager;
        this.uiGlobalState = uiGlobalState;
        this.remoteDevLogArchiveCollector = remoteDevLogArchiveCollector;
        this.coroutineScope = coroutineScope;
    }

    public final void runAction(@NotNull RecentProjectsRequest.InvokeAction requestAction) {
        Intrinsics.checkNotNullParameter((Object)requestAction, (String)"requestAction");
        try {
            Companion.getAction(requestAction.getActionId()).execute(requestAction.getId(), this);
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Failed to execute action " + requestAction.getActionId() + ": " + e.getMessage() + "}");
        }
    }

    private final void processViewProject(String projectId) {
        block0: {
            DevEnvironment devEnvironment = this.getEnvironment(projectId);
            if (devEnvironment == null) break block0;
            DevEnvironment it = devEnvironment;
            boolean bl = false;
            DevEnvironmentId envId = it.getId();
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, envId, null){
                int label;
                final /* synthetic */ RecentProjectActionsRunner this$0;
                final /* synthetic */ DevEnvironmentId $envId;
                {
                    this.this$0 = $receiver;
                    this.$envId = $envId;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = RecentProjectActionsRunner.access$getUiGlobalState$p(this.this$0).processEvent(new UIEvent.GatewayShowEnvironment(this.$envId.getProviderId-rwbms5E(), this.$envId.getEnvironmentId()), (Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final void processCollectLogs(String projectId) {
        block0: {
            DevEnvironment devEnvironment = this.getEnvironment(projectId);
            if (devEnvironment == null) break block0;
            DevEnvironment env = devEnvironment;
            boolean bl = false;
            BuildersKt.launch$default((CoroutineScope)env.getEnvironmentScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, env, null){
                int label;
                final /* synthetic */ RecentProjectActionsRunner this$0;
                final /* synthetic */ DevEnvironment $env;
                {
                    this.this$0 = $receiver;
                    this.$env = $env;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = RemoteDevLogArchiveCollector.collectAllLogs-OoiPzSQ$default(RecentProjectActionsRunner.access$getRemoteDevLogArchiveCollector$p(this.this$0), this.$env.getId(), null, false, (Continuation)this, 4, null);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final DevEnvironment getEnvironment(String projectId) {
        block4: {
            var2_2 = ((ProjectManager.Model)this.projectManager.getState().getValue()).get-CD0_5dk(ProjectId.constructor-impl(projectId));
            if (var2_2 == null) ** GOTO lbl-1000
            it = var4_3 = var2_2;
            $i$a$-takeIf-RecentProjectActionsRunner$getEnvironment$1 = false;
            v0 = var3_7 = it instanceof RemoteProject != false ? var4_3 : null;
            if (var3_7 != null) {
                it = var3_7;
                $i$a$-let-RecentProjectActionsRunner$getEnvironment$2 = false;
                projectEnvId = ((RemoteProject)it).getEnvironmentId-U8Tzcn4();
                $i$a$-let-RecentProjectActionsRunner$getEnvironment$3 = false;
                $this$forEach$iv = (Iterable)this.environmentManager.getProviders().getValue();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    provider = (DevEnvironmentProvider)element$iv;
                    $i$a$-forEach-RecentProjectActionsRunner$getEnvironment$3$1 = false;
                    v1 = (List)provider.getEnvironments().getValue();
                    if (v1 == null) continue;
                    $this$forEach$iv = v1;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        environment = (DevEnvironment)element$iv;
                        $i$a$-forEach-RecentProjectActionsRunner$getEnvironment$3$1$1 = false;
                        if (!RemoteProject.EnvironmentId.equals-impl0(UtilsKt.toProjectEnvironmentId(environment.getId()), projectEnvId)) continue;
                        v2 = environment;
                        break block4;
                    }
                }
                v2 = null;
            } else lbl-1000:
            // 2 sources

            {
                v2 = null;
            }
        }
        return v2;
    }

    public static final /* synthetic */ UIGlobalState access$getUiGlobalState$p(RecentProjectActionsRunner $this) {
        return $this.uiGlobalState;
    }

    public static final /* synthetic */ RemoteDevLogArchiveCollector access$getRemoteDevLogArchiveCollector$p(RecentProjectActionsRunner $this) {
        return $this.remoteDevLogArchiveCollector;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"action-view-environment", (Object)ViewEnvironmentAction.INSTANCE), TuplesKt.to((Object)"action-collect-logs", (Object)CollectLogsAction.INSTANCE)};
        actions = MapsKt.mapOf((Pair[])pairArray);
    }

    public static final class CollectLogsAction
    implements RecentProjectActionInfo {
        @NotNull
        public static final CollectLogsAction INSTANCE = new CollectLogsAction();

        private CollectLogsAction() {
        }

        @NotNull
        public RecentProjectsResponse.Action toResponseAction(@NotNull I18n i18n) {
            Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
            return new RecentProjectsResponse.Action("action-collect-logs", i18n.tr("Collect Logs"), null, true, 4, null);
        }

        @Override
        public void execute(@NotNull String projectId, @NotNull RecentProjectActionsRunner runner) {
            Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
            Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
            runner.processCollectLogs(projectId);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RecentProjectActionInfo getAction(@NotNull String actionId) {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            RecentProjectActionInfo recentProjectActionInfo = (RecentProjectActionInfo)actions.get(actionId);
            if (recentProjectActionInfo == null) {
                throw new IllegalArgumentException("Unknown action id " + actionId);
            }
            return recentProjectActionInfo;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static interface RecentProjectActionInfo {
        public void execute(@NotNull String var1, @NotNull RecentProjectActionsRunner var2);
    }

    public static final class ViewEnvironmentAction
    implements RecentProjectActionInfo {
        @NotNull
        public static final ViewEnvironmentAction INSTANCE = new ViewEnvironmentAction();

        private ViewEnvironmentAction() {
        }

        @NotNull
        public RecentProjectsResponse.Action toResponseAction(@NotNull I18n i18n) {
            Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
            return new RecentProjectsResponse.Action("action-view-environment", i18n.tr("View in Toolbox"), null, true, 4, null);
        }

        @Override
        public void execute(@NotNull String projectId, @NotNull RecentProjectActionsRunner runner) {
            Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
            Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
            runner.processViewProject(projectId);
        }
    }
}

