/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij.vmoptions;

import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.common.io.PathExtensionsKt;
import com.jetbrains.toolbox.intellij.vmoptions.VmOption;
import com.jetbrains.toolbox.intellij.vmoptions.VmOptionsEditor;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.uuid.Uuid;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nVmOptionsValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VmOptionsValidator.kt\ncom/jetbrains/toolbox/intellij/vmoptions/VmOptionsValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1869#2,2:85\n*S KotlinDebug\n*F\n+ 1 VmOptionsValidator.kt\ncom/jetbrains/toolbox/intellij/vmoptions/VmOptionsValidator\n*L\n47#1:85,2\n*E\n"})
public final class VmOptionsValidator {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Path portsDirectory;

    public VmOptionsValidator(@NotNull FileSystem fileSystem, @NotNull Path portsDirectory) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)portsDirectory, (String)"portsDirectory");
        this.fileSystem = fileSystem;
        this.portsDirectory = portsDirectory;
    }

    public final void ensureIdeNotificationProperties(@NotNull VmOptionsEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (editor.getSystemProperty("toolbox.notification.token") == null) {
            String toolboxTokenValue = Uuid.Companion.random().toString();
            editor.setSystemProperty("toolbox.notification.token", toolboxTokenValue);
        }
        if (editor.getSystemProperty("toolbox.notification.portFile") == null) {
            Path toolboxPortFile = this.portsDirectory.resolve(Uuid.Companion.random() + ".port");
            editor.setSystemProperty("toolbox.notification.portFile", toolboxPortFile.toString());
        }
    }

    public final void removeTempSystemOptions(@NotNull VmOptionsEditor editor, @NotNull Path tempDir) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Object[] objectArray = new String[]{"idea.config.path", "idea.system.path", "idea.plugins.path", "idea.log.path"};
        List dropDirs = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = dropDirs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VmOption propValue;
            Path path2;
            String dirToDrop = (String)element$iv;
            boolean bl = false;
            if (editor.getSystemProperty(dirToDrop) == null || this.fileSystem.exists(path2 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)propValue.getValue(), (boolean)false, (int)1, null)) || !PathExtensionsKt.contains(tempDir, path2)) continue;
            Logger.INSTANCE.debug(propValue + " is under temp directory and doesn't exist, removing property");
            editor.removeSystemProperty(dirToDrop);
        }
    }

    public static /* synthetic */ void removeTempSystemOptions$default(VmOptionsValidator vmOptionsValidator, VmOptionsEditor vmOptionsEditor, Path path2, int n, Object object) {
        if ((n & 2) != 0) {
            path2 = StandardPaths.INSTANCE.getOkioTempDir();
        }
        vmOptionsValidator.removeTempSystemOptions(vmOptionsEditor, path2);
    }

    public final void ensureXmxOption(@NotNull VmOptionsEditor defaultEditor, @NotNull Path path2, @NotNull VmOptionsEditor editor) {
        Integer xmxMb;
        Integer defaultXmxInMb;
        VmOption.Xmx defaultXmx;
        Intrinsics.checkNotNullParameter((Object)defaultEditor, (String)"defaultEditor");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VmOption.Xmx xmx = defaultXmx = defaultEditor.getXmx();
        Integer n = defaultXmxInMb = xmx != null ? Integer.valueOf(xmx.inMegaBytes()) : null;
        if (defaultXmx == null || defaultXmxInMb == null) {
            Logger.INSTANCE.debug("ensureCorrectSettings: unable to parse default xmx for item " + path2);
            return;
        }
        VmOption.Xmx xmx2 = editor.getXmx();
        Integer n2 = xmxMb = xmx2 != null ? Integer.valueOf(xmx2.inMegaBytes()) : null;
        if (xmxMb == null) {
            Logger.INSTANCE.warn("ensureCorrectSettings: unable to parse xmx in " + path2 + ", restoring default value of " + defaultXmx);
            editor.applyVmOption(defaultXmx);
            return;
        }
        if (xmxMb < defaultXmxInMb) {
            Logger.INSTANCE.warn("ensureCorrectSettings: current xmx " + xmxMb + "m is less than default xmx " + defaultXmxInMb + "m. Restoring default value of " + defaultXmx + " in " + path2);
            editor.applyVmOption(defaultXmx);
        }
    }
}

