/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij.vmoptions;

import com.jetbrains.toolbox.intellij.vmoptions.GcOptionImpl;
import com.jetbrains.toolbox.intellij.vmoptions.SystemOptionImpl;
import com.jetbrains.toolbox.intellij.vmoptions.UnknownOptionImpl;
import com.jetbrains.toolbox.intellij.vmoptions.XmxOptionImpl;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public sealed interface VmOption {
    @NotNull
    public static final Companion Companion = com.jetbrains.toolbox.intellij.vmoptions.VmOption$Companion.$$INSTANCE;

    @NotNull
    public String getValue();

    default public boolean isSameAs(@NotNull VmOption other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this instanceof GC && other instanceof GC ? true : (this instanceof Xmx && other instanceof Xmx ? true : (this instanceof Unknown && other instanceof Unknown ? Intrinsics.areEqual((Object)this.getValue(), (Object)other.getValue()) : (this instanceof System && other instanceof System ? Intrinsics.areEqual((Object)((System)this).getName(), (Object)((System)other).getName()) : false)));
    }

    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final VmOption createVmOption(@NotNull String option) {
            VmOption vmOption;
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            if (StringsKt.startsWith$default((String)option, (String)"-Xmx", (boolean)false, (int)2, null) && XmxOptionImpl.Companion.isValidXmx(option)) {
                vmOption = this.createXmxOption(StringsKt.removePrefix((String)option, (CharSequence)"-Xmx"));
            } else if (StringsKt.startsWith$default((String)option, (String)"-D", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)option, (CharSequence)"=", (boolean)false, (int)2, null)) {
                String[] stringArray = new String[]{"="};
                List list2 = StringsKt.split$default((CharSequence)option, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
                String name2 = (String)list2.get(0);
                String value2 = (String)list2.get(1);
                vmOption = this.createSystemOption(name2, value2);
            } else {
                vmOption = StringsKt.startsWith$default((String)option, (String)"-XX:+Use", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)option, (String)"GC", (boolean)false, (int)2, null) ? (VmOption)new GcOptionImpl(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)option, (String)"-XX:+Use", null, (int)2, null), (String)"GC", null, (int)2, null)) : (VmOption)new UnknownOptionImpl(option);
            }
            return vmOption;
        }

        @NotNull
        public final Xmx createXmxOption(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return new XmxOptionImpl(value2);
        }

        @NotNull
        public final System createSystemOption(@NotNull String name2, @NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return new SystemOptionImpl(StringsKt.removePrefix((String)name2, (CharSequence)"-D"), value2);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    public static non-sealed interface GC
    extends VmOption {
    }

    public static non-sealed interface System
    extends VmOption {
        @NotNull
        public String getName();
    }

    public static non-sealed interface Unknown
    extends VmOption {
    }

    public static non-sealed interface Xmx
    extends VmOption,
    Comparable<Xmx> {
        public long getBytes();

        public int inMegaBytes();
    }
}

