/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij.plugins;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VSCodeCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<String> args;

    public VSCodeCommand(@NotNull String name2, @NotNull List<String> args) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.name = name2;
        this.args = args;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<String> getArgs() {
        return this.args;
    }

    @NotNull
    public String toString() {
        return "VSCodeCommand(name=" + this.name + ", args=" + this.args + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + ((Object)this.args).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VSCodeCommand)) {
            return false;
        }
        VSCodeCommand vSCodeCommand = (VSCodeCommand)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)vSCodeCommand.name)) {
            return false;
        }
        return Intrinsics.areEqual(this.args, vSCodeCommand.args);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VSCodeCommand listExtensions() {
            return new VSCodeCommand("list VSCode plugins", CollectionsKt.listOf((Object)"--list-extensions"));
        }

        @NotNull
        public final VSCodeCommand installExtension(@NotNull String pluginId, @NotNull String pathOrId) {
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            Intrinsics.checkNotNullParameter((Object)pathOrId, (String)"pathOrId");
            Object[] objectArray = new String[]{"--force", "--install-extension", pathOrId};
            return new VSCodeCommand("install Visual Studio Code plugin " + pluginId, CollectionsKt.listOf((Object[])objectArray));
        }

        @NotNull
        public final VSCodeCommand unInstallExtension(@NotNull String pluginId) {
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            Object[] objectArray = new String[]{"--force", "--uninstall-extension", pluginId};
            return new VSCodeCommand("uninstall Visual Studio Code plugin " + pluginId, CollectionsKt.listOf((Object[])objectArray));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

