/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij.plugins;

import com.jetbrains.toolbox.FileUtils;
import com.jetbrains.toolbox.intellij.IntelliJToolExtensionKt;
import com.jetbrains.toolbox.intellij.plugins.IntelliJPluginDownloaderImpl;
import com.jetbrains.toolbox.intellij.plugins.IntelliJPluginDownloaderImplKt;
import com.jetbrains.toolbox.intellij.plugins.IntelliJPluginVerifier;
import com.jetbrains.toolbox.intellij.plugins.PluginDownloadData;
import com.jetbrains.toolbox.intellij.plugins.PluginDownloadResult;
import com.jetbrains.toolbox.intellij.plugins.PluginDownloaderCommon;
import com.jetbrains.toolbox.intellij.plugins.ToolPluginDownloader;
import com.jetbrains.toolbox.intellij.plugins.ToolPluginOrphanedBinariesCleaner;
import com.jetbrains.toolbox.interop.ZipExtractorKt;
import com.jetbrains.toolbox.network.DownloadManager;
import com.jetbrains.toolbox.shell.ShellEnvironment;
import com.jetbrains.toolbox.tools.WellKnownApplications;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import java.io.IOException;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.uuid.Uuid;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class IntelliJPluginDownloaderImpl
extends PluginDownloaderCommon
implements ToolPluginDownloader {
    @NotNull
    private final DownloadManager downloadManager;
    @NotNull
    private final ShellEnvironment shellEnvironment;
    @NotNull
    private final FileSystem fileSystem;
    @Nullable
    private final IntelliJPluginVerifier intelliJPluginVerifier;
    @NotNull
    private final ToolPluginOrphanedBinariesCleaner toolPluginCleaner;
    @NotNull
    private final FileUtils fileUtils;
    @NotNull
    private final String prefix;

    public IntelliJPluginDownloaderImpl(@NotNull DownloadManager downloadManager, @NotNull ShellEnvironment shellEnvironment, @NotNull FileSystem fileSystem, @Nullable IntelliJPluginVerifier intelliJPluginVerifier, @NotNull ToolPluginOrphanedBinariesCleaner toolPluginCleaner, @NotNull FileUtils fileUtils, @Nullable String name2) {
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)shellEnvironment, (String)"shellEnvironment");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)toolPluginCleaner, (String)"toolPluginCleaner");
        Intrinsics.checkNotNullParameter((Object)fileUtils, (String)"fileUtils");
        super(downloadManager, fileSystem);
        this.downloadManager = downloadManager;
        this.shellEnvironment = shellEnvironment;
        this.fileSystem = fileSystem;
        this.intelliJPluginVerifier = intelliJPluginVerifier;
        this.toolPluginCleaner = toolPluginCleaner;
        this.fileUtils = fileUtils;
        String string = name2;
        this.prefix = (String)(string != null ? string + "-" : "") + "intellij-plugin";
    }

    public /* synthetic */ IntelliJPluginDownloaderImpl(DownloadManager downloadManager, ShellEnvironment shellEnvironment, FileSystem fileSystem, IntelliJPluginVerifier intelliJPluginVerifier, ToolPluginOrphanedBinariesCleaner toolPluginOrphanedBinariesCleaner, FileUtils fileUtils, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            string = null;
        }
        this(downloadManager, shellEnvironment, fileSystem, intelliJPluginVerifier, toolPluginOrphanedBinariesCleaner, fileUtils, string);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object downloadZippedPlugin(@NotNull PluginDownloadData pluginDownloadData, @Nullable String eTag, @NotNull Continuation<? super PluginDownloadResult> $completion) {
        block18: {
            if (!($completion instanceof downloadZippedPlugin.1)) ** GOTO lbl-1000
            var10_4 = $completion;
            if ((var10_4.label & -2147483648) != 0) {
                var10_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    /* synthetic */ Object result;
                    final /* synthetic */ IntelliJPluginDownloaderImpl this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.downloadZippedPlugin(null, null, (Continuation<? super PluginDownloadResult>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    downloadedFile = this.downloadManager.getDownloadDirectory().resolve(this.pluginUniqueName$intellij(pluginDownloadData));
                    $continuation.L$0 = pluginDownloadData;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)eTag);
                    $continuation.L$2 = downloadedFile;
                    $continuation.label = 1;
                    v0 = this.downloadZippedPlugin-qzOQ-yY(pluginDownloadData.getUrl(), pluginDownloadData.getPluginId-b6BwIdc(), eTag, downloadedFile, (Continuation<? super PluginDownloadResult>)$continuation);
                    if (v0 == var11_6) {
                        return var11_6;
                    }
                    ** GOTO lbl27
                }
                case 1: {
                    downloadedFile = (Path)$continuation.L$2;
                    eTag = (String)$continuation.L$1;
                    pluginDownloadData = (PluginDownloadData)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl27:
                    // 2 sources

                    if (!((result = (PluginDownloadResult)v0) instanceof PluginDownloadResult.Success)) break;
                    v1 = this.intelliJPluginVerifier;
                    v2 = var6_12 = v1 != null ? v1.verifyZippedPlugin-3arw3uo(downloadedFile, pluginDownloadData.getPluginId-b6BwIdc()) : null;
                    if (!Intrinsics.areEqual((Object)var6_12, (Object)IntelliJPluginVerifier.Result.Success.INSTANCE)) ** GOTO lbl33
                    Logger.INSTANCE.debug("Checksum verification successful for plugin downloaded from " + pluginDownloadData.getUrl());
                    break block18;
lbl33:
                    // 1 sources

                    if (!Intrinsics.areEqual((Object)var6_12, (Object)IntelliJPluginVerifier.Result.Failure.INSTANCE)) break;
                    Logger.INSTANCE.warn("Checksum verification failed for plugin downloaded from " + pluginDownloadData.getUrl());
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)pluginDownloadData);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)eTag);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)downloadedFile);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)result);
                    $continuation.label = 2;
                    v3 = this.deleteFile(downloadedFile, (Continuation<? super Unit>)$continuation);
                    if (v3 == var11_6) {
                        return var11_6;
                    }
                    ** GOTO lbl51
                }
                case 2: {
                    result = (PluginDownloadResult)$continuation.L$3;
                    downloadedFile = (Path)$continuation.L$2;
                    eTag = (String)$continuation.L$1;
                    pluginDownloadData = (PluginDownloadData)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl51:
                    // 2 sources

                    return PluginDownloadResult.VerificationError.INSTANCE;
                }
            }
            if (var6_12 == null || Intrinsics.areEqual((Object)var6_12, (Object)IntelliJPluginVerifier.Result.Skipped.INSTANCE)) {
                Logger.INSTANCE.debug("Checksum verification skipped for plugin downloaded from " + pluginDownloadData.getUrl());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        tempPluginFileUnpacked = this.fileUtils.createTempDirectory(this.prefix);
        try {
            ZipExtractorKt.extractZip(this.shellEnvironment, this.fileSystem, downloadedFile, tempPluginFileUnpacked);
            Logger.INSTANCE.debug("Unpacked plugin file " + downloadedFile + " into " + tempPluginFileUnpacked);
            return new PluginDownloadResult.Success(tempPluginFileUnpacked, ((PluginDownloadResult.Success)result).getETag(), this.toolPluginCleaner);
        }
        catch (Exception t) {
            Logger.INSTANCE.warn("Failed to unpack plugin from " + pluginDownloadData.getUrl() + " to " + tempPluginFileUnpacked + " (" + t + ")");
            $continuation.L$0 = pluginDownloadData;
            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)eTag);
            $continuation.L$2 = downloadedFile;
            $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)result);
            $continuation.L$4 = tempPluginFileUnpacked;
            $continuation.L$5 = t;
            $continuation.label = 3;
            v4 = this.deleteFile(downloadedFile, (Continuation<? super Unit>)$continuation);
            ** if (v4 != var11_6) goto lbl77
lbl76:
            // 1 sources

            return var11_6;
lbl77:
            // 1 sources

        }
        {
            case 3: {
                t = (Exception)$continuation.L$5;
                tempPluginFileUnpacked = (Path)$continuation.L$4;
                result = (PluginDownloadResult)$continuation.L$3;
                downloadedFile = (Path)$continuation.L$2;
                eTag = (String)$continuation.L$1;
                pluginDownloadData = (PluginDownloadData)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
                {
                    catch (IOException e) {
                        return this.failedToDelete(e, downloadedFile);
                    }
                }
                return new PluginDownloadResult.Error("Failed to unpack plugin from " + pluginDownloadData.getUrl() + " to " + tempPluginFileUnpacked + " (" + t + ")");
            }
        }
        return result;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public boolean matches(@NotNull InstalledTool tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        return !WellKnownApplications.INSTANCE.isVSCodeType-lOMW6pk(tool.getToolId-UtVBrGo()) && IntelliJToolExtensionKt.getIntellijExtension(tool) != null;
    }

    @NotNull
    public final String pluginUniqueName$intellij(@NotNull PluginDownloadData pluginDownloadData) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)pluginDownloadData, (String)"pluginDownloadData");
        return (pluginDownloadData.isRedirect() ? IntelliJPluginDownloaderImplKt.toUuid(pluginDownloadData.getUrl().toString()) : (!((charSequence = (CharSequence)pluginDownloadData.getETag()) == null || StringsKt.isBlank((CharSequence)charSequence)) ? IntelliJPluginDownloaderImplKt.toUuid(pluginDownloadData.getETag() + pluginDownloadData.getUrl()) : Uuid.Companion.random())).toString();
    }
}

