/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.OSKt;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.feed.DefaultConfigDirectories;
import com.jetbrains.toolbox.intellij.IntelliJChannelExtension;
import com.jetbrains.toolbox.intellij.IntelliJToolExtension;
import com.jetbrains.toolbox.intellij.IntelliJToolExtensionKt;
import com.jetbrains.toolbox.intellij.UtilKt;
import com.jetbrains.toolbox.licensing.LicenseCollection;
import com.jetbrains.toolbox.licensing.LicenseInfoProvider;
import com.jetbrains.toolbox.manager.tool.ToolManager;
import com.jetbrains.toolbox.manager.tool.ToolManagerProvider;
import com.jetbrains.toolbox.tools.WellKnownApplications;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.ChannelStateKt;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.UniversalToolConfigurator;
import com.jetbrains.toolbox.tools.model.licensing.LicenseInfo;
import com.jetbrains.toolbox.tools.model.licensing.LicenseInfoKt;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nIntelliJSplashMarkerFileUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJSplashMarkerFileUpdater.kt\ncom/jetbrains/toolbox/intellij/IntelliJSplashMarkerFileUpdater\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,76:1\n1#2:77\n80#3:78\n165#3:79\n81#3:80\n82#3:85\n52#4,4:81\n60#4,10:86\n56#4,18:96\n*S KotlinDebug\n*F\n+ 1 IntelliJSplashMarkerFileUpdater.kt\ncom/jetbrains/toolbox/intellij/IntelliJSplashMarkerFileUpdater\n*L\n64#1:78\n64#1:79\n64#1:80\n64#1:85\n64#1:81,4\n64#1:86,10\n64#1:96,18\n*E\n"})
public final class IntelliJSplashMarkerFileUpdater
extends UniversalToolConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final LicenseInfoProvider licenseInfoProvider;
    @NotNull
    private final ToolManagerProvider toolManagerProvider;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Lazy toolManager$delegate;
    @NotNull
    private static final String minimumSupportedVersion = BuildNumber.constructor-impl("253");

    public IntelliJSplashMarkerFileUpdater(@NotNull FileSystem fileSystem, @NotNull LicenseInfoProvider licenseInfoProvider, @NotNull ToolManagerProvider toolManagerProvider, @NotNull Clock clock, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)licenseInfoProvider, (String)"licenseInfoProvider");
        Intrinsics.checkNotNullParameter((Object)toolManagerProvider, (String)"toolManagerProvider");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.fileSystem = fileSystem;
        this.licenseInfoProvider = licenseInfoProvider;
        this.toolManagerProvider = toolManagerProvider;
        this.clock = clock;
        this.toolManager$delegate = LazyKt.lazy(() -> IntelliJSplashMarkerFileUpdater.toolManager_delegate$lambda$0(this));
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ IntelliJSplashMarkerFileUpdater this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.licenseInfoProvider.getLicenseCollection()), (Function2)((Function2)new Function2<LicenseCollection<? extends LicenseInfo>, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ IntelliJSplashMarkerFileUpdater this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                LicenseCollection licenseCollection = (LicenseCollection)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$forEach$iv;
                                        void $this$mapNotNullTo$iv$iv;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Iterable $this$mapNotNull$iv = ((Map)this.this$0.getToolManager().getModel().getValue()).values();
                                        boolean $i$f$mapNotNull = false;
                                        Iterable iterable = $this$mapNotNull$iv;
                                        Collection destination$iv$iv = new ArrayList();
                                        boolean $i$f$mapNotNullTo = false;
                                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                        boolean $i$f$forEach = false;
                                        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                                        while (iterator2.hasNext()) {
                                            ToolInstance it$iv$iv;
                                            Object element$iv$iv$iv;
                                            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                                            boolean bl = false;
                                            ChannelState it = (ChannelState)element$iv$iv;
                                            boolean bl2 = false;
                                            if (ChannelStateKt.toToolInstanceOrNull(it) == null) continue;
                                            boolean bl3 = false;
                                            destination$iv$iv.add(it$iv$iv);
                                        }
                                        $this$mapNotNull$iv = (List)destination$iv$iv;
                                        IntelliJSplashMarkerFileUpdater intelliJSplashMarkerFileUpdater = this.this$0;
                                        boolean $i$f$forEach2 = false;
                                        for (Object element$iv : $this$forEach$iv) {
                                            void licenseCollection2;
                                            ToolInstance it = (ToolInstance)element$iv;
                                            boolean bl = false;
                                            intelliJSplashMarkerFileUpdater.updateMarkerFile(it, (LicenseCollection)licenseCollection2);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(LicenseCollection<? extends LicenseInfo> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final ToolManager getToolManager() {
        Lazy lazy = this.toolManager$delegate;
        return (ToolManager)lazy.getValue();
    }

    @Override
    @Nullable
    public Object configure(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super ToolInstance> $completion) {
        this.updateMarkerFile(toolInstance, (LicenseCollection)this.licenseInfoProvider.getLicenseCollection().getValue());
        return toolInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void updateMarkerFile(ToolInstance toolInstance, LicenseCollection<? extends LicenseInfo> licenseCollection) {
        LicenseInfo licenseInfo;
        if (!ApplicationType.equals-impl0(toolInstance.getTool().getToolId-UtVBrGo(), WellKnownApplications.INSTANCE.getIdeaUltimate-UtVBrGo())) return;
        if (BuildNumber.compareTo-Szkhn3Q(toolInstance.getTool().getBuildNumber-Y_E1uuk(), minimumSupportedVersion) < 0) {
            return;
        }
        IntelliJChannelExtension intelliJChannelExtension = UtilKt.getIntellij(toolInstance.getChannel());
        if (intelliJChannelExtension == null) {
            return;
        }
        IntelliJChannelExtension intellij = intelliJChannelExtension;
        DefaultConfigDirectories defaultConfigDirectories = intellij.getConfigDirectoriesOverride();
        if (defaultConfigDirectories == null) {
            IntelliJToolExtension intelliJToolExtension = IntelliJToolExtensionKt.getIntellijExtension(toolInstance.getTool());
            defaultConfigDirectories = intelliJToolExtension != null ? intelliJToolExtension.getDefaultConfigDirectories() : null;
        }
        DefaultConfigDirectories defaultDirectories = defaultConfigDirectories;
        DefaultConfigDirectories defaultConfigDirectories2 = intellij.getIdeDirectories().override(defaultDirectories);
        DefaultConfigDirectories defaultConfigDirectories3 = defaultConfigDirectories2;
        if (defaultConfigDirectories2 == null) return;
        if ((defaultConfigDirectories3 = OSKt.getExpanded-WIZC_Bo(defaultConfigDirectories3.getConfig-6QkRYPI())) == null) {
            return;
        }
        DefaultConfigDirectories configDirectory = defaultConfigDirectories3;
        InstalledTool tool = toolInstance.getTool();
        Instant now2 = this.clock.now();
        LicenseInfo licenseInfo2 = licenseCollection.filter(tool).best(now2);
        LicenseInfo licenseInfo3 = licenseInfo2;
        if (licenseInfo2 == null) return;
        LicenseInfo it = licenseInfo = licenseInfo3;
        boolean bl = false;
        if (!LicenseInfoKt.validAt(it, now2)) return;
        LicenseInfo licenseInfo4 = licenseInfo;
        licenseInfo3 = licenseInfo4;
        if (licenseInfo4 == null) {
            return;
        }
        Path markerFile = configDirectory.resolve("splash-subscription-mode.txt");
        try {
            Unit unit;
            Throwable thrown$iv$iv;
            block22: {
                void $this$iv;
                if (this.fileSystem.exists(markerFile)) return;
                String fullToolName = "'" + tool.getToolName() + " " + tool.getVersionName() + "'";
                if (!this.fileSystem.exists((Path)configDirectory)) {
                    Logger.INSTANCE.info("Config directory '" + (Path)configDirectory + "' does not exist; the marker file will not be created even though the license for " + fullToolName + " was found");
                    return;
                }
                Logger.INSTANCE.info("License found for " + fullToolName + ", creating marker file '" + markerFile + "'");
                licenseInfo = this.fileSystem;
                Path file$iv = markerFile;
                boolean mustCreate$iv = false;
                bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSink $this$updateMarkerFile_u24lambda_u241 = it$iv;
                    boolean bl3 = false;
                    unit = Unit.INSTANCE;
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        unit = null;
                        break block22;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block23: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block23;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            Unit result$iv$iv = unit;
            Throwable throwable = thrown$iv$iv;
            if (throwable == null) return;
            throw throwable;
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Unable to create marker file '" + markerFile + "'");
        }
    }

    private static final ToolManager toolManager_delegate$lambda$0(IntelliJSplashMarkerFileUpdater this$0) {
        return this$0.toolManagerProvider.getToolManager();
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

