/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.integration;

import com.jetbrains.toolbox.ApplicationStartType;
import com.jetbrains.toolbox.CommandLine;
import com.jetbrains.toolbox.common.WellKnownPaths;
import com.jetbrains.toolbox.integration.InstallationTypeTracker;
import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nInstallationTypeTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallationTypeTracker.kt\ncom/jetbrains/toolbox/integration/InstallationTypeTrackerImpl\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 FileSystem.kt\nokio/FileSystem\n*L\n1#1,40:1\n66#2:41\n52#2,4:43\n60#2,10:48\n56#2,3:58\n71#2,3:61\n52#2,4:67\n60#2,10:72\n56#2,18:82\n67#3:42\n68#3:47\n80#3:64\n165#3:65\n81#3:66\n82#3:71\n*S KotlinDebug\n*F\n+ 1 InstallationTypeTracker.kt\ncom/jetbrains/toolbox/integration/InstallationTypeTrackerImpl\n*L\n25#1:41\n25#1:43,4\n25#1:48,10\n25#1:58,3\n25#1:61,3\n34#1:67,4\n34#1:72,10\n34#1:82,18\n25#1:42\n25#1:47\n34#1:64\n34#1:65\n34#1:66\n34#1:71\n*E\n"})
public final class InstallationTypeTrackerImpl
implements InstallationTypeTracker {
    @NotNull
    private final CommandLine commandLine;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final WellKnownPaths wellKnownPaths;
    @NotNull
    private final Path markerFile;

    public InstallationTypeTrackerImpl(@NotNull CommandLine commandLine, @NotNull FileSystem fileSystem, @NotNull WellKnownPaths wellKnownPaths) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)wellKnownPaths, (String)"wellKnownPaths");
        this.commandLine = commandLine;
        this.fileSystem = fileSystem;
        this.wellKnownPaths = wellKnownPaths;
        this.markerFile = this.wellKnownPaths.getToolboxDataLocation().resolve(".installation-type");
    }

    @Override
    @NotNull
    public ApplicationStartType detectInstallationType() {
        ApplicationStartType applicationStartType;
        if (this.commandLine.isInstallMode()) {
            applicationStartType = this.commandLine.getInstallType();
            if (applicationStartType == null) {
                applicationStartType = ApplicationStartType.APP;
            }
        } else {
            applicationStartType = this.readFromFile();
        }
        return applicationStartType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ApplicationStartType readFromFile() {
        if (!this.fileSystem.exists(this.markerFile)) {
            return ApplicationStartType.APP;
        }
        try {
            String string;
            Throwable thrown$iv$iv;
            block18: {
                void this_$iv;
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = this.markerFile;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSource $this$readFromFile_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    string = $this$readFromFile_u24lambda_u240.readUtf8();
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        string = null;
                        break block18;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block19: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block19;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            String result$iv$iv = string;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            String contents = result$iv$iv;
            return ApplicationStartType.valueOf(contents);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read installation type from " + this.markerFile, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeInstallationType(@NotNull ApplicationStartType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        try {
            BufferedSink bufferedSink;
            Throwable thrown$iv$iv;
            block16: {
                void $this$iv;
                FileSystem fileSystem = this.fileSystem;
                Path file$iv = this.markerFile;
                boolean mustCreate$iv = false;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSink $this$writeInstallationType_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    bufferedSink = $this$writeInstallationType_u24lambda_u240.writeUtf8(type2.name());
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        bufferedSink = null;
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block17: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block17;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            BufferedSink result$iv$iv = bufferedSink;
            Throwable throwable = thrown$iv$iv;
            if (throwable == null) return;
            throw throwable;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to write installation type to " + this.markerFile, e);
        }
    }
}

