/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh.parser;

import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface ParsingResult {

    public static final class Failure
    implements ParsingResult {
        @NotNull
        private final String reason;

        public Failure(@NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            this.reason = reason;
        }

        @NotNull
        public final String getReason() {
            return this.reason;
        }

        @NotNull
        public final String component1() {
            return this.reason;
        }

        @NotNull
        public final Failure copy(@NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new Failure(reason);
        }

        public static /* synthetic */ Failure copy$default(Failure failure, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = failure.reason;
            }
            return failure.copy(string);
        }

        @NotNull
        public String toString() {
            return "Failure(reason=" + this.reason + ")";
        }

        public int hashCode() {
            return this.reason.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Failure)) {
                return false;
            }
            Failure failure = (Failure)other;
            return Intrinsics.areEqual((Object)this.reason, (Object)failure.reason);
        }
    }

    public static final class Success
    implements ParsingResult {
        @Nullable
        private final String user;
        @NotNull
        private final String host;
        @Nullable
        private final Integer port;
        @NotNull
        private final Map<String, String> options;

        public Success(@Nullable String user, @NotNull String host, @Nullable Integer port, @NotNull Map<String, String> options) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter(options, (String)"options");
            this.user = user;
            this.host = host;
            this.port = port;
            this.options = options;
        }

        @Nullable
        public final String getUser() {
            return this.user;
        }

        @NotNull
        public final String getHost() {
            return this.host;
        }

        @Nullable
        public final Integer getPort() {
            return this.port;
        }

        @NotNull
        public final Map<String, String> getOptions() {
            return this.options;
        }

        @Nullable
        public final String component1() {
            return this.user;
        }

        @NotNull
        public final String component2() {
            return this.host;
        }

        @Nullable
        public final Integer component3() {
            return this.port;
        }

        @NotNull
        public final Map<String, String> component4() {
            return this.options;
        }

        @NotNull
        public final Success copy(@Nullable String user, @NotNull String host, @Nullable Integer port, @NotNull Map<String, String> options) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter(options, (String)"options");
            return new Success(user, host, port, options);
        }

        public static /* synthetic */ Success copy$default(Success success2, String string, String string2, Integer n, Map map2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = success2.user;
            }
            if ((n2 & 2) != 0) {
                string2 = success2.host;
            }
            if ((n2 & 4) != 0) {
                n = success2.port;
            }
            if ((n2 & 8) != 0) {
                map2 = success2.options;
            }
            return success2.copy(string, string2, n, map2);
        }

        @NotNull
        public String toString() {
            return "Success(user=" + this.user + ", host=" + this.host + ", port=" + this.port + ", options=" + this.options + ")";
        }

        public int hashCode() {
            int result2 = this.user == null ? 0 : this.user.hashCode();
            result2 = result2 * 31 + this.host.hashCode();
            result2 = result2 * 31 + (this.port == null ? 0 : ((Object)this.port).hashCode());
            result2 = result2 * 31 + ((Object)this.options).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Success)) {
                return false;
            }
            Success success2 = (Success)other;
            if (!Intrinsics.areEqual((Object)this.user, (Object)success2.user)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.host, (Object)success2.host)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.port, (Object)success2.port)) {
                return false;
            }
            return Intrinsics.areEqual(this.options, success2.options);
        }
    }
}

