/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh.openssh;

import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.api.remoteDev.ssh.SshConnectionInfo;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.openssh.ConnectionInfo;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nSshConnectionInfoPreprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnectionInfoPreprocessor.kt\ncom/jetbrains/toolbox/gateway/ssh/openssh/SshConnectionInfoPreprocessor\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,101:1\n66#2:102\n52#2,4:104\n60#2,10:109\n56#2,3:119\n71#2,3:122\n66#2:130\n52#2,4:132\n60#2,10:137\n56#2,3:147\n71#2,3:150\n67#3:103\n68#3:108\n81#3:131\n82#3:136\n1#4:125\n1563#5:126\n1634#5,3:127\n774#5:155\n865#5:156\n1761#5,3:157\n866#5:160\n37#6,2:153\n*S KotlinDebug\n*F\n+ 1 SshConnectionInfoPreprocessor.kt\ncom/jetbrains/toolbox/gateway/ssh/openssh/SshConnectionInfoPreprocessor\n*L\n26#1:102\n26#1:104,4\n26#1:109,10\n26#1:119,3\n26#1:122,3\n62#1:130\n62#1:132,4\n62#1:137,10\n62#1:147,3\n62#1:150,3\n26#1:103\n26#1:108\n62#1:131\n62#1:136\n31#1:126\n31#1:127,3\n92#1:155\n92#1:156\n94#1:157,3\n92#1:160\n87#1:153,2\n*E\n"})
public final class SshConnectionInfoPreprocessor {
    @NotNull
    private final FileSystem fs;
    @NotNull
    private final Path tempKeyDirectory;
    @NotNull
    private final Path tempConfigDirectory;

    public SshConnectionInfoPreprocessor(@NotNull FileSystem fs) {
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        this.fs = fs;
        this.tempKeyDirectory = StandardPaths.INSTANCE.getToolboxCacheLocation().resolve("ssh_keys");
        this.tempConfigDirectory = StandardPaths.INSTANCE.getToolboxCacheLocation().resolve("ssh_configs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NotNull
    public final ConnectionInfo preprocess(@NotNull String id, @NotNull SshConnectionInfo sshConnectionInfo, @NotNull String toolboxAskpassExecutable, @NotNull Map<String, String> environment) {
        block31: {
            block30: {
                block28: {
                    Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                    Intrinsics.checkNotNullParameter((Object)sshConnectionInfo, (String)"sshConnectionInfo");
                    Intrinsics.checkNotNullParameter((Object)toolboxAskpassExecutable, (String)"toolboxAskpassExecutable");
                    Intrinsics.checkNotNullParameter(environment, (String)"environment");
                    v0 = sshConnectionInfo.getSshConfigPath();
                    if (v0 == null) break block30;
                    it = v0;
                    $i$a$-let-SshConnectionInfoPreprocessor$preprocess$sshConfigContent$1 = false;
                    var11_9 = this.fs;
                    file$iv = Path.Companion.get$default((Path.Companion)Path.Companion, (String)it, (boolean)false, (int)1, null);
                    $i$f$-read = false;
                    $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                    $i$f$use = false;
                    thrown$iv$iv = null;
                    it$iv = (BufferedSource)$this$use$iv$iv;
                    $i$a$-use-FileSystem$read$1$iv = false;
                    $this$preprocess_u24lambda_u240_u240 = it$iv;
                    $i$a$--read-SshConnectionInfoPreprocessor$preprocess$sshConfigContent$1$1 = false;
                    var18_32 = $this$preprocess_u24lambda_u240_u240.readString(Charsets.UTF_8);
                    try {
                        v1 = $this$use$iv$iv;
                        if (v1 != null) {
                            v1.close();
                        }
                        break block28;
                    }
                    catch (Throwable t$iv$iv) {
                        thrown$iv$iv = t$iv$iv;
                    }
                    break block28;
                    catch (Throwable t$iv$iv) {
                        try {
                            thrown$iv$iv = t$iv$iv;
                            var18_32 = null;
                        }
                        catch (Throwable t$iv$iv) {
                            throw t$iv$iv;
                        }
                        finally {
                            block29: {
                                try {
                                    v2 = $this$use$iv$iv;
                                    if (v2 != null) {
                                        v2.close();
                                    }
                                }
                                catch (Throwable t$iv$iv) {
                                    if (thrown$iv$iv == null) {
                                        thrown$iv$iv = t$iv$iv;
                                        break block29;
                                    }
                                    ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
                                }
                            }
                        }
                    }
                }
                result$iv$iv = var18_32;
                v3 = thrown$iv$iv;
                if (v3 != null) {
                    throw v3;
                }
                v4 = result$iv$iv;
                v0 = v4;
                if (v4 != null) break block31;
            }
            v0 = sshConfigContent = "";
        }
        if ((v5 = sshConnectionInfo.getSshConfig()) == null) ** GOTO lbl-1000
        it = v5;
        $i$a$-let-SshConnectionInfoPreprocessor$preprocess$configPath$1 = false;
        v6 = (it + "\n" + sshConfigContent).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getBytes(...)");
        v7 = this.saveConfigToFile(v6);
        v5 = v7;
        if (v7 != null) {
            v8 = v5.toString();
        } else lbl-1000:
        // 2 sources

        {
            v8 = null;
        }
        configPath = v8;
        v9 = sshConnectionInfo.getPrivateKeys();
        if (v9 != null) {
            keys = v9;
            $i$a$-let-SshConnectionInfoPreprocessor$preprocess$keyPaths$1 = false;
            $this$map$iv = keys;
            $i$f$map = false;
            $i$f$use = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (E item$iv$iv : $this$mapTo$iv$iv) {
                t$iv$iv = (byte[])item$iv$iv;
                var21_43 = destination$iv$iv;
                $i$a$-map-SshConnectionInfoPreprocessor$preprocess$keyPaths$1$1 = false;
                var21_43.add(String.valueOf(this.saveKeyToFile((byte[])it)));
            }
            v10 = (List)destination$iv$iv;
        } else {
            v10 = keyPaths = CollectionsKt.emptyList();
        }
        if ((v11 = sshConnectionInfo.getAskpassExecutable()) == null) {
            v11 = overriddenToolboxExecutable = toolboxAskpassExecutable;
        }
        if ((v12 = sshConnectionInfo.getEnvironment()) == null) {
            v12 = MapsKt.emptyMap();
        }
        mergedEnvironment = MapsKt.plus(environment, (Map)v12);
        var10_8 = sshConnectionInfo.getHost();
        var11_12 = sshConnectionInfo.getUserName();
        var13_18 = sshConnectionInfo.getPort();
        it = ((Number)var13_18).intValue();
        $i$a$-takeIf-SshConnectionInfoPreprocessor$preprocess$1 = false;
        var12_15 = it != 0 != false ? var13_18 : null;
        v13 = sshConnectionInfo.getPrivateKeyPaths();
        var13_18 = CollectionsKt.plus((Collection)keyPaths, (Iterable)(v13 != null ? (Iterable)v13 : (Iterable)CollectionsKt.emptyList()));
        v14 = configPath;
        if (v14 == null) {
            v14 = sshConnectionInfo.getSshConfigPath();
        }
        var14_22 = v14;
        var15_25 = sshConnectionInfo.getShouldUseSystemSshAgent();
        var16_27 = sshConnectionInfo.getShouldUseSystemConfiguration();
        var17_30 = sshConnectionInfo.getShouldAskForPassword();
        return new ConnectionInfo(id, var10_8, var11_12, var12_15, (List)var13_18, var14_22, var16_27, var15_25, var17_30, null, null, overriddenToolboxExecutable, mergedEnvironment, 1536, null);
    }

    private final Path saveKeyToFile(byte[] byteArray) {
        return this.saveToFile(this.tempKeyDirectory, byteArray);
    }

    private final Path saveConfigToFile(byte[] byteArray) {
        return this.saveToFile(this.tempConfigDirectory, byteArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Path saveToFile(Path parentDir, byte[] byteArray) {
        String hash = Base64.encode$default((Base64)((Base64)Base64.Default), (byte[])byteArray, (int)0, (int)0, (int)6, null);
        String name2 = StringsKt.take((String)hash, (int)16);
        Path path2 = parentDir.resolve(name2);
        try {
            BufferedSink bufferedSink;
            Throwable thrown$iv$iv;
            block19: {
                void file$iv;
                void this_$iv;
                this.fs.createDirectories(parentDir, false);
                if (this.fs.exists(path2)) {
                    this.fs.delete(path2);
                }
                FileSystem fileSystem = this.fs;
                Path path3 = path2;
                boolean mustCreate$iv = true;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)this_$iv.sink((Path)file$iv, mustCreate$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSink $this$saveToFile_u24lambda_u240 = it$iv;
                    boolean bl3 = false;
                    bufferedSink = $this$saveToFile_u24lambda_u240.write(byteArray);
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        bufferedSink = null;
                        break block19;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block20: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block20;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            BufferedSink result$iv$iv = bufferedSink;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            if (OS.INSTANCE.isUnix()) {
                Files.setPosixFilePermissions(parentDir.toNioPath(), PosixFilePermissions.fromString("rwx------"));
                Files.setPosixFilePermissions(path2.toNioPath(), PosixFilePermissions.fromString("rw-------"));
            }
            this.clearAclForOwner(path2.toNioPath());
            this.clearAclForOwner(parentDir.toNioPath());
            return path2;
        }
        catch (IOException e) {
            Logger.INSTANCE.warn((Throwable)e, "Failed to save file to " + path2 + ".");
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void clearAclForOwner(java.nio.file.Path path2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        AclFileAttributeView aclFileAttributeView = Files.getFileAttributeView(path2, AclFileAttributeView.class, new LinkOption[0]);
        if (aclFileAttributeView == null) {
            return;
        }
        AclFileAttributeView view = aclFileAttributeView;
        Object[] objectArray = new String[]{"SYSTEM", "Administrators"};
        List approvedOwners = CollectionsKt.listOf((Object[])objectArray);
        Collection $this$toTypedArray$iv = (Collection)EntriesMappings.entries$0;
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object object = thisCollection$iv.toArray(new AclEntryPermission[0]);
        AclEntry ownerOnlyFullControl = AclEntry.newBuilder().setPrincipal(Files.getOwner(path2, new LinkOption[0])).setType(AclEntryType.ALLOW).setPermissions(Arrays.copyOf(object, ((AclEntryPermission[])object).length)).build();
        Logger.INSTANCE.debug("Clearing ACL for " + ((Object)path2.toAbsolutePath()).toString());
        String string = ((Object)path2.toAbsolutePath()).toString();
        List<AclEntry> list2 = view.getAcl();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAcl(...)");
        Logger.INSTANCE.debug("'" + string + "' ACL before:" + CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, null, (int)63, null));
        List<AclEntry> list3 = view.getAcl();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getAcl(...)");
        object = list3;
        AclFileAttributeView aclFileAttributeView2 = view;
        boolean $i$f$filter = false;
        void $i$f$toTypedArray22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block5: {
                AclEntry entry = (AclEntry)element$iv$iv;
                boolean bl2 = false;
                UserPrincipal principalName = entry.principal();
                Iterable $this$any$iv = approvedOwners;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        String string2 = principalName.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        aclFileAttributeView2.setAcl(CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)ownerOnlyFullControl));
        String string3 = ((Object)path2.toAbsolutePath()).toString();
        List<AclEntry> list4 = view.getAcl();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"getAcl(...)");
        Logger.INSTANCE.debug("'" + string3 + "' ACL after:=" + CollectionsKt.joinToString$default((Iterable)list4, null, null, null, (int)0, null, null, (int)63, null));
    }

    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<AclEntryPermission> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])AclEntryPermission.values());
        }
    }
}

