/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh.openssh;

import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.api.remoteDev.ssh.SshConnectionInfo;
import com.jetbrains.toolbox.api.remoteDev.ssh.validation.SshValidationFailure;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.error.ConnectionError;
import com.jetbrains.toolbox.gateway.ssh.SshAuthenticationManager;
import com.jetbrains.toolbox.gateway.ssh.SshConnection;
import com.jetbrains.toolbox.gateway.ssh.SshOutputDumpImpl;
import com.jetbrains.toolbox.gateway.ssh.SshProcess;
import com.jetbrains.toolbox.gateway.ssh.SshProcessExtKt;
import com.jetbrains.toolbox.gateway.ssh.openssh.OpenSshConnection;
import com.jetbrains.toolbox.gateway.ssh.openssh.SshConnectionInfoPreprocessor;
import com.jetbrains.toolbox.manager.DialogManager;
import com.jetbrains.toolbox.openssh.AfterSshAddListener;
import com.jetbrains.toolbox.openssh.AfterSshListener;
import com.jetbrains.toolbox.openssh.OpenSsh;
import com.jetbrains.toolbox.openssh.OpenSshCommand;
import com.jetbrains.toolbox.openssh.OpenSshFactory;
import com.jetbrains.toolbox.openssh.OpenSshProcess;
import com.jetbrains.toolbox.openssh.SshAddContext;
import com.jetbrains.toolbox.openssh.SshAddResult;
import com.jetbrains.toolbox.openssh.SshContext;
import com.jetbrains.toolbox.openssh.SshError;
import com.jetbrains.toolbox.openssh.SshEvent;
import com.jetbrains.toolbox.openssh.SshException;
import com.jetbrains.toolbox.opensshAskpass.AskpassService;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.ExceptionsKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nOpenSshConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSshConnection.kt\ncom/jetbrains/toolbox/gateway/ssh/openssh/OpenSshConnection\n+ 2 FileSystem.kt\nokio/FileSystem\n+ 3 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,316:1\n80#2:317\n165#2:318\n81#2:319\n82#2:324\n67#2:354\n68#2:359\n52#3,4:320\n60#3,10:325\n56#3,18:335\n66#3:353\n52#3,4:355\n60#3,10:360\n56#3,3:370\n71#3,3:373\n*S KotlinDebug\n*F\n+ 1 OpenSshConnection.kt\ncom/jetbrains/toolbox/gateway/ssh/openssh/OpenSshConnection\n*L\n227#1:317\n227#1:318\n227#1:319\n227#1:324\n232#1:354\n232#1:359\n227#1:320,4\n227#1:325,10\n227#1:335,18\n232#1:353\n232#1:355,4\n232#1:360,10\n232#1:370,3\n232#1:373,3\n*E\n"})
public final class OpenSshConnection
implements SshConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DevEnvironmentId devEnvironmentId;
    @NotNull
    private final StateFlow<String> sshExecutable;
    @NotNull
    private final SshConnectionInfo sshConnectionInfo;
    @NotNull
    private final AskpassService askpassService;
    @NotNull
    private final SshAuthenticationManager authenticationManager;
    @NotNull
    private final SshConnectionInfoPreprocessor preprocessor;
    @NotNull
    private final OpenSshFactory openSshFactory;
    @NotNull
    private final FileSystem fileSystem;
    @Nullable
    private final SshOutputDumpImpl sshOutputDump;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final sshAddListener.1 sshAddListener;
    @NotNull
    private final sshListener.1 sshListener;
    @NotNull
    private final Map<String, String> environment;
    @NotNull
    private final MutableStateFlow<Pair<String, OpenSsh>> runner;
    @NotNull
    private static final String LOG_FILE_KEY = "TB_ASKPASS_LOG";
    private static final long VALIDATION_TIMEOUT = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);

    public OpenSshConnection(@NotNull DevEnvironmentId devEnvironmentId, @NotNull StateFlow<String> sshExecutable, @NotNull SshConnectionInfo sshConnectionInfo, @NotNull AskpassService askpassService, @NotNull SshAuthenticationManager authenticationManager, @NotNull SshConnectionInfoPreprocessor preprocessor, @NotNull OpenSshFactory openSshFactory, @NotNull DialogManager dialogManager, @NotNull FileSystem fileSystem, @Nullable SshOutputDumpImpl sshOutputDump, @NotNull CoroutineScope scope2) {
        Intrinsics.checkNotNullParameter((Object)devEnvironmentId, (String)"devEnvironmentId");
        Intrinsics.checkNotNullParameter(sshExecutable, (String)"sshExecutable");
        Intrinsics.checkNotNullParameter((Object)sshConnectionInfo, (String)"sshConnectionInfo");
        Intrinsics.checkNotNullParameter((Object)askpassService, (String)"askpassService");
        Intrinsics.checkNotNullParameter((Object)authenticationManager, (String)"authenticationManager");
        Intrinsics.checkNotNullParameter((Object)preprocessor, (String)"preprocessor");
        Intrinsics.checkNotNullParameter((Object)openSshFactory, (String)"openSshFactory");
        Intrinsics.checkNotNullParameter((Object)dialogManager, (String)"dialogManager");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.devEnvironmentId = devEnvironmentId;
        this.sshExecutable = sshExecutable;
        this.sshConnectionInfo = sshConnectionInfo;
        this.askpassService = askpassService;
        this.authenticationManager = authenticationManager;
        this.preprocessor = preprocessor;
        this.openSshFactory = openSshFactory;
        this.fileSystem = fileSystem;
        this.sshOutputDump = sshOutputDump;
        this.scope = scope2;
        this.sshAddListener = new AfterSshAddListener(this, dialogManager){
            final /* synthetic */ OpenSshConnection this$0;
            final /* synthetic */ DialogManager $dialogManager;
            {
                this.this$0 = $receiver;
                this.$dialogManager = $dialogManager;
            }

            /*
             * Unable to fully structure code
             */
            public Object beforeSshAdd(SshAddContext context, Continuation<? super Unit> $completion) {
                if (!($completion instanceof sshAddListener.beforeSshAdd.1)) ** GOTO lbl-1000
                var8_3 = $completion;
                if ((var8_3.label & -2147483648) != 0) {
                    var8_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        /* synthetic */ Object result;
                        final /* synthetic */ sshAddListener.1 this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.beforeSshAdd(null, (Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (OpenSshConnection.access$customAskpass(this.this$0)) ** GOTO lbl43
                        $continuation.L$0 = context;
                        $continuation.label = 1;
                        v0 = OpenSshConnection.access$getAuthenticationManager$p(this.this$0).createSession(context.getId(), OpenSshConnection.access$getDevEnvironmentId$p(this.this$0), OpenSshConnection.access$getSshConnectionInfo$p(this.this$0).getShouldAskForPassword(), (Continuation<? super Unit>)$continuation);
                        if (v0 == var9_5) {
                            return var9_5;
                        }
                        ** GOTO lbl23
                    }
                    case 1: {
                        context = (SshAddContext)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl23:
                        // 2 sources

                        logFile = OpenSshConnection.access$createAskpassLogFile(this.this$0, OpenSshConnection.access$getDevEnvironmentId$p(this.this$0), context.getId());
                        $continuation.L$0 = context;
                        $continuation.L$1 = logFile;
                        $continuation.label = 2;
                        v1 = this.$dialogManager.showSshAgentAdditionConfirmationDialog(context.getKeyPath(), (Continuation<? super Boolean>)$continuation);
                        if (v1 == var9_5) {
                            return var9_5;
                        }
                        ** GOTO lbl36
                    }
                    case 2: {
                        logFile = (Path)$continuation.L$1;
                        context = (SshAddContext)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl36:
                        // 2 sources

                        if (!(userDecision = ((Boolean)v1).booleanValue())) {
                            context.cancel();
                        } else {
                            var5_8 = context.getEnvironment();
                            var6_9 = TuplesKt.to((Object)"TB_ASKPASS_LOG", (Object)logFile.toString());
                            var5_8.put((String)var6_9.getFirst(), (String)var6_9.getSecond());
                        }
lbl43:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            /*
             * Unable to fully structure code
             */
            public Object afterSshAdd(SshAddContext context, SshAddResult result, Continuation<? super Unit> $completion) {
                block12: {
                    if (!($completion instanceof sshAddListener.afterSshAdd.1)) ** GOTO lbl-1000
                    var6_4 = $completion;
                    if ((var6_4.label & -2147483648) != 0) {
                        var6_4.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, $completion){
                            Object L$0;
                            Object L$1;
                            /* synthetic */ Object result;
                            final /* synthetic */ sshAddListener.1 this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return this.this$0.afterSshAdd(null, null, (Continuation<? super Unit>)((Continuation)this));
                            }
                        };
                    }
                    $result = $continuation.result;
                    var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (!OpenSshConnection.access$customAskpass(this.this$0)) {
                                $continuation.L$0 = context;
                                $continuation.L$1 = result;
                                $continuation.label = 1;
                                v0 = OpenSshConnection.access$getAuthenticationManager$p(this.this$0).closeSession(context.getId(), (Continuation<? super Unit>)$continuation);
                                if (v0 == var7_6) {
                                    return var7_6;
                                }
                            }
                            ** GOTO lbl25
                        }
                        case 1: {
                            result = (SshAddResult)$continuation.L$1;
                            context = (SshAddContext)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl25:
                            // 2 sources

                            if (Intrinsics.areEqual((Object)(var4_7 = result), (Object)SshAddResult.Success.INSTANCE)) break block12;
                            if (!(var4_7 instanceof SshAddResult.Failure)) break;
                            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)result);
                            $continuation.label = 2;
                            v1 = this.$dialogManager.showSshAddFailureDialog(context.getKeyPath(), ((SshAddResult.Failure)result).getErrorMessage(), (Continuation<? super Unit>)$continuation);
                            if (v1 == var7_6) {
                                return var7_6;
                            }
                            ** GOTO lbl39
                        }
                        case 2: {
                            result = (SshAddResult)$continuation.L$1;
                            context = (SshAddContext)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl39:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    if (Intrinsics.areEqual((Object)var4_7, (Object)SshAddResult.CancelledByUser.INSTANCE)) {
                        Logger.INSTANCE.info("The addition of SSH key: '" + context.getKeyPath() + "' was cancelled by the user");
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public Object onAskpassRequest(SshAddContext context2, Continuation<? super Unit> $completion) {
                Object object = OpenSshConnection.access$getAuthenticationManager$p(this.this$0).reportAskpassRequest(context2.getId(), $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        };
        this.sshListener = new AfterSshListener(this){
            private final Mutex mutex;
            private final MutableStateFlow<Map<String, Path>> logFiles;
            final /* synthetic */ OpenSshConnection this$0;
            {
                this.this$0 = $receiver;
                this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
                this.logFiles = StateFlowKt.MutableStateFlow((Object)MapsKt.emptyMap());
            }

            public final Mutex getMutex() {
                return this.mutex;
            }

            public final MutableStateFlow<Map<String, Path>> getLogFiles() {
                return this.logFiles;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public Object beforeSsh(SshContext context, Continuation<? super Unit> $completion) {
                if (!($completion instanceof sshListener.beforeSsh.1)) ** GOTO lbl-1000
                var12_3 = $completion;
                if ((var12_3.label & -2147483648) != 0) {
                    var12_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ sshListener.1 this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.beforeSsh(null, (Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (OpenSshConnection.access$customAskpass(this.this$0)) ** GOTO lbl47
                        logFile = OpenSshConnection.access$createAskpassLogFile(this.this$0, OpenSshConnection.access$getDevEnvironmentId$p(this.this$0), context.getId());
                        var4_7 = context.getEnvironment();
                        var4_7.putAll(MapsKt.mapOf((Pair)TuplesKt.to((Object)"TB_ASKPASS_LOG", (Object)logFile.toString())));
                        $this$withLock_u24default$iv = this.mutex;
                        owner$iv = null;
                        $i$f$withLock = 0;
                        $continuation.L$0 = context;
                        $continuation.L$1 = logFile;
                        $continuation.L$2 = $this$withLock_u24default$iv;
                        $continuation.I$0 = $i$f$withLock;
                        $continuation.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                        if (v0 == var13_5) {
                            return var13_5;
                        }
                        ** GOTO lbl36
                    }
                    case 1: {
                        $i$f$withLock = $continuation.I$0;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                        logFile = (Path)$continuation.L$1;
                        context = (SshContext)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl36:
                        // 2 sources

                        try {
                            $i$a$-withLock$default-OpenSshConnection$sshListener$1$beforeSsh$2 = false;
                            var8_12 = this.logFiles;
                            var8_12.setValue((Object)MapsKt.plus((Map)((Map)var8_12.getValue()), (Pair)TuplesKt.to((Object)context.getId(), (Object)logFile)));
                            var9_13 = Unit.INSTANCE;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
lbl47:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            /*
             * Unable to fully structure code
             */
            public Object afterSsh(SshContext context, Continuation<? super Unit> $completion) {
                if (!($completion instanceof sshListener.afterSsh.1)) ** GOTO lbl-1000
                var5_3 = $completion;
                if ((var5_3.label & -2147483648) != 0) {
                    var5_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        /* synthetic */ Object result;
                        final /* synthetic */ sshListener.1 this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.afterSsh(null, (Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (OpenSshConnection.access$customAskpass(this.this$0)) ** GOTO lbl27
                        logFile = (Path)MapsKt.getValue((Map)((Map)this.logFiles.getValue()), (Object)context.getId());
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)context);
                        $continuation.L$1 = logFile;
                        $continuation.label = 1;
                        v0 = OpenSshConnection.access$getAuthenticationManager$p(this.this$0).closeSession(context.getId(), (Continuation<? super Unit>)$continuation);
                        if (v0 == var6_5) {
                            return var6_5;
                        }
                        ** GOTO lbl26
                    }
                    case 1: {
                        logFile = (Path)$continuation.L$1;
                        context = (SshContext)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl26:
                        // 2 sources

                        OpenSshConnection.access$readLogFile(this.this$0, logFile);
lbl27:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
        };
        this.environment = this.customAskpass() ? MapsKt.emptyMap() : this.askpassService.getEnvironment();
        this.runner = StateFlowKt.MutableStateFlow(null);
    }

    private final OpenSsh createRunner(String executable) {
        return this.openSshFactory.create(executable, this.preprocessor.preprocess(this.devEnvironmentId.getEnvironmentId(), this.sshConnectionInfo, this.askpassService.getAskpassExecutablePath(), this.environment), CollectionsKt.listOf((Object)this.sshListener), CollectionsKt.listOf((Object)this.sshListener), CollectionsKt.listOf((Object)this.sshAddListener), CollectionsKt.listOf((Object)this.sshAddListener), CollectionsKt.listOf((Object)this.sshAddListener));
    }

    private final boolean customAskpass() {
        return this.sshConnectionInfo.getAskpassExecutable() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Path createAskpassLogFile(DevEnvironmentId devEnvironmentId, String sessionUuid) {
        Unit unit;
        Throwable thrown$iv$iv;
        Path fileName;
        block14: {
            void $this$iv;
            Path askpassLogDir = StandardPaths.INSTANCE.getToolboxCacheLocation().resolve("askpass_log");
            String askpassLogName = "askpass_log_" + devEnvironmentId.getProviderId-rwbms5E() + "_" + sessionUuid + "}";
            fileName = askpassLogDir.resolve(askpassLogName);
            this.fileSystem.createDirectories(askpassLogDir);
            FileSystem fileSystem = this.fileSystem;
            Path file$iv = fileName;
            boolean mustCreate$iv = false;
            boolean bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSink $this$createAskpassLogFile_u24lambda_u240 = it$iv;
                boolean bl3 = false;
                unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    unit = null;
                    break block14;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block15: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv2;
                                break block15;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        Unit result$iv$iv = unit;
        Throwable throwable = thrown$iv$iv;
        if (throwable == null) return fileName;
        throw throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readLogFile(Path logFile) {
        String string;
        Throwable thrown$iv$iv;
        block16: {
            void this_$iv;
            FileSystem fileSystem = this.fileSystem;
            Path file$iv = logFile;
            boolean bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSource $this$readLogFile_u24lambda_u240 = it$iv;
                boolean bl3 = false;
                string = $this$readLogFile_u24lambda_u240.readString(Charsets.UTF_8);
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    string = null;
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block17: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv2;
                                break block17;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        String result$iv$iv = string;
        Throwable throwable = thrown$iv$iv;
        if (throwable != null) {
            throw throwable;
        }
        String askpassLog = result$iv$iv;
        if (((CharSequence)askpassLog).length() > 0) {
            Logger.INSTANCE.debug("Askpass log:\n" + askpassLog);
        }
        this.fileSystem.delete(logFile, false);
    }

    private final Object executeWithLogAndAuthentication(OpenSshCommand command2, Continuation<? super InternalSshProcess> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super InternalSshProcess>, Object>(this, command2, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            final /* synthetic */ OpenSshConnection this$0;
            final /* synthetic */ OpenSshCommand $command;
            {
                this.this$0 = $receiver;
                this.$command = $command;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = (String)OpenSshConnection.access$getSshExecutable$p(this.this$0).getValue();
                        if (v0 == null) {
                            throw ConnectionError.SshExecutableMissing.INSTANCE;
                        }
                        currentExecutable = v0;
                        var6_5 = OpenSshConnection.access$getRunner$p(this.this$0);
                        var7_8 = this.this$0;
                        $i$f$updateAndGet = false;
                        do {
                            prevValue$iv = $this$updateAndGet$iv.getValue();
                            it = (Pair)prevValue$iv;
                            $i$a$-updateAndGet-OpenSshConnection$executeWithLogAndAuthentication$2$currentRunner$1 = false;
                            if (it == null) {
                                v1 = TuplesKt.to((Object)currentExecutable, (Object)OpenSshConnection.access$createRunner(var7_8, currentExecutable));
                                continue;
                            }
                            if (Intrinsics.areEqual((Object)it.getFirst(), (Object)currentExecutable)) {
                                v1 = it;
                                continue;
                            }
                            v1 = TuplesKt.to((Object)currentExecutable, (Object)OpenSshConnection.access$createRunner(var7_8, currentExecutable));
                        } while (!$this$updateAndGet$iv.compareAndSet(prevValue$iv, nextValue$iv = v1));
                        var5_17 = nextValue$iv;
                        var4_18 = var5_17 != null ? (OpenSsh)var5_17.getSecond() : null;
                        Intrinsics.checkNotNull((Object)var4_18, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.openssh.OpenSsh");
                        currentRunner = var4_18;
                        this.L$0 = currentExecutable;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)currentRunner);
                        this.label = 1;
                        v2 = currentRunner.createProcess(this.$command, (Continuation<? super OpenSshProcess>)((Continuation)this));
                        ** if (v2 != var17_2) goto lbl38
lbl37:
                        // 1 sources

                        return var17_2;
lbl38:
                        // 1 sources

                        ** GOTO lbl46
                    }
                    case 1: {
                        currentRunner = (OpenSsh)this.L$1;
                        currentExecutable = (String)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl46:
                            // 2 sources

                            var5_17 = v2;
                            $this$updateAndGet$iv = this.this$0;
                            it = (OpenSshProcess)var5_17;
                            $i$a$-also-OpenSshConnection$executeWithLogAndAuthentication$2$openSshProcess$1 = false;
                            v3 = OpenSshConnection.access$getSshOutputDump$p($this$updateAndGet$iv);
                            if (v3 != null) {
                                v3.dumpOutput(OpenSshConnection.access$getDevEnvironmentId$p($this$updateAndGet$iv), it);
                            }
                            var5_17 = (OpenSshProcess)var5_17;
                            ** GOTO lbl86
                        }
                        catch (SshException e) {
                            it = OpenSshConnection.access$getRunner$p(this.this$0);
                            var11_14 = this.this$0;
                            $i$f$updateAndGet = false;
                            do {
                                prevValue$iv = $this$updateAndGet$iv.getValue();
                                it = (Pair)prevValue$iv;
                                $i$a$-updateAndGet-OpenSshConnection$executeWithLogAndAuthentication$2$openSshProcess$newRunner$1 = false;
                            } while (!$this$updateAndGet$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = TuplesKt.to((Object)currentExecutable, (Object)OpenSshConnection.access$createRunner(var11_14, currentExecutable)))));
                            v4 = nextValue$iv;
                            v5 = v4 != null ? (OpenSsh)v4.getSecond() : null;
                            Intrinsics.checkNotNull((Object)v5, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.openssh.OpenSsh");
                            newRunner = v5;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)currentExecutable);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)currentRunner);
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)e);
                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)newRunner);
                            this.label = 2;
                            v6 = newRunner.createProcess(this.$command, (Continuation<? super OpenSshProcess>)((Continuation)this));
                            if (v6 == var17_2) {
                                return var17_2;
                            }
                            ** GOTO lbl85
                        }
                    }
                    case 2: {
                        newRunner = (OpenSsh)this.L$3;
                        e = (SshException)this.L$2;
                        currentRunner = (OpenSsh)this.L$1;
                        currentExecutable = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl85:
                        // 2 sources

                        var5_17 = (OpenSshProcess)v6;
lbl86:
                        // 2 sources

                        openSshProcess = var5_17;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)currentExecutable);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)currentRunner);
                        this.L$2 = openSshProcess;
                        this.L$3 = null;
                        this.label = 3;
                        v7 = openSshProcess.start((Continuation<? super Unit>)((Continuation)this));
                        if (v7 == var17_2) {
                            return var17_2;
                        }
                        ** GOTO lbl102
                    }
                    case 3: {
                        openSshProcess = (OpenSshProcess)this.L$2;
                        currentRunner = (OpenSsh)this.L$1;
                        currentExecutable = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl102:
                        // 2 sources

                        return this.this$0.new InternalSshProcess((OpenSshProcess)openSshProcess);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super InternalSshProcess> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object executeCommand(@NotNull String[] command2, boolean redirectStderrToStdout, boolean allocateDynamicProxy, boolean allocatePty, @NotNull Continuation<? super SshProcess> $completion) {
        OpenSshCommand.Execute openSshCommand = new OpenSshCommand.Execute(ArraysKt.toList((Object[])command2), allocatePty, allocateDynamicProxy, redirectStderrToStdout);
        return this.executeWithLogAndAuthentication(openSshCommand, $completion);
    }

    @Override
    @Nullable
    public Object validate(@NotNull Continuation<? super List<? extends SshValidationFailure>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends SshValidationFailure>>, Object>(this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ OpenSshConnection this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block23: {
                    var2_2 = (CoroutineScope)this.L$0;
                    var10_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.L$0 = $this$withContext;
                            this.label = 1;
                            v0 = OpenSshConnection.access$executeWithLogAndAuthentication(this.this$0, new OpenSshCommand.Execute(CollectionsKt.listOf((Object)"exit"), true, false, false), (Continuation)this);
                            ** if (v0 != var10_3) goto lbl13
lbl12:
                            // 1 sources

                            return var10_3;
lbl13:
                            // 1 sources

                            ** GOTO lbl19
                        }
                        case 1: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl19:
                                // 2 sources

                                var4_4 = (InternalSshProcess)v0;
                            }
                            catch (SshException e) {
                                throw ConnectionError.Companion.fromSshException(e);
                            }
                            internalProcess = var4_4;
                            stdoutDeferred = BuildersKt.async$default((CoroutineScope)$this$withContext, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(internalProcess, null){
                                int label;
                                final /* synthetic */ InternalSshProcess $internalProcess;
                                {
                                    this.$internalProcess = $internalProcess;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            v0 = this.$internalProcess.getOutput((Continuation<? super Flow<String>>)((Continuation)this));
                                            if (v0 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl13
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl13:
                                            // 2 sources

                                            this.label = 2;
                                            v1 = FlowKt.toList$default((Flow)((Flow)v0), null, (Continuation)((Continuation)this), (int)1, null);
                                            if (v1 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl21
                                        }
                                        case 2: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl21:
                                            // 2 sources

                                            return CollectionsKt.joinToString$default((Iterable)((Iterable)v1), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                            stderrDeferred = BuildersKt.async$default((CoroutineScope)$this$withContext, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(internalProcess, null){
                                int label;
                                final /* synthetic */ InternalSshProcess $internalProcess;
                                {
                                    this.$internalProcess = $internalProcess;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            v0 = this.$internalProcess.getErrorOutput((Continuation<? super Flow<String>>)((Continuation)this));
                                            if (v0 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl13
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl13:
                                            // 2 sources

                                            this.label = 2;
                                            v1 = FlowKt.toList$default((Flow)((Flow)v0), null, (Continuation)((Continuation)this), (int)1, null);
                                            if (v1 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl21
                                        }
                                        case 2: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl21:
                                            // 2 sources

                                            return CollectionsKt.joinToString$default((Iterable)((Iterable)v1), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                            this.L$1 = internalProcess;
                            this.L$2 = stdoutDeferred;
                            this.L$3 = stderrDeferred;
                            this.label = 2;
                            v1 = SshProcessExtKt.awaitOrKill-8Mi8wO0(internalProcess, OpenSshConnection.access$getVALIDATION_TIMEOUT$cp(), (Continuation<? super Integer>)((Continuation)this));
                            if (v1 == var10_3) {
                                return var10_3;
                            }
                            ** GOTO lbl41
                        }
                        case 2: {
                            stderrDeferred = (Deferred)this.L$3;
                            stdoutDeferred = (Deferred)this.L$2;
                            internalProcess = (InternalSshProcess)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl41:
                            // 2 sources

                            if ((exitCode = (Integer)v1) != null) break;
                            Logger.INSTANCE.warn("Connection validation failed. Connection timeout");
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)internalProcess);
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)stdoutDeferred);
                            this.L$3 = stderrDeferred;
                            this.L$4 = SpillingKt.nullOutSpilledVariable((Object)exitCode);
                            this.label = 3;
                            v2 = stdoutDeferred.await((Continuation)this);
                            if (v2 == var10_3) {
                                return var10_3;
                            }
                            ** GOTO lbl60
                        }
                        case 3: {
                            exitCode = (Integer)this.L$4;
                            stderrDeferred = (Deferred)this.L$3;
                            stdoutDeferred = (Deferred)this.L$2;
                            internalProcess = (InternalSshProcess)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl60:
                            // 2 sources

                            stdout = (String)v2;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)internalProcess);
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)stdoutDeferred);
                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)stderrDeferred);
                            this.L$4 = SpillingKt.nullOutSpilledVariable((Object)exitCode);
                            this.L$5 = stdout;
                            this.label = 4;
                            v3 = stderrDeferred.await((Continuation)this);
                            if (v3 == var10_3) {
                                return var10_3;
                            }
                            ** GOTO lbl80
                        }
                        case 4: {
                            stdout = (String)this.L$5;
                            exitCode = (Integer)this.L$4;
                            stderrDeferred = (Deferred)this.L$3;
                            stdoutDeferred = (Deferred)this.L$2;
                            internalProcess = (InternalSshProcess)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl80:
                            // 2 sources

                            stderr = (String)v3;
                            Logger.INSTANCE.warn("Connection validation failed.\nConnection timeout\nStdout: " + stdout + "\nStderr: " + stderr);
                            return CollectionsKt.listOf((Object)SshValidationFailure.SimpleValidationFailures.CONNECTION_TIMEOUT);
                        }
                    }
                    failures = (Set)internalProcess.getSshFailures().getValue();
                    if (!(((Collection)failures).isEmpty() == false)) break block23;
                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)internalProcess);
                    this.L$2 = SpillingKt.nullOutSpilledVariable((Object)stdoutDeferred);
                    this.L$3 = stderrDeferred;
                    this.L$4 = SpillingKt.nullOutSpilledVariable((Object)exitCode);
                    this.L$5 = failures;
                    this.label = 5;
                    v4 = stdoutDeferred.await((Continuation)this);
                    if (v4 == var10_3) {
                        return var10_3;
                    }
                    ** GOTO lbl104
                    {
                        case 5: {
                            failures = (Set)this.L$5;
                            exitCode = (Integer)this.L$4;
                            stderrDeferred = (Deferred)this.L$3;
                            stdoutDeferred = (Deferred)this.L$2;
                            internalProcess = (InternalSshProcess)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl104:
                            // 2 sources

                            stdout = (String)v4;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)internalProcess);
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)stdoutDeferred);
                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)stderrDeferred);
                            this.L$4 = SpillingKt.nullOutSpilledVariable((Object)exitCode);
                            this.L$5 = failures;
                            this.L$6 = stdout;
                            this.label = 6;
                            v5 = stderrDeferred.await((Continuation)this);
                            if (v5 == var10_3) {
                                return var10_3;
                            }
                            ** GOTO lbl126
                        }
                        case 6: {
                            stdout = (String)this.L$6;
                            failures = (Set)this.L$5;
                            exitCode = (Integer)this.L$4;
                            stderrDeferred = (Deferred)this.L$3;
                            stdoutDeferred = (Deferred)this.L$2;
                            internalProcess = (InternalSshProcess)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl126:
                            // 2 sources

                            stderr = (String)v5;
                            Logger.INSTANCE.warn("Connection validation failed.\nStdout: " + stdout + "\nStderr: " + stderr);
                            return CollectionsKt.toList((Iterable)failures);
                        }
                    }
                }
                if (exitCode == 0) {
                    return CollectionsKt.emptyList();
                }
                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)internalProcess);
                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)stdoutDeferred);
                this.L$3 = stderrDeferred;
                this.L$4 = exitCode;
                this.L$5 = SpillingKt.nullOutSpilledVariable((Object)failures);
                this.label = 7;
                v6 = stdoutDeferred.await((Continuation)this);
                if (v6 == var10_3) {
                    return var10_3;
                }
                ** GOTO lbl151
                {
                    case 7: {
                        failures = (Set)this.L$5;
                        exitCode = (Integer)this.L$4;
                        stderrDeferred = (Deferred)this.L$3;
                        stdoutDeferred = (Deferred)this.L$2;
                        internalProcess = (InternalSshProcess)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl151:
                        // 2 sources

                        stdout = (String)v6;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)internalProcess);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)stdoutDeferred);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)stderrDeferred);
                        this.L$4 = exitCode;
                        this.L$5 = SpillingKt.nullOutSpilledVariable((Object)failures);
                        this.L$6 = stdout;
                        this.label = 8;
                        v7 = stderrDeferred.await((Continuation)this);
                        if (v7 == var10_3) {
                            return var10_3;
                        }
                        ** GOTO lbl173
                    }
                    case 8: {
                        stdout = (String)this.L$6;
                        failures = (Set)this.L$5;
                        exitCode = (Integer)this.L$4;
                        stderrDeferred = (Deferred)this.L$3;
                        stdoutDeferred = (Deferred)this.L$2;
                        internalProcess = (InternalSshProcess)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl173:
                        // 2 sources

                        stderr = (String)v7;
                        Logger.INSTANCE.warn("Connection validation failed.\nExit code: " + exitCode + "\nStdout: " + stdout + "\nStderr: " + stderr);
                        return CollectionsKt.listOf((Object)new SshValidationFailure.NonZeroExitCode(exitCode.intValue()));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends SshValidationFailure>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final /* synthetic */ boolean access$customAskpass(OpenSshConnection $this) {
        return $this.customAskpass();
    }

    public static final /* synthetic */ DevEnvironmentId access$getDevEnvironmentId$p(OpenSshConnection $this) {
        return $this.devEnvironmentId;
    }

    public static final /* synthetic */ SshAuthenticationManager access$getAuthenticationManager$p(OpenSshConnection $this) {
        return $this.authenticationManager;
    }

    public static final /* synthetic */ SshConnectionInfo access$getSshConnectionInfo$p(OpenSshConnection $this) {
        return $this.sshConnectionInfo;
    }

    public static final /* synthetic */ Object access$executeWithLogAndAuthentication(OpenSshConnection $this, OpenSshCommand command2, Continuation $completion) {
        return $this.executeWithLogAndAuthentication(command2, (Continuation<? super InternalSshProcess>)$completion);
    }

    public static final /* synthetic */ StateFlow access$getSshExecutable$p(OpenSshConnection $this) {
        return $this.sshExecutable;
    }

    public static final /* synthetic */ MutableStateFlow access$getRunner$p(OpenSshConnection $this) {
        return $this.runner;
    }

    public static final /* synthetic */ OpenSsh access$createRunner(OpenSshConnection $this, String executable) {
        return $this.createRunner(executable);
    }

    public static final /* synthetic */ SshOutputDumpImpl access$getSshOutputDump$p(OpenSshConnection $this) {
        return $this.sshOutputDump;
    }

    public static final /* synthetic */ long access$getVALIDATION_TIMEOUT$cp() {
        return VALIDATION_TIMEOUT;
    }

    public static final /* synthetic */ Path access$createAskpassLogFile(OpenSshConnection $this, DevEnvironmentId devEnvironmentId, String sessionUuid) {
        return $this.createAskpassLogFile(devEnvironmentId, sessionUuid);
    }

    public static final /* synthetic */ void access$readLogFile(OpenSshConnection $this, Path logFile) {
        $this.readLogFile(logFile);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @SourceDebugExtension(value={"SMAP\nOpenSshConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSshConnection.kt\ncom/jetbrains/toolbox/gateway/ssh/openssh/OpenSshConnection$InternalSshProcess\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,316:1\n1#2:317\n*E\n"})
    public final class InternalSshProcess
    implements SshProcess {
        @NotNull
        private final OpenSshProcess openSshProcess;
        @NotNull
        private final MutableStateFlow<ConcurrentHashMap.KeySetView<SshValidationFailure, Boolean>> sshErrors;
        @NotNull
        private final Job eventReadingJob;

        public InternalSshProcess(OpenSshProcess openSshProcess) {
            Intrinsics.checkNotNullParameter((Object)openSshProcess, (String)"openSshProcess");
            this.openSshProcess = openSshProcess;
            this.sshErrors = StateFlowKt.MutableStateFlow(ConcurrentHashMap.newKeySet());
            this.eventReadingJob = BuildersKt.launch$default((CoroutineScope)OpenSshConnection.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, OpenSshConnection.this, null){
                int label;
                final /* synthetic */ InternalSshProcess this$0;
                final /* synthetic */ OpenSshConnection this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = InternalSshProcess.access$getOpenSshProcess$p(this.this$0).getEvents().collect(new FlowCollector(this.this$1, this.this$0){
                                final /* synthetic */ OpenSshConnection this$0;
                                final /* synthetic */ InternalSshProcess this$1;
                                {
                                    this.this$0 = $receiver;
                                    this.this$1 = $receiver2;
                                }

                                public final Object emit(SshEvent event, Continuation<? super Unit> $completion) {
                                    SshEvent sshEvent = event;
                                    if (Intrinsics.areEqual((Object)sshEvent, (Object)SshEvent.AuthenticationFailed.INSTANCE)) {
                                        if (OpenSshConnection.access$customAskpass(this.this$0)) {
                                            return Unit.INSTANCE;
                                        }
                                        Logger.INSTANCE.info("Authentication failed for connection: " + OpenSshConnection.access$getDevEnvironmentId$p(this.this$0) + ".");
                                        Object object = OpenSshConnection.access$getAuthenticationManager$p(this.this$0).reportError(InternalSshProcess.access$getOpenSshProcess$p(this.this$1).getId(), "Authentication failed", $completion);
                                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                            return object;
                                        }
                                        return Unit.INSTANCE;
                                    }
                                    if (sshEvent instanceof SshEvent.AuthenticationStarted) {
                                        if (OpenSshConnection.access$customAskpass(this.this$0)) {
                                            return Unit.INSTANCE;
                                        }
                                        Logger.INSTANCE.info("Authentication started for host: " + ((SshEvent.AuthenticationStarted)event).getHost() + " as user: " + ((SshEvent.AuthenticationStarted)event).getUser());
                                        Object object = OpenSshConnection.access$getAuthenticationManager$p(this.this$0).createSession(InternalSshProcess.access$getOpenSshProcess$p(this.this$1).getId(), OpenSshConnection.access$getDevEnvironmentId$p(this.this$0), OpenSshConnection.access$getSshConnectionInfo$p(this.this$0).getShouldAskForPassword(), $completion);
                                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                            return object;
                                        }
                                        return Unit.INSTANCE;
                                    }
                                    if (sshEvent instanceof SshEvent.AuthenticationMethodStarted) {
                                        if (OpenSshConnection.access$customAskpass(this.this$0)) {
                                            return Unit.INSTANCE;
                                        }
                                        Logger.INSTANCE.info("Authentication method started: " + ((SshEvent.AuthenticationMethodStarted)event).getMethod());
                                        Object object = OpenSshConnection.access$getAuthenticationManager$p(this.this$0).registerAuthMethod(InternalSshProcess.access$getOpenSshProcess$p(this.this$1).getId(), ((SshEvent.AuthenticationMethodStarted)event).getMethod(), $completion);
                                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                            return object;
                                        }
                                        return Unit.INSTANCE;
                                    }
                                    if (Intrinsics.areEqual((Object)sshEvent, (Object)SshEvent.AuthenticationFinished.INSTANCE)) {
                                        if (OpenSshConnection.access$customAskpass(this.this$0)) {
                                            return Unit.INSTANCE;
                                        }
                                        Logger.INSTANCE.info("Authentication succeeded for connection: " + OpenSshConnection.access$getDevEnvironmentId$p(this.this$0));
                                        Object object = OpenSshConnection.access$getAuthenticationManager$p(this.this$0).closeSession(InternalSshProcess.access$getOpenSshProcess$p(this.this$1).getId(), $completion);
                                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                            return object;
                                        }
                                        return Unit.INSTANCE;
                                    }
                                    if (Intrinsics.areEqual((Object)sshEvent, (Object)SshEvent.AskpassRequested.INSTANCE)) {
                                        if (OpenSshConnection.access$customAskpass(this.this$0)) {
                                            return Unit.INSTANCE;
                                        }
                                        Object object = OpenSshConnection.access$getAuthenticationManager$p(this.this$0).reportAskpassRequest(InternalSshProcess.access$getOpenSshProcess$p(this.this$1).getId(), $completion);
                                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                            return object;
                                        }
                                        return Unit.INSTANCE;
                                    }
                                    if (sshEvent instanceof SshError.HostKeyVerificationFailed) {
                                        Object object = InternalSshProcess.access$getSshErrors$p(this.this$1).getValue();
                                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
                                        Collection collection = (Collection)object;
                                        collection.add(new SshValidationFailure.HostKeyVerificationFailed(((SshError.HostKeyVerificationFailed)event).getHost()));
                                    } else if (Intrinsics.areEqual((Object)sshEvent, (Object)SshError.AuthenticationError.INSTANCE)) {
                                        Object object = InternalSshProcess.access$getSshErrors$p(this.this$1).getValue();
                                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
                                        Collection collection = (Collection)object;
                                        collection.add(SshValidationFailure.SimpleValidationFailures.WRONG_CREDENTIALS);
                                    } else if (Intrinsics.areEqual((Object)sshEvent, (Object)SshError.ConnectionRefused.INSTANCE)) {
                                        Object object = InternalSshProcess.access$getSshErrors$p(this.this$1).getValue();
                                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
                                        Collection collection = (Collection)object;
                                        collection.add(SshValidationFailure.SimpleValidationFailures.CONNECTION_REFUSED);
                                    } else if (Intrinsics.areEqual((Object)sshEvent, (Object)SshError.ConnectionTimeout.INSTANCE)) {
                                        Object object = InternalSshProcess.access$getSshErrors$p(this.this$1).getValue();
                                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
                                        Collection collection = (Collection)object;
                                        collection.add(SshValidationFailure.SimpleValidationFailures.CONNECTION_TIMEOUT);
                                    } else if (Intrinsics.areEqual((Object)sshEvent, (Object)SshError.HostUnreachable.INSTANCE)) {
                                        Object object = InternalSshProcess.access$getSshErrors$p(this.this$1).getValue();
                                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
                                        Collection collection = (Collection)object;
                                        collection.add(SshValidationFailure.SimpleValidationFailures.HOST_UNREACHABLE);
                                    } else if (Intrinsics.areEqual((Object)sshEvent, (Object)SshError.ForwardingProhibited.INSTANCE)) {
                                        Object object = InternalSshProcess.access$getSshErrors$p(this.this$1).getValue();
                                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
                                        Collection collection = (Collection)object;
                                        collection.add(SshValidationFailure.SimpleValidationFailures.FORWARDING_PROHIBITED);
                                    } else if (sshEvent instanceof SshError.InaccessibleFile) {
                                        Object object = InternalSshProcess.access$getSshErrors$p(this.this$1).getValue();
                                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
                                        Collection collection = (Collection)object;
                                        collection.add(new SshValidationFailure.InaccessibleFile(((SshError.InaccessibleFile)event).getType(), ((SshError.InaccessibleFile)event).getPath(), ((SshError.InaccessibleFile)event).getReason()));
                                    } else if (sshEvent instanceof SshError.TooWidePermissions) {
                                        Object object = InternalSshProcess.access$getSshErrors$p(this.this$1).getValue();
                                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
                                        Collection collection = (Collection)object;
                                        collection.add(new SshValidationFailure.TooWidePermissions(((SshError.TooWidePermissions)event).getKeyPath()));
                                    } else if (sshEvent instanceof SshError.UnknownError) {
                                        Object object = InternalSshProcess.access$getSshErrors$p(this.this$1).getValue();
                                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
                                        Collection collection = (Collection)object;
                                        collection.add(new SshValidationFailure.UnknownSshValidationFailure(((SshError.UnknownError)event).getExitCode(), ((SshError.UnknownError)event).getStdout(), ((SshError.UnknownError)event).getStderr()));
                                    } else if (sshEvent instanceof SshError.UnresolvedHostname) {
                                        Object object = InternalSshProcess.access$getSshErrors$p(this.this$1).getValue();
                                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
                                        Collection collection = (Collection)object;
                                        collection.add(new SshValidationFailure.UnresolvedHostname(((SshError.UnresolvedHostname)event).getHostname(), ((SshError.UnresolvedHostname)event).getReason()));
                                    } else if (sshEvent instanceof SshError.SshAgentConflict) {
                                        Object object = InternalSshProcess.access$getSshErrors$p(this.this$1).getValue();
                                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
                                        if (!((Collection)object).isEmpty()) {
                                            Object object2 = InternalSshProcess.access$getSshErrors$p(this.this$1).getValue();
                                            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"<get-value>(...)");
                                            Collection collection = (Collection)object2;
                                            collection.add(new SshValidationFailure.SshAgentConflict(((SshError.SshAgentConflict)event).getIdentityAgentPath(), ((SshError.SshAgentConflict)event).getSshAuthSock()));
                                        }
                                    } else {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @Override
        public boolean isAlive() {
            return !this.openSshProcess.isFinished();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object awaitFinished(@NotNull Continuation<? super Integer> $completion) {
            if (!($completion instanceof awaitFinished.1)) ** GOTO lbl-1000
            var6_2 = $completion;
            if ((var6_2.label & -2147483648) != 0) {
                var6_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ InternalSshProcess this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.awaitFinished((Continuation<? super Integer>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.label = 1;
                    v0 = this.openSshProcess.awaitFinished((Continuation<? super Integer>)$continuation);
                    if (v0 == var7_4) {
                        return var7_4;
                    }
                    ** GOTO lbl20
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl20:
                    // 2 sources

                    var2_5 = v0;
                    it = ((Number)var2_5).intValue();
                    $i$a$-also-OpenSshConnection$InternalSshProcess$awaitFinished$2 = 0;
                    $continuation.L$0 = var2_5;
                    $continuation.I$0 = it;
                    $continuation.I$1 = $i$a$-also-OpenSshConnection$InternalSshProcess$awaitFinished$2;
                    $continuation.label = 2;
                    v1 = this.eventReadingJob.join((Continuation)$continuation);
                    if (v1 == var7_4) {
                        return var7_4;
                    }
                    ** GOTO lbl37
                }
                case 2: {
                    $i$a$-also-OpenSshConnection$InternalSshProcess$awaitFinished$2 = $continuation.I$1;
                    it = $continuation.I$0;
                    var2_5 = $continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl37:
                    // 2 sources

                    return var2_5;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Override
        public void consumeInput(@NotNull InputStream input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            this.openSshProcess.consumeInput(input);
        }

        @Override
        public void consumeInput(@NotNull byte[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            this.openSshProcess.consumeInput(array);
        }

        @Override
        public void closeInput() {
            this.openSshProcess.closeInput();
        }

        @Override
        @Nullable
        public Object getOutput(@NotNull Continuation<? super Flow<String>> $completion) {
            return this.openSshProcess.getOutput($completion);
        }

        @Override
        @Nullable
        public Object getErrorOutput(@NotNull Continuation<? super Flow<String>> $completion) {
            return this.openSshProcess.getErrorOutput($completion);
        }

        @Override
        public void kill(boolean forcefully) {
            this.openSshProcess.close(forcefully);
        }

        @Override
        @Nullable
        public Integer getDynamicForwardingPort() {
            return this.openSshProcess.getDynamicForwardingPort();
        }

        @Override
        @NotNull
        public StateFlow<Set<SshValidationFailure>> getSshFailures() {
            return (StateFlow)this.sshErrors;
        }

        public static final /* synthetic */ OpenSshProcess access$getOpenSshProcess$p(InternalSshProcess $this) {
            return $this.openSshProcess;
        }

        public static final /* synthetic */ MutableStateFlow access$getSshErrors$p(InternalSshProcess $this) {
            return $this.sshErrors;
        }
    }
}

