/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.api.core.PluginSettingsStore;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;

public final class SshConfigPathProvider {
    @NotNull
    private final PluginSettingsStore pluginSettingsStore;
    @NotNull
    private final String defaultConfigPath;
    @NotNull
    private final MutableStateFlow<String> _currentConfigPath;
    @NotNull
    private final StateFlow<String> currentConfigPath;

    public SshConfigPathProvider(@NotNull PluginSettingsStore pluginSettingsStore, @NotNull CoroutineScope scope2) {
        Intrinsics.checkNotNullParameter((Object)pluginSettingsStore, (String)"pluginSettingsStore");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.pluginSettingsStore = pluginSettingsStore;
        String string = System.getProperty("user.home");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        this.defaultConfigPath = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null).resolve(".ssh").resolve("config").toString();
        this._currentConfigPath = StateFlowKt.MutableStateFlow((Object)this.getConfigPathFromStore());
        this.currentConfigPath = FlowKt.asStateFlow(this._currentConfigPath);
        BuildersKt.launch$default((CoroutineScope)scope2, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SshConfigPathProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0._currentConfigPath.collect(new FlowCollector(){

                            public final Object emit(String it, Continuation<? super Unit> $completion) {
                                if (!Intrinsics.areEqual((Object)it, (Object)this$0.defaultConfigPath)) {
                                    ((Map)this$0.pluginSettingsStore).put("configPath", it);
                                } else {
                                    ((Map)this$0.pluginSettingsStore).put("configPath", "");
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final StateFlow<String> getCurrentConfigPath() {
        return this.currentConfigPath;
    }

    private final String getConfigPathFromStore() {
        String path2 = (String)this.pluginSettingsStore.get((Object)"configPath");
        CharSequence charSequence = path2;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? path2 : this.defaultConfigPath;
    }

    public final void setConfigPath(@NotNull String configPath) {
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        this._currentConfigPath.setValue((Object)configPath);
    }
}

