/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.common.coroutines.flow.FlowExtensionsKt;
import com.jetbrains.toolbox.gateway.DevEnvironmentFeature;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.DevEnvironmentManager;
import com.jetbrains.toolbox.gateway.ssh.FingerprintPromptHandler;
import com.jetbrains.toolbox.gateway.ssh.FingerprintUserInput;
import com.jetbrains.toolbox.gateway.ssh.PassphrasePromptHandler;
import com.jetbrains.toolbox.gateway.ssh.PasswordPromptHandler;
import com.jetbrains.toolbox.gateway.ssh.PasswordUserInput;
import com.jetbrains.toolbox.gateway.ssh.PromptHandler;
import com.jetbrains.toolbox.gateway.ssh.SshAuthenticationManager;
import com.jetbrains.toolbox.gateway.ssh.SshAuthenticationManagerKt;
import com.jetbrains.toolbox.gateway.ssh.SshPasswordStore;
import com.jetbrains.toolbox.gateway.ssh.UserInput;
import com.jetbrains.toolbox.gateway.utils.DevEnvironmentManagerExtensions;
import com.jetbrains.toolbox.manager.AuthenticationDialogResult;
import com.jetbrains.toolbox.manager.DialogManager;
import com.jetbrains.toolbox.manager.MultipleAnswerDialogHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.coroutines.selects.SelectBuilder;
import kotlinx.coroutines.selects.SelectImplementation;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nSshAuthenticationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshAuthenticationManager.kt\ncom/jetbrains/toolbox/gateway/ssh/SshAuthenticationManager\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,218:1\n116#2,11:219\n116#2,11:230\n116#2,11:241\n116#2,11:252\n*S KotlinDebug\n*F\n+ 1 SshAuthenticationManager.kt\ncom/jetbrains/toolbox/gateway/ssh/SshAuthenticationManager\n*L\n163#1:219,11\n170#1:230,11\n195#1:241,11\n209#1:252,11\n*E\n"})
public final class SshAuthenticationManager {
    @NotNull
    private final DialogManager dialogManager;
    @NotNull
    private final SshPasswordStore passwordStore;
    @NotNull
    private final DevEnvironmentManager devEnvironmentManager;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final MutableStateFlow<Map<String, AuthenticationSession>> authenticationSessions;
    @NotNull
    private final Mutex authenticationSessionsMutex;
    @NotNull
    private final MutableStateFlow<List<String>> askpassRequestStates;

    public SshAuthenticationManager(@NotNull DialogManager dialogManager, @NotNull SshPasswordStore passwordStore, @NotNull DevEnvironmentManager devEnvironmentManager, @NotNull CoroutineScope scope2) {
        Intrinsics.checkNotNullParameter((Object)dialogManager, (String)"dialogManager");
        Intrinsics.checkNotNullParameter((Object)passwordStore, (String)"passwordStore");
        Intrinsics.checkNotNullParameter((Object)devEnvironmentManager, (String)"devEnvironmentManager");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.dialogManager = dialogManager;
        this.passwordStore = passwordStore;
        this.devEnvironmentManager = devEnvironmentManager;
        this.scope = scope2;
        this.authenticationSessions = StateFlowKt.MutableStateFlow((Object)MapsKt.emptyMap());
        this.authenticationSessionsMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.askpassRequestStates = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
    }

    @Nullable
    public final Object collectAuthSessionForEnvironment(@NotNull DevEnvironmentId id, @NotNull Function1<? super Continuation<? super Unit>, ? extends Object> handler2, @NotNull Continuation<? super Unit> $completion) {
        Object object = FlowKt.collectLatest((Flow)((Flow)this.authenticationSessions), (Function2)((Function2)new Function2<Map<String, ? extends AuthenticationSession>, Continuation<? super Unit>, Object>(id, handler2, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            int I$0;
            int I$1;
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ DevEnvironmentId $id;
            final /* synthetic */ Function1<Continuation<? super Unit>, Object> $handler;
            {
                this.$id = $id;
                this.$handler = $handler;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (Map)this.L$0;
                var12_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var3_4 = sessions;
                        var4_5 = this.$id;
                        var5_6 = this.$handler;
                        $i$f$forEach = 0;
                        var7_8 = $this$forEach$iv.entrySet().iterator();
lbl11:
                        // 4 sources

                        while (var7_8.hasNext()) {
                            var9_10 = element$iv = (Map.Entry)var7_8.next();
                            $i$a$-forEach-SshAuthenticationManager$collectAuthSessionForEnvironment$2$1 = 0;
                            session = (AuthenticationSession)var9_10.getValue();
                            if (!Intrinsics.areEqual((Object)session.getId(), (Object)var4_5) || session.isClosed()) continue;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)sessions);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                            this.L$2 = var4_5;
                            this.L$3 = var5_6;
                            this.L$4 = var7_8;
                            this.L$5 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                            this.L$6 = SpillingKt.nullOutSpilledVariable((Object)session);
                            this.I$0 = $i$f$forEach;
                            this.I$1 = $i$a$-forEach-SshAuthenticationManager$collectAuthSessionForEnvironment$2$1;
                            this.label = 1;
                            v0 = FlowKt.collectLatest((Flow)((Flow)session.getDialogVisible()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>((Function1<? super Continuation<? super Unit>, ? extends Object>)var5_6, null){
                                int label;
                                /* synthetic */ boolean Z$0;
                                final /* synthetic */ Function1<Continuation<? super Unit>, Object> $handler;
                                {
                                    this.$handler = $handler;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    boolean bl = this.Z$0;
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            void visible;
                                            ResultKt.throwOnFailure((Object)$result);
                                            if (visible == false) {
                                                return Unit.INSTANCE;
                                            }
                                            this.Z$0 = visible;
                                            this.label = 1;
                                            Object object2 = this.$handler.invoke((Object)((Object)this));
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.Z$0 = (Boolean)value2;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)this);
                            if (v0 != var12_3) continue;
                            return var12_3;
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-forEach-SshAuthenticationManager$collectAuthSessionForEnvironment$2$1 = this.I$1;
                        $i$f$forEach = this.I$0;
                        session = (AuthenticationSession)this.L$6;
                        element$iv = (Map.Entry)this.L$5;
                        var7_8 = (Iterator)this.L$4;
                        var5_6 = (Function1)this.L$3;
                        var4_5 = (DevEnvironmentId)this.L$2;
                        $this$forEach$iv = (Map)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl11
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(Map<String, AuthenticationSession> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object reportAskpassRequest(@NotNull String sessionId, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof reportAskpassRequest.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ SshAuthenticationManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.reportAskpassRequest(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.authenticationSessionsMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = sessionId;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                sessionId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                try {
                    $i$a$-withLock$default-SshAuthenticationManager$reportAskpassRequest$2 = false;
                    var7_11 = this.askpassRequestStates;
                    var7_11.setValue((Object)CollectionsKt.plus((Collection)((Collection)var7_11.getValue()), (Object)sessionId));
                    var8_12 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object createSession(@NotNull String sessionId, @NotNull DevEnvironmentId id, boolean shouldAskForPassword, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof createSession.1)) ** GOTO lbl-1000
        var13_5 = $completion;
        if ((var13_5.label & -2147483648) != 0) {
            var13_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                boolean Z$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ SshAuthenticationManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createSession(null, null, false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Logger.INSTANCE.debug("Creating session " + sessionId);
                $this$withLock_u24default$iv = this.authenticationSessionsMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = sessionId;
                $continuation.L$1 = id;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.Z$0 = shouldAskForPassword;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var14_7) {
                    return var14_7;
                }
                ** GOTO lbl35
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                shouldAskForPassword = $continuation.Z$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                id = (DevEnvironmentId)$continuation.L$1;
                sessionId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl35:
                // 2 sources

                try {
                    $i$a$-withLock$default-SshAuthenticationManager$createSession$2 = false;
                    var9_13 = this.authenticationSessions;
                    var9_13.setValue((Object)MapsKt.plus((Map)((Map)var9_13.getValue()), (Pair)TuplesKt.to((Object)sessionId, (Object)new AuthenticationSession(id, this.dialogManager, this.passwordStore, shouldAskForPassword != false, this.devEnvironmentManager, this.scope))));
                    var10_14 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object registerAuthMethod(@NotNull String sessionId, @NotNull String method, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof registerAuthMethod.1)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SshAuthenticationManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.registerAuthMethod(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Logger.INSTANCE.debug("Setting auth method " + method + " for session " + sessionId);
                $continuation.L$0 = sessionId;
                $continuation.L$1 = method;
                $continuation.label = 1;
                v0 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)SshAuthenticationManagerKt.access$getSESSION_AWAIT_TIMEOUT$p(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AuthenticationSession>, Object>(this, sessionId, null){
                    int label;
                    final /* synthetic */ SshAuthenticationManager this$0;
                    final /* synthetic */ String $sessionId;
                    {
                        this.this$0 = $receiver;
                        this.$sessionId = $sessionId;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = FlowKt.firstOrNull((Flow)((Flow)SshAuthenticationManager.access$getAuthenticationSessions$p(this.this$0)), (Function2)((Function2)new Function2<Map<String, ? extends AuthenticationSession>, Continuation<? super Boolean>, Object>(this.$sessionId, null){
                                    int label;
                                    /* synthetic */ Object L$0;
                                    final /* synthetic */ String $sessionId;
                                    {
                                        this.$sessionId = $sessionId;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Map map2 = (Map)this.L$0;
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                void it;
                                                ResultKt.throwOnFailure((Object)$result);
                                                return Boxing.boxBoolean((boolean)it.containsKey(this.$sessionId));
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value2;
                                        return (Continuation)var3_3;
                                    }

                                    public final Object invoke(Map<String, AuthenticationSession> p1, Continuation<? super Boolean> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                v1 = (Map)v0;
                                return v1 != null ? (AuthenticationSession)v1.get(this.$sessionId) : null;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super AuthenticationSession> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                method = (String)$continuation.L$1;
                sessionId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if ((var4_7 = (AuthenticationSession)v0) != null) {
                    var4_7.setAuthenticationMethod(method);
                } else {
                    Logger.INSTANCE.debug("Auth method event '" + method + "' ignored because session with id: " + sessionId + " couldn't be found");
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object reportError(@NotNull String sessionId, @NotNull String error, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof reportError.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SshAuthenticationManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.reportError(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = sessionId;
                $continuation.L$1 = error;
                $continuation.label = 1;
                v0 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)SshAuthenticationManagerKt.access$getSESSION_AWAIT_TIMEOUT$p(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AuthenticationSession>, Object>(this, sessionId, null){
                    int label;
                    final /* synthetic */ SshAuthenticationManager this$0;
                    final /* synthetic */ String $sessionId;
                    {
                        this.this$0 = $receiver;
                        this.$sessionId = $sessionId;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = FlowKt.firstOrNull((Flow)((Flow)SshAuthenticationManager.access$getAuthenticationSessions$p(this.this$0)), (Function2)((Function2)new Function2<Map<String, ? extends AuthenticationSession>, Continuation<? super Boolean>, Object>(this.$sessionId, null){
                                    int label;
                                    /* synthetic */ Object L$0;
                                    final /* synthetic */ String $sessionId;
                                    {
                                        this.$sessionId = $sessionId;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Map map2 = (Map)this.L$0;
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                void it;
                                                ResultKt.throwOnFailure((Object)$result);
                                                return Boxing.boxBoolean((boolean)it.containsKey(this.$sessionId));
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value2;
                                        return (Continuation)var3_3;
                                    }

                                    public final Object invoke(Map<String, AuthenticationSession> p1, Continuation<? super Boolean> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                v1 = (Map)v0;
                                return v1 != null ? (AuthenticationSession)v1.get(this.$sessionId) : null;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super AuthenticationSession> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                error = (String)$continuation.L$1;
                sessionId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if ((var4_7 = (AuthenticationSession)v0) != null) {
                    session = var4_7;
                    $i$a$-let-SshAuthenticationManager$reportError$3 = false;
                    if (!session.isClosed()) {
                        this.passwordStore.forgetPassword(session.getId());
                        session.reportError(error);
                    }
                } else {
                    Logger.INSTANCE.debug("Error '" + error + "' ignored because session with id: " + sessionId + " couldn't be found");
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Object closeSession(@NotNull String sessionId, @NotNull Continuation<? super Unit> $completion) {
        block13: {
            if (!($completion instanceof closeSession.1)) ** GOTO lbl-1000
            var10_3 = $completion;
            if ((var10_3.label & -2147483648) != 0) {
                var10_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ SshAuthenticationManager this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.closeSession(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    Logger.INSTANCE.debug("Closing session " + sessionId);
                    $this$withLock_u24default$iv = this.authenticationSessionsMutex;
                    owner$iv = null;
                    $i$f$withLock = 0;
                    $continuation.L$0 = sessionId;
                    $continuation.L$1 = $this$withLock_u24default$iv;
                    $continuation.I$0 = $i$f$withLock;
                    $continuation.label = 1;
                    v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                    if (v0 == var11_5) {
                        return var11_5;
                    }
                    ** GOTO lbl32
                }
                case 1: {
                    $i$f$withLock = $continuation.I$0;
                    owner$iv = null;
                    $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                    sessionId = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl32:
                    // 3 sources

                    $i$a$-withLock$default-SshAuthenticationManager$closeSession$2 = 0;
                    v1 = (AuthenticationSession)((Map)this.authenticationSessions.getValue()).get(sessionId);
                    if (v1 == null) break;
                    $continuation.L$0 = sessionId;
                    $continuation.L$1 = $this$withLock_u24default$iv;
                    $continuation.I$0 = $i$f$withLock;
                    $continuation.I$1 = $i$a$-withLock$default-SshAuthenticationManager$closeSession$2;
                    $continuation.label = 2;
                    v2 = v1.close((Continuation<? super Unit>)$continuation);
                    v3 = v2;
                    if (v2 == var11_5) {
                        return var11_5;
                    }
                    ** GOTO lbl59
                }
                case 2: {
                    $i$a$-withLock$default-SshAuthenticationManager$closeSession$2 = $continuation.I$1;
                    $i$f$withLock = $continuation.I$0;
                    owner$iv = null;
                    $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                    sessionId = (String)$continuation.L$0;
                    ** try [egrp 1[TRYBLOCK] [1 : 310->329)] { 
lbl56:
                    // 1 sources

                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl59:
                    // 2 sources

                    v4 = Unit.INSTANCE;
                    break block13;
                }
            }
            v4 = null;
            break block13;
lbl63:
            // 1 sources

            finally {
                $this$withLock_u24default$iv.unlock(owner$iv);
            }
        }
        var7_10 = v4;
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, sessionId, null){
            int label;
            final /* synthetic */ SshAuthenticationManager this$0;
            final /* synthetic */ String $sessionId;
            {
                this.this$0 = $receiver;
                this.$sessionId = $sessionId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)SshAuthenticationManagerKt.access$getSESSION_AWAIT_TIMEOUT$p(), (Continuation)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = SshAuthenticationManager.access$getAuthenticationSessions$p(this.this$0);
                        var2_3.setValue((Object)MapsKt.minus((Map)((Map)var2_3.getValue()), (Object)this.$sessionId));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object requestInput(@NotNull String sessionId, @NotNull String prompt, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof requestInput.1)) ** GOTO lbl-1000
        var12_4 = $completion;
        if ((var12_4.label & -2147483648) != 0) {
            var12_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ SshAuthenticationManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.requestInput(null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = sessionId;
                $continuation.L$1 = prompt;
                $continuation.label = 1;
                v0 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)SshAuthenticationManagerKt.access$getSESSION_AWAIT_TIMEOUT$p(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends String>>, Object>(this, sessionId, null){
                    int label;
                    final /* synthetic */ SshAuthenticationManager this$0;
                    final /* synthetic */ String $sessionId;
                    {
                        this.this$0 = $receiver;
                        this.$sessionId = $sessionId;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = FlowKt.first((Flow)((Flow)SshAuthenticationManager.access$getAskpassRequestStates$p(this.this$0)), (Function2)((Function2)new Function2<List<? extends String>, Continuation<? super Boolean>, Object>(this.$sessionId, null){
                                    int label;
                                    /* synthetic */ Object L$0;
                                    final /* synthetic */ String $sessionId;
                                    {
                                        this.$sessionId = $sessionId;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        List list2 = (List)this.L$0;
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                void it;
                                                ResultKt.throwOnFailure((Object)$result);
                                                return Boxing.boxBoolean((boolean)it.contains(this.$sessionId));
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value2;
                                        return (Continuation)var3_3;
                                    }

                                    public final Object invoke(List<String> p1, Continuation<? super Boolean> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super List<String>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                prompt = (String)$continuation.L$1;
                sessionId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if ((List)v0 == null) {
                    var5_7 = "Didn't get input request for sessionId: " + sessionId + " within " + Duration.toIsoString-impl((long)SshAuthenticationManagerKt.access$getSESSION_AWAIT_TIMEOUT$p()) + " timeout";
                    throw new IllegalStateException(var5_7.toString());
                }
                $this$withLock_u24default$iv = this.authenticationSessionsMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = sessionId;
                $continuation.L$1 = prompt;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 2;
                v1 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v1 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl47
            }
            case 2: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                prompt = (String)$continuation.L$1;
                sessionId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl47:
                // 2 sources

                try {
                    $i$a$-withLock$default-SshAuthenticationManager$requestInput$3 = false;
                    var8_14 = this.askpassRequestStates;
                    var8_14.setValue((Object)CollectionsKt.minus((Iterable)((Iterable)var8_14.getValue()), (Object)sessionId));
                    var9_15 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                $continuation.L$0 = sessionId;
                $continuation.L$1 = prompt;
                $continuation.L$2 = null;
                $continuation.label = 3;
                v2 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)SshAuthenticationManagerKt.access$getSESSION_AWAIT_TIMEOUT$p(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AuthenticationSession>, Object>(this, sessionId, null){
                    int label;
                    final /* synthetic */ SshAuthenticationManager this$0;
                    final /* synthetic */ String $sessionId;
                    {
                        this.this$0 = $receiver;
                        this.$sessionId = $sessionId;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = FlowKt.firstOrNull((Flow)((Flow)SshAuthenticationManager.access$getAuthenticationSessions$p(this.this$0)), (Function2)((Function2)new Function2<Map<String, ? extends AuthenticationSession>, Continuation<? super Boolean>, Object>(this.$sessionId, null){
                                    int label;
                                    /* synthetic */ Object L$0;
                                    final /* synthetic */ String $sessionId;
                                    {
                                        this.$sessionId = $sessionId;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Map map2 = (Map)this.L$0;
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                void it;
                                                ResultKt.throwOnFailure((Object)$result);
                                                return Boxing.boxBoolean((boolean)it.containsKey(this.$sessionId));
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value2;
                                        return (Continuation)var3_3;
                                    }

                                    public final Object invoke(Map<String, AuthenticationSession> p1, Continuation<? super Boolean> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                v1 = (Map)v0;
                                return v1 != null ? (AuthenticationSession)v1.get(this.$sessionId) : null;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super AuthenticationSession> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl71
            }
            case 3: {
                prompt = (String)$continuation.L$1;
                sessionId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl71:
                // 2 sources

                v3 = (AuthenticationSession)v2;
                if (v3 == null) {
                    var6_12 = "Cannot find authentication session for id: " + sessionId;
                    throw new IllegalStateException(var6_12.toString());
                }
                session = v3;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)sessionId);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)prompt);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)session);
                $continuation.label = 4;
                v4 = session.requestInput(prompt, (Continuation<? super String>)$continuation);
                if (v4 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl90
            }
            case 4: {
                session = (AuthenticationSession)$continuation.L$2;
                prompt = (String)$continuation.L$1;
                sessionId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl90:
                // 2 sources

                return v4;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ MutableStateFlow access$getAuthenticationSessions$p(SshAuthenticationManager $this) {
        return $this.authenticationSessions;
    }

    public static final /* synthetic */ MutableStateFlow access$getAskpassRequestStates$p(SshAuthenticationManager $this) {
        return $this.askpassRequestStates;
    }

    @SourceDebugExtension(value={"SMAP\nSshAuthenticationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshAuthenticationManager.kt\ncom/jetbrains/toolbox/gateway/ssh/SshAuthenticationManager$AuthenticationSession\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 5 Select.kt\nkotlinx/coroutines/selects/SelectKt\n*L\n1#1,218:1\n64#1:230\n65#1,4:236\n230#2,5:219\n230#2,5:224\n230#2,5:231\n1#3:229\n116#4,8:240\n125#4,2:253\n54#5,5:248\n*S KotlinDebug\n*F\n+ 1 SshAuthenticationManager.kt\ncom/jetbrains/toolbox/gateway/ssh/SshAuthenticationManager$AuthenticationSession\n*L\n77#1:230\n77#1:236,4\n64#1:219,5\n68#1:224,5\n77#1:231,5\n82#1:240,8\n82#1:253,2\n122#1:248,5\n*E\n"})
    private static final class AuthenticationSession {
        @NotNull
        private final DevEnvironmentId id;
        @NotNull
        private final DialogManager dialogManager;
        @NotNull
        private final SshPasswordStore passwordStore;
        @NotNull
        private final DevEnvironmentManager devEnvironmentManager;
        @NotNull
        private final CoroutineScope scope;
        @NotNull
        private final Mutex mutex;
        @NotNull
        private final CompletableDeferred<Unit> closed;
        @NotNull
        private final MutableStateFlow<String> bodyState;
        @NotNull
        private final MutableStateFlow<String> errorState;
        @NotNull
        private final MutableStateFlow<String> authMethodState;
        @Nullable
        private MultipleAnswerDialogHandle authDialogHandle;
        @NotNull
        private final List<PromptHandler> handlers;
        @NotNull
        private final MutableStateFlow<Set<String>> dismissed;
        @NotNull
        private final MutableStateFlow<Integer> dialogStack;

        public AuthenticationSession(@NotNull DevEnvironmentId id, @NotNull DialogManager dialogManager, @NotNull SshPasswordStore passwordStore, boolean shouldAskForPassword, @NotNull DevEnvironmentManager devEnvironmentManager, @NotNull CoroutineScope scope2) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)dialogManager, (String)"dialogManager");
            Intrinsics.checkNotNullParameter((Object)passwordStore, (String)"passwordStore");
            Intrinsics.checkNotNullParameter((Object)devEnvironmentManager, (String)"devEnvironmentManager");
            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
            this.id = id;
            this.dialogManager = dialogManager;
            this.passwordStore = passwordStore;
            this.devEnvironmentManager = devEnvironmentManager;
            this.scope = scope2;
            this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
            this.closed = CompletableDeferredKt.CompletableDeferred(null);
            this.bodyState = StateFlowKt.MutableStateFlow((Object)"");
            this.errorState = StateFlowKt.MutableStateFlow(null);
            this.authMethodState = StateFlowKt.MutableStateFlow(null);
            Object[] objectArray = new PromptHandler[]{new PasswordPromptHandler(shouldAskForPassword, new PasswordUserInput(this){
                final /* synthetic */ AuthenticationSession this$0;
                {
                    this.this$0 = $receiver;
                }

                public final Object ask(String prompt, String host, Continuation<? super String> $completion) {
                    return AuthenticationSession.access$getPassword(this.this$0, prompt, host, $completion);
                }
            }), new PassphrasePromptHandler(new UserInput(this){
                final /* synthetic */ AuthenticationSession this$0;
                {
                    this.this$0 = $receiver;
                }

                public final Object ask(String prompt, Continuation<? super String> $completion) {
                    return AuthenticationSession.getPassword$default(this.this$0, prompt, null, $completion, 2, null);
                }
            }), new FingerprintPromptHandler.Ask(new FingerprintUserInput(this){
                final /* synthetic */ AuthenticationSession this$0;
                {
                    this.this$0 = $receiver;
                }

                public final Object ask(String prompt, String host, String fingerprint, Continuation<? super Boolean> $completion) {
                    return AuthenticationSession.access$getFingerprintConfirmation(this.this$0, prompt, host, fingerprint, $completion);
                }
            })};
            this.handlers = CollectionsKt.listOfNotNull((Object[])objectArray);
            this.dismissed = StateFlowKt.MutableStateFlow((Object)SetsKt.emptySet());
            this.dialogStack = StateFlowKt.MutableStateFlow((Object)0);
        }

        @NotNull
        public final DevEnvironmentId getId() {
            return this.id;
        }

        @NotNull
        public final StateFlow<Boolean> getDialogVisible() {
            return FlowExtensionsKt.mapState((StateFlow)this.dialogStack, AuthenticationSession::_get_dialogVisible_$lambda$0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <T> T withDialogCounter(Function0<? extends T> block) {
            int it;
            Integer nextValue$iv;
            Object prevValue$iv;
            boolean $i$f$withDialogCounter = false;
            MutableStateFlow $this$update$iv = this.dialogStack;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                it = ((Number)prevValue$iv).intValue();
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = Integer.valueOf(it + 1))));
            try {
                Object object = block.invoke();
                return (T)object;
            }
            finally {
                int it2;
                Integer nextValue$iv2;
                Object prevValue$iv2;
                InlineMarker.finallyStart((int)1);
                MutableStateFlow $this$update$iv2 = this.dialogStack;
                boolean $i$f$update2 = false;
                do {
                    prevValue$iv2 = $this$update$iv2.getValue();
                    it2 = ((Number)prevValue$iv2).intValue();
                    boolean bl = false;
                } while (!$this$update$iv2.compareAndSet(prevValue$iv2, (Object)(nextValue$iv2 = Integer.valueOf(it2 - 1))));
                InlineMarker.finallyEnd((int)1);
            }
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object requestInput(@NotNull String prompt, @NotNull Continuation<? super String> $completion) {
            block8: {
                if (!($completion instanceof requestInput.1)) ** GOTO lbl-1000
                var7_3 = $completion;
                if ((var7_3.label & -2147483648) != 0) {
                    var7_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ AuthenticationSession this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.requestInput(null, (Continuation<? super String>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var3_6 = ((Iterable)this.handlers).iterator();
lbl13:
                        // 2 sources

                        while (var3_6.hasNext()) {
                            it = (PromptHandler)var3_6.next();
                            $i$a$-firstNotNullOfOrNull-SshAuthenticationManager$AuthenticationSession$requestInput$2 = 0;
                            $continuation.L$0 = prompt;
                            $continuation.L$1 = var3_6;
                            $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)it);
                            $continuation.I$0 = $i$a$-firstNotNullOfOrNull-SshAuthenticationManager$AuthenticationSession$requestInput$2;
                            $continuation.label = 1;
                            v0 = it.onData(prompt, this.id, (Continuation<? super String>)$continuation);
                            if (v0 == var8_5) {
                                return var8_5;
                            }
                            ** GOTO lbl33
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-firstNotNullOfOrNull-SshAuthenticationManager$AuthenticationSession$requestInput$2 = $continuation.I$0;
                        it = (PromptHandler)$continuation.L$2;
                        var3_6 = (Iterator)$continuation.L$1;
                        prompt = (String)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl33:
                        // 2 sources

                        if ((var4_7 = (String)v0) == null) ** GOTO lbl13
                        v1 = var4_7;
                        break block8;
                    }
                }
                v1 = null;
            }
            return v1;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private final Object getFingerprintConfirmation(String prompt, String host, String fingerprint, Continuation<? super Boolean> $completion) {
            if (!($completion instanceof getFingerprintConfirmation.1)) ** GOTO lbl-1000
            var17_5 = $completion;
            if ((var17_5.label & -2147483648) != 0) {
                var17_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ AuthenticationSession this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return AuthenticationSession.access$getFingerprintConfirmation(this.this$0, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var18_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    this_$iv = this;
                    $i$f$withDialogCounter = 0;
                    $this$update$iv$iv = AuthenticationSession.access$getDialogStack$p(this_$iv);
                    $i$f$update = false;
                    do {
                        prevValue$iv$iv = $this$update$iv$iv.getValue();
                        it$iv = ((Number)prevValue$iv$iv).intValue();
                        $i$a$-update-SshAuthenticationManager$AuthenticationSession$withDialogCounter$1$iv = false;
                    } while (!$this$update$iv$iv.compareAndSet(prevValue$iv$iv, nextValue$iv$iv = Boxing.boxInt((int)(it$iv + 1))));
                    $i$a$-withDialogCounter-SshAuthenticationManager$AuthenticationSession$getFingerprintConfirmation$2 = 0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)prompt);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)host);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)fingerprint);
                    $continuation.L$3 = this_$iv;
                    $continuation.I$0 = $i$f$withDialogCounter;
                    $continuation.I$1 = $i$a$-withDialogCounter-SshAuthenticationManager$AuthenticationSession$getFingerprintConfirmation$2;
                    $continuation.label = 1;
                    v0 = this.dialogManager.showSshFingerprintConfirmationDialog(prompt, host, fingerprint, (Continuation<? super Boolean>)$continuation);
                    ** if (v0 != var18_7) goto lbl36
lbl35:
                    // 1 sources

                    return var18_7;
lbl36:
                    // 1 sources

                    ** GOTO lbl48
                }
                case 1: {
                    $i$a$-withDialogCounter-SshAuthenticationManager$AuthenticationSession$getFingerprintConfirmation$2 = $continuation.I$1;
                    $i$f$withDialogCounter = $continuation.I$0;
                    this_$iv = (AuthenticationSession)$continuation.L$3;
                    fingerprint = (String)$continuation.L$2;
                    host = (String)$continuation.L$1;
                    prompt = (String)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl48:
                        // 2 sources

                        var15_23 = v0;
                    }
                    catch (Throwable var8_13) {
                        $this$update$iv$iv = AuthenticationSession.access$getDialogStack$p(this_$iv);
                        $i$f$update = false;
                        do {
                            prevValue$iv$iv = $this$update$iv$iv.getValue();
                            it$iv = ((Number)prevValue$iv$iv).intValue();
                            $i$a$-update-SshAuthenticationManager$AuthenticationSession$withDialogCounter$2$iv = false;
                        } while (!$this$update$iv$iv.compareAndSet(prevValue$iv$iv, (Object)(nextValue$iv$iv = Boxing.boxInt((int)(it$iv - 1)))));
                        throw var8_13;
                    }
                    var8_12 = AuthenticationSession.access$getDialogStack$p(this_$iv);
                    while (!var8_12.compareAndSet(nextValue$iv$iv = var8_12.getValue(), (Object)($i$a$-update-SshAuthenticationManager$AuthenticationSession$withDialogCounter$1$iv = Boxing.boxInt((int)(($i$a$-update-SshAuthenticationManager$AuthenticationSession$withDialogCounter$1$iv = ((Number)nextValue$iv$iv).intValue()) - 1))))) {
                    }
                    return var15_23;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private final Object getPassword(String prompt, String host, Continuation<? super String> $completion) {
            if (!($completion instanceof getPassword.1)) ** GOTO lbl-1000
            var19_4 = $completion;
            if ((var19_4.label & -2147483648) != 0) {
                var19_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    int I$0;
                    int I$1;
                    int I$2;
                    int I$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ AuthenticationSession this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return AuthenticationSession.access$getPassword(this.this$0, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var20_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$withLock_u24default$iv = this.mutex;
                    owner$iv = null;
                    $i$f$withLock = 0;
                    $continuation.L$0 = prompt;
                    $continuation.L$1 = host;
                    $continuation.L$2 = $this$withLock_u24default$iv;
                    $continuation.I$0 = $i$f$withLock;
                    $continuation.label = 1;
                    v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                    if (v0 == var20_6) {
                        return var20_6;
                    }
                    ** GOTO lbl33
                }
                case 1: {
                    $i$f$withLock = $continuation.I$0;
                    owner$iv = null;
                    $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                    host = (String)$continuation.L$1;
                    prompt = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl33:
                    // 3 sources

                    $i$a$-withLock$default-SshAuthenticationManager$AuthenticationSession$getPassword$2 = 0;
                    currentAuthMethod = (String)this.authMethodState.getValue();
                    if (!CollectionsKt.contains((Iterable)((Iterable)this.dismissed.getValue()), (Object)currentAuthMethod)) ** GOTO lbl39
                    v1 = "";
                    ** GOTO lbl88
lbl39:
                    // 1 sources

                    asyncAnswer = BuildersKt.async$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AuthenticationDialogResult>, Object>(host, this, prompt, currentAuthMethod, null){
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        int I$0;
                        int I$1;
                        int I$2;
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ String $host;
                        final /* synthetic */ AuthenticationSession this$0;
                        final /* synthetic */ String $prompt;
                        final /* synthetic */ String $currentAuthMethod;
                        {
                            this.$host = $host;
                            this.this$0 = $receiver;
                            this.$prompt = $prompt;
                            this.$currentAuthMethod = $currentAuthMethod;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Unable to fully structure code
                         * Could not resolve type clashes
                         */
                        public final Object invokeSuspend(Object $result) {
                            block29: {
                                var2_2 = (CoroutineScope)this.L$0;
                                var21_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (this.$host != null && (storedPassword = AuthenticationSession.access$getPasswordStore$p(this.this$0).getPassword(this.this$0.getId(), this.$host)) != null) {
                                            return new AuthenticationDialogResult.Answer(storedPassword);
                                        }
                                        AuthenticationSession.access$getBodyState$p(this.this$0).setValue((Object)this.$prompt);
                                        v0 = AuthenticationSession.access$getAuthDialogHandle$p(this.this$0);
                                        if (v0 == null) ** GOTO lbl21
                                        this.L$0 = $this$async;
                                        this.label = 1;
                                        v1 = v0.request((Continuation<? super AuthenticationDialogResult>)((Continuation)this));
                                        if (v1 == var21_3) {
                                            return var21_3;
                                        }
                                        ** GOTO lbl20
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl20:
                                        // 2 sources

                                        if ((v0 = (AuthenticationDialogResult)v1) != null) ** GOTO lbl103
lbl21:
                                        // 2 sources

                                        var6_5 = $this$async;
                                        var7_6 = this.this$0;
                                        $this$invokeSuspend_u24lambda_u240 /* !! */  = var6_5;
                                        $i$a$-run-SshAuthenticationManager$AuthenticationSession$getPassword$2$asyncAnswer$1$answer$1 = 0;
                                        this_$iv = var7_6;
                                        $i$f$withDialogCounter = 0;
                                        $this$update$iv$iv /* !! */  = AuthenticationSession.access$getDialogStack$p(this_$iv);
                                        $i$f$update = false;
                                        do {
                                            prevValue$iv$iv = $this$update$iv$iv /* !! */ .getValue();
                                            it$iv = ((Number)prevValue$iv$iv).intValue();
                                            $i$a$-update-SshAuthenticationManager$AuthenticationSession$withDialogCounter$1$iv = false;
                                        } while (!$this$update$iv$iv /* !! */ .compareAndSet(prevValue$iv$iv, (Object)(nextValue$iv$iv = Boxing.boxInt((int)(it$iv + 1)))));
                                        $i$a$-withDialogCounter-SshAuthenticationManager$AuthenticationSession$getPassword$2$asyncAnswer$1$answer$1$1 = 0;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$async);
                                        this.L$1 = var7_6;
                                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u240 /* !! */ );
                                        this.L$3 = this_$iv;
                                        this.I$0 = $i$a$-run-SshAuthenticationManager$AuthenticationSession$getPassword$2$asyncAnswer$1$answer$1;
                                        this.I$1 = $i$f$withDialogCounter;
                                        this.I$2 = $i$a$-withDialogCounter-SshAuthenticationManager$AuthenticationSession$getPassword$2$asyncAnswer$1$answer$1$1;
                                        this.label = 2;
                                        v2 = AuthenticationSession.access$getDialogManager$p(var7_6).showAuthenticationDialog(var7_6.getId().getEnvironmentId(), (StateFlow<String>)((StateFlow)AuthenticationSession.access$getBodyState$p(var7_6)), (StateFlow<String>)((StateFlow)AuthenticationSession.access$getErrorState$p(var7_6)), (Continuation<? super MultipleAnswerDialogHandle>)this);
                                        ** if (v2 != var21_3) goto lbl50
lbl49:
                                        // 1 sources

                                        return var21_3;
lbl50:
                                        // 1 sources

                                        ** GOTO lbl62
                                    }
                                    case 2: {
                                        $i$a$-withDialogCounter-SshAuthenticationManager$AuthenticationSession$getPassword$2$asyncAnswer$1$answer$1$1 = this.I$2;
                                        $i$f$withDialogCounter = this.I$1;
                                        $i$a$-run-SshAuthenticationManager$AuthenticationSession$getPassword$2$asyncAnswer$1$answer$1 = this.I$0;
                                        this_$iv = (AuthenticationSession)this.L$3;
                                        $this$invokeSuspend_u24lambda_u240 /* !! */  = (CoroutineScope)this.L$2;
                                        var7_6 = (AuthenticationSession)this.L$1;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl62:
                                        // 2 sources

                                        handle = (MultipleAnswerDialogHandle)v2;
                                        AuthenticationSession.access$setAuthDialogHandle$p(var7_6, handle);
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$async);
                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u240 /* !! */ );
                                        this.L$2 = this_$iv;
                                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)handle);
                                        this.I$0 = $i$a$-run-SshAuthenticationManager$AuthenticationSession$getPassword$2$asyncAnswer$1$answer$1;
                                        this.I$1 = $i$f$withDialogCounter;
                                        this.I$2 = $i$a$-withDialogCounter-SshAuthenticationManager$AuthenticationSession$getPassword$2$asyncAnswer$1$answer$1$1;
                                        this.label = 3;
                                        v3 = handle.request((Continuation<? super AuthenticationDialogResult>)this);
                                        ** if (v3 != var21_3) goto lbl75
lbl74:
                                        // 1 sources

                                        return var21_3;
lbl75:
                                        // 1 sources

                                        ** GOTO lbl87
                                    }
                                    case 3: {
                                        $i$a$-withDialogCounter-SshAuthenticationManager$AuthenticationSession$getPassword$2$asyncAnswer$1$answer$1$1 = this.I$2;
                                        $i$f$withDialogCounter = this.I$1;
                                        $i$a$-run-SshAuthenticationManager$AuthenticationSession$getPassword$2$asyncAnswer$1$answer$1 = this.I$0;
                                        handle = (MultipleAnswerDialogHandle)this.L$3;
                                        this_$iv = (AuthenticationSession)this.L$2;
                                        $this$invokeSuspend_u24lambda_u240 /* !! */  = (CoroutineScope)this.L$1;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v3 = $result;
lbl87:
                                            // 2 sources

                                            $this$update$iv$iv /* !! */  = (AuthenticationDialogResult)v3;
                                            v0 = $this$update$iv$iv /* !! */ ;
                                        }
                                        catch (Throwable $this$update$iv$iv) {
                                            throw $this$update$iv$iv;
                                        }
                                        finally {
                                            $this$update$iv$iv = AuthenticationSession.access$getDialogStack$p(this_$iv);
                                            $i$f$update = false;
                                            do {
                                                prevValue$iv$iv = $this$update$iv$iv.getValue();
                                                it$iv = ((Number)prevValue$iv$iv).intValue();
                                                $i$a$-update-SshAuthenticationManager$AuthenticationSession$withDialogCounter$2$iv = false;
                                            } while (!$this$update$iv$iv.compareAndSet(prevValue$iv$iv, (Object)(nextValue$iv$iv = Boxing.boxInt((int)(it$iv - 1)))));
                                        }
lbl103:
                                        // 2 sources

                                        answer = v0;
                                        AuthenticationSession.access$getErrorState$p(this.this$0).setValue(null);
                                        var4_33 = answer;
                                        if (!(var4_33 instanceof AuthenticationDialogResult.Answer)) ** GOTO lbl110
                                        if (this.$host != null) {
                                            AuthenticationSession.access$getPasswordStore$p(this.this$0).storePassword(this.this$0.getId(), this.$host, ((AuthenticationDialogResult.Answer)answer).getAnswer());
                                        }
                                        break block29;
lbl110:
                                        // 1 sources

                                        if (!Intrinsics.areEqual((Object)var4_33, (Object)AuthenticationDialogResult.Cancel.INSTANCE)) break;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$async);
                                        this.L$1 = answer;
                                        this.L$2 = null;
                                        this.L$3 = null;
                                        this.label = 4;
                                        v4 = this.this$0.close((Continuation<? super Unit>)((Continuation)this));
                                        if (v4 == var21_3) {
                                            return var21_3;
                                        }
                                        ** GOTO lbl124
                                    }
                                    case 4: {
                                        answer = (AuthenticationDialogResult)this.L$1;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v4 = $result;
lbl124:
                                        // 2 sources

                                        if ((var5_34 = DevEnvironmentManagerExtensions.INSTANCE.findEnvironment(AuthenticationSession.access$getDevEnvironmentManager$p(this.this$0), this.this$0.getId())) == null) break block29;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$async);
                                        this.L$1 = answer;
                                        this.label = 5;
                                        v5 = var5_34.getFeatures((Continuation<? super List<? extends DevEnvironmentFeature>>)((Continuation)this));
                                        if (v5 == var21_3) {
                                            return var21_3;
                                        }
                                        ** GOTO lbl136
                                    }
                                    case 5: {
                                        answer = (AuthenticationDialogResult)this.L$1;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v5 = $result;
lbl136:
                                        // 2 sources

                                        if ((var6_5 = (List)v5) != null) {
                                            $this$invokeSuspend_u24lambda_u240 /* !! */  = (Iterable)var6_5;
                                            $i$f$filterIsInstance = false;
                                            this_$iv = $this$filterIsInstance$iv;
                                            destination$iv$iv = new ArrayList<E>();
                                            $i$f$filterIsInstanceTo = false;
                                            for (E element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                                if (!(element$iv$iv instanceof DevEnvironmentFeature.Connectable)) continue;
                                                destination$iv$iv.add(element$iv$iv);
                                            }
                                            $this$filterIsInstance$iv = (DevEnvironmentFeature.Connectable)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
                                            if ($this$filterIsInstance$iv != null) {
                                                $this$filterIsInstance$iv.disconnect();
                                            }
                                        }
                                        break block29;
                                    }
                                }
                                if (Intrinsics.areEqual((Object)var4_33, (Object)AuthenticationDialogResult.Skip.INSTANCE)) {
                                    v6 = this.$currentAuthMethod;
                                    if (v6 != null) {
                                        var6_5 = v6;
                                        var7_6 = this.this$0;
                                        method = var6_5;
                                        $i$a$-let-SshAuthenticationManager$AuthenticationSession$getPassword$2$asyncAnswer$1$1 = false;
                                        $this$update$iv = AuthenticationSession.access$getDismissed$p(var7_6);
                                        $i$f$update = false;
                                        do {
                                            prevValue$iv = $this$update$iv.getValue();
                                            it = (Set)prevValue$iv;
                                            $i$a$-update-SshAuthenticationManager$AuthenticationSession$getPassword$2$asyncAnswer$1$1$1 = false;
                                        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = SetsKt.plus((Set)it, (Object)method))));
                                    }
                                    Boxing.boxBoolean((boolean)AuthenticationSession.access$getAuthMethodState$p(this.this$0).compareAndSet((Object)this.$currentAuthMethod, null));
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            return answer;
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value2;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super AuthenticationDialogResult> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    var10_17 = $continuation;
                    $i$f$select = 0;
                    $this$select_u24lambda_u240$iv = new SelectImplementation($continuation.getContext());
                    $i$a$-run-SelectKt$select$2$iv = 0;
                    $this$getPassword_u24lambda_u240_u240 = (SelectBuilder)$this$select_u24lambda_u240$iv;
                    $i$a$-select-SshAuthenticationManager$AuthenticationSession$getPassword$2$1 = false;
                    $this$getPassword_u24lambda_u240_u240.invoke(asyncAnswer.getOnAwait(), (Function2)new Function2<AuthenticationDialogResult, Continuation<? super String>, Object>(null){
                        int label;
                        /* synthetic */ Object L$0;

                        /*
                         * WARNING - void declaration
                         */
                        public final Object invokeSuspend(Object $result) {
                            AuthenticationDialogResult authenticationDialogResult = (AuthenticationDialogResult)this.L$0;
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    void it;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object = it instanceof AuthenticationDialogResult.Answer ? (AuthenticationDialogResult.Answer)it : null;
                                    if (object == null || (object = ((AuthenticationDialogResult.Answer)object).getAnswer()) == null) {
                                        object = "";
                                    }
                                    return object;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value2;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(AuthenticationDialogResult p1, Continuation<? super String> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    });
                    $this$getPassword_u24lambda_u240_u240.invoke(AuthenticationSession.access$getClosed$p(this).getOnAwait(), (Function2)new Function2<Unit, Continuation<? super String>, Object>(null){
                        int label;

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    return "";
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(Unit p1, Continuation<? super String> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    });
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)prompt);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)host);
                    $continuation.L$2 = $this$withLock_u24default$iv;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)currentAuthMethod);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)asyncAnswer);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)$completion$iv);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)$this$select_u24lambda_u240$iv);
                    $continuation.I$0 = $i$f$withLock;
                    $continuation.I$1 = $i$a$-withLock$default-SshAuthenticationManager$AuthenticationSession$getPassword$2;
                    $continuation.I$2 = $i$f$select;
                    $continuation.I$3 = $i$a$-run-SelectKt$select$2$iv;
                    $continuation.label = 2;
                    v2 = $this$select_u24lambda_u240$iv.doSelect((Continuation)$continuation);
                    ** if (v2 != var20_6) goto lbl65
lbl64:
                    // 1 sources

                    return var20_6;
lbl65:
                    // 1 sources

                    ** GOTO lbl86
                }
                case 2: {
                    $i$a$-run-SelectKt$select$2$iv = $continuation.I$3;
                    $i$f$select = $continuation.I$2;
                    $i$a$-withLock$default-SshAuthenticationManager$AuthenticationSession$getPassword$2 = $continuation.I$1;
                    $i$f$withLock = $continuation.I$0;
                    $this$select_u24lambda_u240$iv = (SelectImplementation)$continuation.L$6;
                    $completion$iv = $continuation.L$5;
                    asyncAnswer = (Deferred)$continuation.L$4;
                    currentAuthMethod = (String)$continuation.L$3;
                    owner$iv = null;
                    $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                    host = (String)$continuation.L$1;
                    prompt = (String)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl86:
                        // 2 sources

                        v1 = (String)v2;
lbl88:
                        // 2 sources

                        var16_27 = v1;
                    }
                    catch (Throwable var17_28) {
                        throw var17_28;
                    }
                    finally {
                        $this$withLock_u24default$iv.unlock(owner$iv);
                    }
                    return var16_27;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        static /* synthetic */ Object getPassword$default(AuthenticationSession authenticationSession, String string, String string2, Continuation continuation, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return authenticationSession.getPassword(string, string2, (Continuation<? super String>)continuation);
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object close(@NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof close.1)) ** GOTO lbl-1000
            var3_2 = $completion;
            if ((var3_2.label & -2147483648) != 0) {
                var3_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ AuthenticationSession this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.close((Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = this.authDialogHandle;
                    if (v0 == null) break;
                    $continuation.label = 1;
                    v1 = v0.close((Continuation<? super Unit>)$continuation);
                    if (v1 == var4_4) {
                        return var4_4;
                    }
                    break;
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    break;
                }
            }
            this.closed.complete((Object)Unit.INSTANCE);
            return Unit.INSTANCE;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public final void reportError(@NotNull String error2) {
            Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
            this.errorState.setValue((Object)error2);
        }

        public final boolean isClosed() {
            return this.closed.isCompleted();
        }

        public final void setAuthenticationMethod(@NotNull String method) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            this.authMethodState.setValue((Object)method);
        }

        private static final boolean _get_dialogVisible_$lambda$0(int it) {
            return it > 0;
        }

        public static final /* synthetic */ Object access$getFingerprintConfirmation(AuthenticationSession $this, String prompt, String host, String fingerprint, Continuation $completion) {
            return $this.getFingerprintConfirmation(prompt, host, fingerprint, (Continuation<? super Boolean>)$completion);
        }

        public static final /* synthetic */ Object access$getPassword(AuthenticationSession $this, String prompt, String host, Continuation $completion) {
            return $this.getPassword(prompt, host, (Continuation<? super String>)$completion);
        }

        public static final /* synthetic */ SshPasswordStore access$getPasswordStore$p(AuthenticationSession $this) {
            return $this.passwordStore;
        }

        public static final /* synthetic */ MutableStateFlow access$getBodyState$p(AuthenticationSession $this) {
            return $this.bodyState;
        }

        public static final /* synthetic */ MultipleAnswerDialogHandle access$getAuthDialogHandle$p(AuthenticationSession $this) {
            return $this.authDialogHandle;
        }

        public static final /* synthetic */ MutableStateFlow access$getErrorState$p(AuthenticationSession $this) {
            return $this.errorState;
        }

        public static final /* synthetic */ DevEnvironmentManager access$getDevEnvironmentManager$p(AuthenticationSession $this) {
            return $this.devEnvironmentManager;
        }

        public static final /* synthetic */ MutableStateFlow access$getAuthMethodState$p(AuthenticationSession $this) {
            return $this.authMethodState;
        }

        public static final /* synthetic */ DialogManager access$getDialogManager$p(AuthenticationSession $this) {
            return $this.dialogManager;
        }

        public static final /* synthetic */ void access$setAuthDialogHandle$p(AuthenticationSession $this, MultipleAnswerDialogHandle multipleAnswerDialogHandle) {
            $this.authDialogHandle = multipleAnswerDialogHandle;
        }

        public static final /* synthetic */ MutableStateFlow access$getDismissed$p(AuthenticationSession $this) {
            return $this.dismissed;
        }

        public static final /* synthetic */ CompletableDeferred access$getClosed$p(AuthenticationSession $this) {
            return $this.closed;
        }
    }
}

