/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.gateway.ssh.EndpointCreationResult;
import com.jetbrains.toolbox.gateway.ssh.SupportedSshOptions;
import com.jetbrains.toolbox.gateway.ssh.model.Endpoint;
import com.jetbrains.toolbox.gateway.ssh.parser.ParsingResult;
import com.jetbrains.toolbox.gateway.ssh.parser.SshConnectionStringParser;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nEndpointFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndpointFactory.kt\ncom/jetbrains/toolbox/gateway/ssh/EndpointFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1#2:93\n827#3:94\n855#3,2:95\n*S KotlinDebug\n*F\n+ 1 EndpointFactory.kt\ncom/jetbrains/toolbox/gateway/ssh/EndpointFactory\n*L\n55#1:94\n55#1:95,2\n*E\n"})
public final class EndpointFactory {
    @NotNull
    public static final EndpointFactory INSTANCE = new EndpointFactory();

    private EndpointFactory() {
    }

    @NotNull
    public final EndpointCreationResult create(@NotNull String str) {
        EndpointCreationResult endpointCreationResult;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        ParsingResult parsingResult = SshConnectionStringParser.INSTANCE.parse(str);
        if (parsingResult instanceof ParsingResult.Failure) {
            endpointCreationResult = new EndpointCreationResult.Failure("Parsing failure: " + ((ParsingResult.Failure)parsingResult).getReason());
        } else if (parsingResult instanceof ParsingResult.Success) {
            endpointCreationResult = this.handleSuccess(str, (ParsingResult.Success)parsingResult);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return endpointCreationResult;
    }

    /*
     * WARNING - void declaration
     */
    private final EndpointCreationResult handleSuccess(String originalString, ParsingResult.Success result2) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        List list2;
        void it;
        Object object;
        int n;
        Object $this$handleSuccess_u24lambda_u240 = this;
        boolean bl = false;
        Object port1 = result2.getPort();
        Integer port2 = ((EndpointFactory)$this$handleSuccess_u24lambda_u240).getPortOption(result2.getOptions());
        if (port1 != null && port2 != null) {
            Logger.INSTANCE.warn("Port is specified both in -p option and connection target. Defaulting to the connection target");
            n = (Integer)port1;
        } else {
            Integer n2 = port1;
            if (n2 != null) {
                n = n2;
            } else {
                Integer n3 = port2;
                n = n3 != null ? n3 : 0;
            }
        }
        int port = n;
        String string = result2.getHost();
        int n4 = port;
        String string2 = result2.getUser();
        String string3 = null;
        boolean bl2 = true;
        String string4 = this.getPrivateKeyPath(result2.getOptions());
        if (string4 != null) {
            port1 = string4;
            boolean bl3 = bl2;
            String string5 = string3;
            String string6 = string2;
            int n5 = n4;
            object = string;
            boolean bl4 = false;
            Object[] objectArray = new String[]{it};
            List list3 = CollectionsKt.mutableListOf((Object[])objectArray);
            string = object;
            n4 = n5;
            string2 = string6;
            string3 = string5;
            bl2 = bl3;
            list2 = list3;
        } else {
            list2 = null;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n6 = 1416;
        long l = 0L;
        String string7 = originalString;
        String string8 = null;
        List list4 = null;
        String string9 = this.getSshConfigPath(result2.getOptions());
        List list5 = list2;
        boolean bl5 = bl2;
        String string10 = string3;
        String string11 = string2;
        int n7 = n4;
        String string12 = string;
        Endpoint endpoint = new Endpoint(string12, n7, string11, string10, bl5, list5, string9, list4, string8, string7, l, n6, defaultConstructorMarker);
        $this$handleSuccess_u24lambda_u240 = result2.getOptions().keySet();
        object = endpoint;
        boolean $i$f$filterNot = false;
        it = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it2 = (String)element$iv$iv;
            boolean bl6 = false;
            if (SupportedSshOptions.INSTANCE.getOptions().contains(it2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list6 = (List)destination$iv$iv;
        Object object2 = object;
        return new EndpointCreationResult.Success((Endpoint)object2, list6);
    }

    private final String getPrivateKeyPath(Map<String, String> options) {
        String string;
        if (options.containsKey("-i")) {
            String value2 = (String)MapsKt.getValue(options, (Object)"-i");
            string = this.resolvePath(value2);
        } else {
            string = null;
        }
        return string;
    }

    private final String getSshConfigPath(Map<String, String> options) {
        String string;
        if (options.containsKey("-F")) {
            String value2 = (String)MapsKt.getValue(options, (Object)"-F");
            string = this.resolvePath(value2);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Integer getPortOption(Map<String, String> options) {
        Integer n;
        if (options.containsKey("-p")) {
            void var3_3;
            String value2 = (String)MapsKt.getValue(options, (Object)"-p");
            Integer port = StringsKt.toIntOrNull((String)value2);
            if (port == null) {
                Logger.INSTANCE.warn("Failed to convert -p value: \"" + value2 + "\" to number");
            }
            n = var3_3;
        } else {
            n = null;
        }
        return n;
    }

    private final String resolvePath(String rawPath) {
        if (StringsKt.startsWith$default((String)rawPath, (String)"~", (boolean)false, (int)2, null)) {
            CharSequence charSequence = rawPath;
            Regex regex = new Regex("^~");
            String string = System.getProperty("user.home");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            String string2 = Regex.Companion.escapeReplacement(string);
            return ((Object)Paths.get(regex.replaceFirst(charSequence, string2), new String[0])).toString();
        }
        Path path2 = Paths.get(rawPath, new String[0]);
        return path2.isAbsolute() ? ((Object)path2).toString() : ((Object)Paths.get(System.getProperty("user.home"), new String[0]).resolve(".ssh").resolve(path2)).toString();
    }
}

