/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.spaceport;

import com.jetbrains.toolbox.gateway.spaceport.EncodedSshKeys;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nSpaceportSshKeys.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceportSshKeys.kt\ncom/jetbrains/toolbox/gateway/spaceport/SpaceportSshKeysKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class SpaceportSshKeysKt {
    @NotNull
    public static final EncodedSshKeys generateEncodedSshKeys(@NotNull String user) {
        KeyPairGenerator keyPairGenerator;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        KeyPairGenerator it = keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        boolean bl = false;
        it.initialize(2048);
        KeyPairGenerator keyPairGenerator2 = keyPairGenerator;
        Intrinsics.checkNotNullExpressionValue((Object)keyPairGenerator2, (String)"also(...)");
        KeyPairGenerator generator = keyPairGenerator2;
        KeyPair keyPair = generator.genKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        String string = SpaceportSshKeysKt.encodePublicKey((RSAPublicKey)publicKey, user);
        PrivateKey privateKey = keyPair.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivate(...)");
        return new EncodedSshKeys(string, SpaceportSshKeysKt.encodePrivateKey(privateKey));
    }

    @NotNull
    public static final String encodePublicKey(@NotNull RSAPublicKey publicKey, @NotNull String user) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        ByteArrayOutputStream byteOs = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(byteOs);
        String string = "ssh-rsa";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        dos.writeInt(byArray.length);
        string = "ssh-rsa";
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        dos.write(byArray2);
        dos.writeInt(publicKey.getPublicExponent().toByteArray().length);
        dos.write(publicKey.getPublicExponent().toByteArray());
        dos.writeInt(publicKey.getModulus().toByteArray().length);
        dos.write(publicKey.getModulus().toByteArray());
        Base64 base64 = (Base64)Base64.Default;
        byte[] byArray3 = byteOs.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"toByteArray(...)");
        String publicKeyEncoded = Base64.encode$default((Base64)base64, (byte[])byArray3, (int)0, (int)0, (int)6, null);
        return "ssh-rsa " + publicKeyEncoded + " " + user;
    }

    @NotNull
    public static final String encodePrivateKey(@NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Base64 base64 = Base64.Default.getMime();
        byte[] byArray = privateKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return "-----BEGIN PRIVATE KEY-----\n" + Base64.encode$default((Base64)base64, (byte[])byArray, (int)0, (int)0, (int)6, null) + "\n-----END PRIVATE KEY-----";
    }
}

