/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.spaceport;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.gateway.spaceport.IdeVersionQuality;
import com.jetbrains.toolbox.gateway.spaceport.IdeVersionQuality$;
import com.jetbrains.toolbox.gateway.spaceport.PreferredIdeVersion$Fixed$;
import com.jetbrains.toolbox.gateway.spaceport.PreferredIdeVersion$LatestOfQuality$;
import com.jetbrains.toolbox.gateway.spaceport.PreferredIdeVersion$TeamcityBuild$;
import com.jetbrains.toolbox.gateway.spaceport.PrefferedIdeVersionSerializer;
import com.jetbrains.toolbox.gateway.spaceport.SpaceportProvider;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=PrefferedIdeVersionSerializer.class)
public abstract sealed class PreferredIdeVersion {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private PreferredIdeVersion() {
    }

    @NotNull
    public abstract LocalizableString presentationString();

    public /* synthetic */ PreferredIdeVersion(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<PreferredIdeVersion> serializer() {
            return (KSerializer)PrefferedIdeVersionSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    public static final class Fixed
    extends PreferredIdeVersion {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String version;
        @NotNull
        private final IdeVersionQuality quality;

        public Fixed(@NotNull String version, @NotNull IdeVersionQuality quality) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)quality, (String)"quality");
            super(null);
            this.version = version;
            this.quality = quality;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final IdeVersionQuality getQuality() {
            return this.quality;
        }

        @NotNull
        public String toString() {
            return this.version + " " + this.quality.getName();
        }

        @Override
        @NotNull
        public LocalizableString presentationString() {
            return SpaceportProvider.Companion.getLocalizableStringFactory().ptrl(this.version);
        }

        @NotNull
        public final String component1() {
            return this.version;
        }

        @NotNull
        public final IdeVersionQuality component2() {
            return this.quality;
        }

        @NotNull
        public final Fixed copy(@NotNull String version, @NotNull IdeVersionQuality quality) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)quality, (String)"quality");
            return new Fixed(version, quality);
        }

        public static /* synthetic */ Fixed copy$default(Fixed fixed, String string, IdeVersionQuality ideVersionQuality, int n, Object object) {
            if ((n & 1) != 0) {
                string = fixed.version;
            }
            if ((n & 2) != 0) {
                ideVersionQuality = fixed.quality;
            }
            return fixed.copy(string, ideVersionQuality);
        }

        public int hashCode() {
            int result2 = this.version.hashCode();
            result2 = result2 * 31 + this.quality.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Fixed)) {
                return false;
            }
            Fixed fixed = (Fixed)other;
            if (!Intrinsics.areEqual((Object)this.version, (Object)fixed.version)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.quality, (Object)fixed.quality);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$gateway_plugin_space_port(Fixed self, CompositeEncoder output2, SerialDescriptor serialDesc) {
            output2.encodeStringElement(serialDesc, 0, self.version);
            output2.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)IdeVersionQuality$.serializer.INSTANCE, (Object)self.quality);
        }

        public /* synthetic */ Fixed(int seen0, String version, IdeVersionQuality quality, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)Fixed$$serializer.INSTANCE.getDescriptor());
            }
            super(null);
            this.version = version;
            this.quality = quality;
        }

        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Fixed> serializer() {
                return (KSerializer)Fixed$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    public static final class LatestOfQuality
    extends PreferredIdeVersion {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final IdeVersionQuality minimumQuality;

        public LatestOfQuality(@NotNull IdeVersionQuality minimumQuality) {
            Intrinsics.checkNotNullParameter((Object)minimumQuality, (String)"minimumQuality");
            super(null);
            this.minimumQuality = minimumQuality;
        }

        @NotNull
        public final IdeVersionQuality getMinimumQuality() {
            return this.minimumQuality;
        }

        @NotNull
        public String toString() {
            return "Latest " + this.minimumQuality.getName();
        }

        @Override
        @NotNull
        public LocalizableString presentationString() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"minimumQualityName", (Object)this.minimumQuality.getName())};
            return SpaceportProvider.Companion.getLocalizableStringFactory().ptrl("Latest {{minimumQualityName}}", pairArray);
        }

        @NotNull
        public final IdeVersionQuality component1() {
            return this.minimumQuality;
        }

        @NotNull
        public final LatestOfQuality copy(@NotNull IdeVersionQuality minimumQuality) {
            Intrinsics.checkNotNullParameter((Object)minimumQuality, (String)"minimumQuality");
            return new LatestOfQuality(minimumQuality);
        }

        public static /* synthetic */ LatestOfQuality copy$default(LatestOfQuality latestOfQuality, IdeVersionQuality ideVersionQuality, int n, Object object) {
            if ((n & 1) != 0) {
                ideVersionQuality = latestOfQuality.minimumQuality;
            }
            return latestOfQuality.copy(ideVersionQuality);
        }

        public int hashCode() {
            return this.minimumQuality.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LatestOfQuality)) {
                return false;
            }
            LatestOfQuality latestOfQuality = (LatestOfQuality)other;
            return Intrinsics.areEqual((Object)this.minimumQuality, (Object)latestOfQuality.minimumQuality);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$gateway_plugin_space_port(LatestOfQuality self, CompositeEncoder output2, SerialDescriptor serialDesc) {
            output2.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)IdeVersionQuality$.serializer.INSTANCE, (Object)self.minimumQuality);
        }

        public /* synthetic */ LatestOfQuality(int seen0, IdeVersionQuality minimumQuality, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)LatestOfQuality$$serializer.INSTANCE.getDescriptor());
            }
            super(null);
            this.minimumQuality = minimumQuality;
        }

        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<LatestOfQuality> serializer() {
                return (KSerializer)LatestOfQuality$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    public static final class TeamcityBuild
    extends PreferredIdeVersion {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String buildId;
        @NotNull
        private final String backendArtifactLocation;

        public TeamcityBuild(@NotNull String buildId, @NotNull String backendArtifactLocation) {
            Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
            Intrinsics.checkNotNullParameter((Object)backendArtifactLocation, (String)"backendArtifactLocation");
            super(null);
            this.buildId = buildId;
            this.backendArtifactLocation = backendArtifactLocation;
        }

        @NotNull
        public final String getBuildId() {
            return this.buildId;
        }

        @NotNull
        public final String getBackendArtifactLocation() {
            return this.backendArtifactLocation;
        }

        @NotNull
        public String toString() {
            return "TeamCity Build " + this.buildId + " (" + this.backendArtifactLocation + ")";
        }

        @Override
        @NotNull
        public LocalizableString presentationString() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"buildNumber", (Object)this.buildId)};
            return SpaceportProvider.Companion.getLocalizableStringFactory().ptrl("TeamCity Build {{buildNumber}}", pairArray);
        }

        @NotNull
        public final String component1() {
            return this.buildId;
        }

        @NotNull
        public final String component2() {
            return this.backendArtifactLocation;
        }

        @NotNull
        public final TeamcityBuild copy(@NotNull String buildId, @NotNull String backendArtifactLocation) {
            Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
            Intrinsics.checkNotNullParameter((Object)backendArtifactLocation, (String)"backendArtifactLocation");
            return new TeamcityBuild(buildId, backendArtifactLocation);
        }

        public static /* synthetic */ TeamcityBuild copy$default(TeamcityBuild teamcityBuild, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = teamcityBuild.buildId;
            }
            if ((n & 2) != 0) {
                string2 = teamcityBuild.backendArtifactLocation;
            }
            return teamcityBuild.copy(string, string2);
        }

        public int hashCode() {
            int result2 = this.buildId.hashCode();
            result2 = result2 * 31 + this.backendArtifactLocation.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TeamcityBuild)) {
                return false;
            }
            TeamcityBuild teamcityBuild = (TeamcityBuild)other;
            if (!Intrinsics.areEqual((Object)this.buildId, (Object)teamcityBuild.buildId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.backendArtifactLocation, (Object)teamcityBuild.backendArtifactLocation);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$gateway_plugin_space_port(TeamcityBuild self, CompositeEncoder output2, SerialDescriptor serialDesc) {
            output2.encodeStringElement(serialDesc, 0, self.buildId);
            output2.encodeStringElement(serialDesc, 1, self.backendArtifactLocation);
        }

        public /* synthetic */ TeamcityBuild(int seen0, String buildId, String backendArtifactLocation, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)TeamcityBuild$$serializer.INSTANCE.getDescriptor());
            }
            super(null);
            this.buildId = buildId;
            this.backendArtifactLocation = backendArtifactLocation;
        }

        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<TeamcityBuild> serializer() {
                return (KSerializer)TeamcityBuild$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

