/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.spaceport;

import com.jetbrains.toolbox.api.core.PluginSettingsStore;
import com.jetbrains.toolbox.api.core.diagnostics.Logger;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CodeCanvasSettings {
    @NotNull
    private final PluginSettingsStore store;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String autoConnectyKey;
    @NotNull
    private final String selectedTemplateKey;

    public CodeCanvasSettings(@NotNull PluginSettingsStore store2, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)store2, (String)"store");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.store = store2;
        this.logger = logger;
        this.autoConnectyKey = "CODE_CANVAS_AUTO_CONNECT";
        this.selectedTemplateKey = "spaceportSelectedDevConfiguration";
    }

    private final String asEnvKey(String $this$asEnvKey, String id) {
        return $this$asEnvKey + "_" + id;
    }

    public final void setAutoConnect(@NotNull String environmentId, boolean autoConnect) {
        Intrinsics.checkNotNullParameter((Object)environmentId, (String)"environmentId");
        ((Map)this.store).put(this.asEnvKey(this.autoConnectyKey, environmentId), String.valueOf(autoConnect));
        this.logger.info(() -> CodeCanvasSettings.setAutoConnect$lambda$0(environmentId, autoConnect));
    }

    @Nullable
    public final Boolean autoConnectStatus(@NotNull String envId) {
        Intrinsics.checkNotNullParameter((Object)envId, (String)"envId");
        String string = (String)this.store.get((Object)this.asEnvKey(this.autoConnectyKey, envId));
        return string != null ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
    }

    public final void saveTemplatePreset(@NotNull String templateId) {
        Intrinsics.checkNotNullParameter((Object)templateId, (String)"templateId");
        ((Map)this.store).put(this.selectedTemplateKey, templateId);
    }

    @Nullable
    public final String getTemplatePreset() {
        return (String)this.store.get((Object)this.selectedTemplateKey);
    }

    private static final String setAutoConnect$lambda$0(String $environmentId, boolean $autoConnect) {
        return "Set auto connect for environment (" + $environmentId + ") to (" + $autoConnect + ")";
    }
}

