/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.spaceport;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.localization.LocalizableStringFactory;
import com.jetbrains.toolbox.api.remoteDev.ProviderVisibilityState;
import com.jetbrains.toolbox.api.ui.ToolboxUi;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CodeCanvasErrorManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ToolboxUi toolboxUi;
    @NotNull
    private final StateFlow<ProviderVisibilityState> visibilityState;
    @NotNull
    private final LocalizableStringFactory i18n;
    @NotNull
    public static final String ENVS_LOAD_FAILED = "envs-load-fail";
    @NotNull
    public static final String TEMPLATES_LOAD_FAILED = "templates-load-fail";
    @NotNull
    public static final String CREATE_ENV_FAILED = "create-failed";
    @NotNull
    public static final String CREATE_PARAMETER_FAILED = "create-parameter-failed";
    @NotNull
    public static final String PARAMETERS_LOAD_FAILED = "parameters-load-failed";
    @NotNull
    public static final String BRANCHES_LOAD_FAILED = "branches-load-failed";
    @NotNull
    public static final String RENAME_FAILED = "env-rename-failed";

    public CodeCanvasErrorManager(@NotNull ToolboxUi toolboxUi, @NotNull StateFlow<ProviderVisibilityState> visibilityState, @NotNull LocalizableStringFactory i18n) {
        Intrinsics.checkNotNullParameter((Object)toolboxUi, (String)"toolboxUi");
        Intrinsics.checkNotNullParameter(visibilityState, (String)"visibilityState");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        this.toolboxUi = toolboxUi;
        this.visibilityState = visibilityState;
        this.i18n = i18n;
    }

    @Nullable
    public final Object showError(@NotNull String id, @NotNull LocalizableString title2, @NotNull LocalizableString message2, @NotNull Continuation<? super Unit> $completion) {
        if (((ProviderVisibilityState)this.visibilityState.getValue()).getProviderVisible()) {
            Object object = this.toolboxUi.showSnackbar(id, title2, message2, this.i18n.ptrl("Dismiss"), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

