/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.pluginManagement;

import com.jetbrains.toolbox.gateway.pluginManagement.MarketplaceException;
import com.jetbrains.toolbox.gateway.pluginManagement.MarketplaceNetworkException;
import com.jetbrains.toolbox.gateway.pluginManagement.PluginDownloadCanceledException;
import com.jetbrains.toolbox.gateway.pluginManagement.PluginDownloadFailedException;
import com.jetbrains.toolbox.gateway.pluginManagement.PluginIncompatibilityException;
import com.jetbrains.toolbox.gateway.pluginManagement.PluginNotFoundException;
import com.jetbrains.toolbox.gateway.pluginManagement.PluginSignatureVerificationException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MarketplaceExceptionFactory {
    @NotNull
    public static final MarketplaceExceptionFactory INSTANCE = new MarketplaceExceptionFactory();

    private MarketplaceExceptionFactory() {
    }

    @NotNull
    public final MarketplaceException createNetworkException(@NotNull String detailedMessage, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)detailedMessage, (String)"detailedMessage");
        return new MarketplaceNetworkException(detailedMessage, cause);
    }

    public static /* synthetic */ MarketplaceException createNetworkException$default(MarketplaceExceptionFactory marketplaceExceptionFactory, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        return marketplaceExceptionFactory.createNetworkException(string, throwable);
    }

    @NotNull
    public final MarketplaceException createDownloadCancelledException(@NotNull String detailedMessage, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)detailedMessage, (String)"detailedMessage");
        return new PluginDownloadCanceledException(detailedMessage, cause);
    }

    public static /* synthetic */ MarketplaceException createDownloadCancelledException$default(MarketplaceExceptionFactory marketplaceExceptionFactory, String string, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            string = "Plugin download was cancelled";
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        return marketplaceExceptionFactory.createDownloadCancelledException(string, throwable);
    }

    @NotNull
    public final MarketplaceException createDownloadFailedException(@NotNull String detailedMessage, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)detailedMessage, (String)"detailedMessage");
        return new PluginDownloadFailedException(detailedMessage, cause);
    }

    public static /* synthetic */ MarketplaceException createDownloadFailedException$default(MarketplaceExceptionFactory marketplaceExceptionFactory, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        return marketplaceExceptionFactory.createDownloadFailedException(string, throwable);
    }

    @NotNull
    public final MarketplaceException createSignatureException(@NotNull String detailedMessage, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)detailedMessage, (String)"detailedMessage");
        return new PluginSignatureVerificationException(detailedMessage, cause);
    }

    public static /* synthetic */ MarketplaceException createSignatureException$default(MarketplaceExceptionFactory marketplaceExceptionFactory, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        return marketplaceExceptionFactory.createSignatureException(string, throwable);
    }

    @NotNull
    public final MarketplaceException createIncompatibilityException(@NotNull String detailedMessage, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)detailedMessage, (String)"detailedMessage");
        return new PluginIncompatibilityException(detailedMessage, cause);
    }

    public static /* synthetic */ MarketplaceException createIncompatibilityException$default(MarketplaceExceptionFactory marketplaceExceptionFactory, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        return marketplaceExceptionFactory.createIncompatibilityException(string, throwable);
    }

    @NotNull
    public final MarketplaceException createPluginNotFoundException(@NotNull String detailedMessage, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)detailedMessage, (String)"detailedMessage");
        return new PluginNotFoundException(detailedMessage, cause);
    }

    public static /* synthetic */ MarketplaceException createPluginNotFoundException$default(MarketplaceExceptionFactory marketplaceExceptionFactory, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        return marketplaceExceptionFactory.createPluginNotFoundException(string, throwable);
    }
}

