/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.pluginImpl;

import com.jetbrains.toolbox.api.core.auth.SSLSettings;
import com.jetbrains.toolbox.network.CertificateManager;
import com.jetbrains.toolbox.network.CertificateManagerContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SSLSettingsImpl
implements SSLSettings {
    @NotNull
    private final CertificateManager manager;

    public SSLSettingsImpl(@NotNull CertificateManager manager2) {
        Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
        this.manager = manager2;
    }

    @Nullable
    public SSLSocketFactory getSocketFactory() {
        CertificateManagerContext certificateManagerContext = this.manager.currentContext();
        return certificateManagerContext != null ? certificateManagerContext.getSocketFactory() : null;
    }

    @Nullable
    public X509TrustManager getTrustManager() {
        CertificateManagerContext certificateManagerContext = this.manager.currentContext();
        return certificateManagerContext != null ? certificateManagerContext.getTrustManager() : null;
    }

    @NotNull
    public Flow<Unit> getCertificatesChanged() {
        return (Flow)this.manager.getCertificatesChanged();
    }
}

