/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.error;

import com.jetbrains.toolbox.UtilKt;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.ui.DescriptionTree;
import com.jetbrains.toolbox.gateway.error.EnvironmentError;
import com.jetbrains.toolbox.i18n.LocalizableStringEx;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract sealed class DeployError
extends EnvironmentError {
    private DeployError() {
    }

    public /* synthetic */ DeployError(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class DeployTimeout
    extends DeployError {
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;

        private DeployTimeout(long timeout2) {
            super((DefaultConstructorMarker)null);
            this.message = "Deploy process didn't finish in " + Duration.getInWholeSeconds-impl((long)timeout2) + " seconds";
            this.localized = LocalizableStringExKt.trl(this.getMessage());
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        public /* synthetic */ DeployTimeout(long timeout2, DefaultConstructorMarker $constructor_marker) {
            this(timeout2);
        }
    }

    public static final class DownloadError
    extends DeployError {
        @NotNull
        private final LocalizableString detailed;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;

        public DownloadError(@NotNull LocalizableString detailed) {
            Intrinsics.checkNotNullParameter((Object)detailed, (String)"detailed");
            super((DefaultConstructorMarker)null);
            this.detailed = detailed;
            this.message = "Failed to download Toolbox Agent on the remote host";
            this.localized = LocalizableStringExKt.trl(this.getMessage());
        }

        public /* synthetic */ DownloadError(LocalizableString localizableString, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                localizableString = LocalizableStringExKt.trl("Can't download Toolbox Agent");
            }
            this(localizableString);
        }

        @Override
        @NotNull
        public LocalizableString getDetailed() {
            return this.detailed;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        public DownloadError() {
            this(null, 1, null);
        }
    }

    public static final class JavaIsMissingError
    extends DeployError {
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;

        public JavaIsMissingError(@NotNull String javaVersion) {
            Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
            super((DefaultConstructorMarker)null);
            this.message = "Java is missing, expected java " + javaVersion + " to be found on host machine";
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"javaVersion", (Object)javaVersion)};
            this.localized = LocalizableStringExKt.trl("Java is missing, expected java {{javaVersion}} to be found on host machine", pairArray);
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }
    }

    public static final class LaunchError
    extends DeployError {
        @Nullable
        private final Throwable cause;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;

        public LaunchError(@NotNull String target, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            super((DefaultConstructorMarker)null);
            this.cause = cause;
            this.message = "Can't launch " + target;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"target", (Object)target)};
            this.localized = LocalizableStringExKt.trl("Can't launch {{target}}", pairArray);
        }

        public /* synthetic */ LaunchError(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable);
        }

        @Override
        @Nullable
        public Throwable getCause() {
            return this.cause;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }
    }

    public static final class MalformedCliResponse
    extends DeployError {
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized = LocalizableStringExKt.trl(this.getMessage());
        @NotNull
        private final List<DescriptionTree> description;

        /*
         * WARNING - void declaration
         */
        public MalformedCliResponse(@Nullable Function1<? super Continuation<? super Boolean>, ? extends Object> killToolboxAction2) {
            super((DefaultConstructorMarker)null);
            DescriptionTree.Action action2;
            this.message = "The running instance of Toolbox sends malformed response";
            MalformedCliResponse malformedCliResponse = this;
            Object[] objectArray = new DescriptionTree.Text[]{new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("There's a running instance of Toolbox App or Toolbox Agent on remote environment. However, it's either not compatible with the current version or corrupted.")), new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("The problem can be resolved by killing the Toolbox application on remote side."))};
            Collection collection = CollectionsKt.listOf((Object[])objectArray);
            Function1<? super Continuation<? super Boolean>, ? extends Object> function1 = killToolboxAction2;
            if (function1 != null) {
                void it;
                Function1<? super Continuation<? super Boolean>, ? extends Object> function12 = function1;
                Collection collection2 = collection;
                MalformedCliResponse malformedCliResponse2 = malformedCliResponse;
                boolean bl = false;
                DescriptionTree.Action action3 = new DescriptionTree.Action((LocalizableString)LocalizableStringExKt.trl("Kill Toolbox process"), () -> MalformedCliResponse.description$lambda$0$0((Function1)it));
                malformedCliResponse = malformedCliResponse2;
                collection = collection2;
                action2 = action3;
            } else {
                action2 = null;
            }
            malformedCliResponse.description = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOfNotNull(action2));
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @Override
        @NotNull
        public List<DescriptionTree> getDescription() {
            return this.description;
        }

        private static final boolean description$lambda$0$0(Function1 $it) {
            return (Boolean)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>((Function1<? super Continuation<? super Boolean>, ? extends Object>)$it, null){
                int label;
                final /* synthetic */ Function1<Continuation<? super Boolean>, Object> $it;
                {
                    this.$it = $it;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$it.invoke((Object)((Object)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    public static final class NoDiskSpace
    extends DeployError {
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized = LocalizableStringExKt.trl(this.getMessage());

        public NoDiskSpace() {
            super((DefaultConstructorMarker)null);
            this.message = "Not enough free disk space to download Toolbox Agent";
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }
    }

    public static final class PowershellCoreNotSupported
    extends DeployError {
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized = LocalizableStringExKt.trl(this.getMessage());
        @NotNull
        private final List<DescriptionTree> description;

        public PowershellCoreNotSupported() {
            super((DefaultConstructorMarker)null);
            this.message = "Unsupported login shell";
            Object[] objectArray = new DescriptionTree[2];
            objectArray[0] = new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("The default SSH login shell on remote machine is Powershell Core. Unfortunately, this shell is currently not supported. Currently supported Windows shells are:"));
            Object[] objectArray2 = new LocalizableStringEx[]{LocalizableStringExKt.notr("cmd"), LocalizableStringExKt.notr("PowerShell Desktop")};
            objectArray[1] = new DescriptionTree.Bulletpoints(CollectionsKt.listOf((Object[])objectArray2));
            this.description = CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @Override
        @NotNull
        public List<DescriptionTree> getDescription() {
            return this.description;
        }
    }

    public static final class SelfCheckError
    extends DeployError {
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized = LocalizableStringExKt.trl(this.getMessage());

        public SelfCheckError() {
            super((DefaultConstructorMarker)null);
            this.message = "Toolbox Agent failed self-check after downloading";
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }
    }

    public static final class SshDeployFailed
    extends DeployError {
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;
        @NotNull
        private final List<DescriptionTree> description;

        public SshDeployFailed(@Nullable String reason) {
            super((DefaultConstructorMarker)null);
            List list2;
            Object[] objectArray;
            String string = reason;
            Object object = this.message = string != null ? "Failed to deploy Toolbox Agent to remote machine: " + string : "Failed to deploy Toolbox Agent to remote machine due to unknown error";
            if (reason != null) {
                objectArray = new Pair[]{TuplesKt.to((Object)"reason", (Object)reason.toString())};
                v2 = LocalizableStringExKt.trl("Failed to deploy Toolbox Agent to remote machine: {{reason}}", objectArray);
            } else {
                v2 = this.localized = (LocalizableString)LocalizableStringExKt.trl("Failed to deploy Toolbox Agent to remote machine due to unknown error");
            }
            if (reason == null) {
                objectArray = new DescriptionTree[2];
                objectArray[0] = new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("Toolbox App was unable to detect the reason for the failure. Try the following steps:"));
                Object[] objectArray2 = new LocalizableStringEx[3];
                objectArray2[0] = LocalizableStringExKt.trl("Ensure that the remote machine meets all minimum requirements");
                objectArray2[1] = LocalizableStringExKt.trl("Check if the connection can be established via the command line using the SSH command");
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"youTrackUrl", (Object)UtilKt.generateReportIssueUrl$default(null, null, 3, null))};
                objectArray2[2] = LocalizableStringExKt.trl("If the problem persists, please report the issue in [url]{{youTrackUrl}}|YouTrack[/url]", pairArray);
                objectArray[1] = new DescriptionTree.Bulletpoints(CollectionsKt.listOf((Object[])objectArray2));
                list2 = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list2 = CollectionsKt.emptyList();
            }
            this.description = list2;
        }

        public /* synthetic */ SshDeployFailed(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @Override
        @NotNull
        public List<DescriptionTree> getDescription() {
            return this.description;
        }

        public SshDeployFailed() {
            this(null, 1, null);
        }
    }

    public static final class TarMissing
    extends DeployError {
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized = LocalizableStringExKt.trl(this.getMessage());

        public TarMissing() {
            super((DefaultConstructorMarker)null);
            this.message = "'tar' command is missing";
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }
    }

    public static final class ToolboxAppRunning
    extends DeployError {
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized = LocalizableStringExKt.trl(this.getMessage());
        @NotNull
        private final List<DescriptionTree> description;

        /*
         * WARNING - void declaration
         */
        public ToolboxAppRunning(@Nullable Function1<? super Continuation<? super Boolean>, ? extends Object> killToolboxAction2) {
            super((DefaultConstructorMarker)null);
            DescriptionTree.Action action2;
            this.message = "Toolbox App is running on remote environment";
            ToolboxAppRunning toolboxAppRunning = this;
            Collection collection = CollectionsKt.listOf((Object)new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("In current version, the Toolbox Agent can't be run alongside the Toolbox App. In order to start using the environment as a remote one, the user should quit the Toolbox App")));
            Function1<? super Continuation<? super Boolean>, ? extends Object> function1 = killToolboxAction2;
            if (function1 != null) {
                void it;
                Function1<? super Continuation<? super Boolean>, ? extends Object> function12 = function1;
                Collection collection2 = collection;
                ToolboxAppRunning toolboxAppRunning2 = toolboxAppRunning;
                boolean bl = false;
                DescriptionTree.Action action3 = new DescriptionTree.Action((LocalizableString)LocalizableStringExKt.trl("Kill Toolbox App"), () -> ToolboxAppRunning.description$lambda$0$0((Function1)it));
                toolboxAppRunning = toolboxAppRunning2;
                collection = collection2;
                action2 = action3;
            } else {
                action2 = null;
            }
            toolboxAppRunning.description = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOfNotNull(action2));
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @Override
        @NotNull
        public List<DescriptionTree> getDescription() {
            return this.description;
        }

        private static final boolean description$lambda$0$0(Function1 $it) {
            return (Boolean)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>((Function1<? super Continuation<? super Boolean>, ? extends Object>)$it, null){
                int label;
                final /* synthetic */ Function1<Continuation<? super Boolean>, Object> $it;
                {
                    this.$it = $it;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$it.invoke((Object)((Object)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    public static final class UnsupportedOSError
    extends DeployError {
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized = LocalizableStringExKt.trl(this.getMessage());

        public UnsupportedOSError() {
            super((DefaultConstructorMarker)null);
            this.message = "Unsupported OS";
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }
    }

    public static final class UntarError
    extends DeployError {
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized = LocalizableStringExKt.trl(this.getMessage());

        public UntarError() {
            super((DefaultConstructorMarker)null);
            this.message = "Failed to extract distribution archive";
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }
    }

    public static final class UploadError
    extends DeployError {
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized = LocalizableStringExKt.trl(this.getMessage());

        public UploadError() {
            super((DefaultConstructorMarker)null);
            this.message = "Can't upload Toolbox Agent";
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }
    }
}

