/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.deploy.logs;

import com.jetbrains.toolbox.FileUtils;
import com.jetbrains.toolbox.agentNetworkApi.logs.LogsCollectorService;
import com.jetbrains.toolbox.agentNetworkApi.tools.dto.MultipartBlobDto;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.environment.EnvironmentDescriptorManager;
import com.jetbrains.toolbox.environment.model.EnvironmentDescriptor;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.deploy.ProgressInputStream;
import com.jetbrains.toolbox.gateway.deploy.logs.LogCollectionStep;
import com.jetbrains.toolbox.gateway.deploy.logs.RemoteLogCollectionStep;
import com.jetbrains.toolbox.gateway.utils.DtoMappers;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.CancellationException;
import kotlin.ExceptionsKt;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableStateFlow;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nRemoteLogCollectionStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteLogCollectionStep.kt\ncom/jetbrains/toolbox/gateway/deploy/logs/RemoteLogCollectionStep\n+ 2 FileSystem.kt\nokio/FileSystem\n+ 3 Okio.kt\nokio/Okio__OkioKt\n+ 4 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,66:1\n80#2:67\n165#2:68\n81#2:69\n82#2:74\n52#3,4:70\n60#3,10:75\n56#3,18:85\n375#4:103\n*S KotlinDebug\n*F\n+ 1 RemoteLogCollectionStep.kt\ncom/jetbrains/toolbox/gateway/deploy/logs/RemoteLogCollectionStep\n*L\n40#1:67\n40#1:68\n40#1:69\n40#1:74\n40#1:70,4\n40#1:75,10\n40#1:85,18\n58#1:103\n*E\n"})
public final class RemoteLogCollectionStep
implements LogCollectionStep {
    @NotNull
    private final DevEnvironmentId environmentId;
    @Nullable
    private final String remoteChannelId;
    @NotNull
    private final LogsCollectorService logsCollectorService;
    @NotNull
    private final EnvironmentDescriptorManager environmentDescriptorManager;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final FileUtils fileUtils;
    @NotNull
    private final LocalizableString title;

    private RemoteLogCollectionStep(DevEnvironmentId environmentId, String remoteChannelId, LogsCollectorService logsCollectorService, EnvironmentDescriptorManager environmentDescriptorManager, FileSystem fileSystem, FileUtils fileUtils) {
        Intrinsics.checkNotNullParameter((Object)environmentId, (String)"environmentId");
        Intrinsics.checkNotNullParameter((Object)logsCollectorService, (String)"logsCollectorService");
        Intrinsics.checkNotNullParameter((Object)environmentDescriptorManager, (String)"environmentDescriptorManager");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)fileUtils, (String)"fileUtils");
        this.environmentId = environmentId;
        this.remoteChannelId = remoteChannelId;
        this.logsCollectorService = logsCollectorService;
        this.environmentDescriptorManager = environmentDescriptorManager;
        this.fileSystem = fileSystem;
        this.fileUtils = fileUtils;
        this.title = LocalizableStringExKt.trl("Collecting remote Toolbox Agent logs");
    }

    @Override
    @NotNull
    public LocalizableString getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public Object isApplicable(@NotNull Continuation<? super Boolean> $completion) {
        return this.environmentDescriptorManager.withEnvironmentDescriptor(RemoteLogCollectionStep::isApplicable$lambda$0, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object collect(@NotNull MutableStateFlow<Float> progress, @NotNull Continuation<? super Path> $completion) {
        if (!($completion instanceof collect.1)) ** GOTO lbl-1000
        var20_3 = $completion;
        if ((var20_3.label & -2147483648) != 0) {
            var20_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int I$4;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteLogCollectionStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.collect(null, (Continuation<? super Path>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var21_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                tempDirectory = this.fileUtils.createTempDirectory("tbx-remote-logs");
                tempFile = tempDirectory.resolve("Host.zip");
                Logger.INSTANCE.info("Collecting remote logs for " + this.environmentId);
                logContents = this.logsCollectorService.collectLogs-6njv5Gs(this.remoteChannelId, true);
                var6_10 = this.fileSystem;
                file$iv = tempFile;
                mustCreate$iv = 0;
                $i$f$-write = 0;
                $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, false));
                $i$f$use = 0;
                thrown$iv$iv = null;
                it$iv = (BufferedSink)$this$use$iv$iv;
                $i$a$-use-FileSystem$write$1$iv = 0;
                $this$collect_u24lambda_u240 = it$iv;
                $i$a$--write$default-RemoteLogCollectionStep$collect$2 = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)progress);
                $continuation.L$1 = tempDirectory;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)tempFile);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)logContents);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$iv);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)file$iv);
                $continuation.L$6 = $this$use$iv$iv;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)it$iv);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)$this$collect_u24lambda_u240);
                $continuation.I$0 = mustCreate$iv;
                $continuation.I$1 = $i$f$-write;
                $continuation.I$2 = $i$f$use;
                $continuation.I$3 = $i$a$-use-FileSystem$write$1$iv;
                $continuation.I$4 = $i$a$--write$default-RemoteLogCollectionStep$collect$2;
                $continuation.label = 1;
                v0 = DtoMappers.INSTANCE.withMimeAndInputStream((Flow<? extends MultipartBlobDto>)logContents, (Function3<? super String, ? super Long, ? super InputStream, Unit>)(Function3)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, collect$lambda$0$0(okio.BufferedSink kotlinx.coroutines.flow.MutableStateFlow java.lang.String java.lang.Long java.io.InputStream ), (Ljava/lang/String;Ljava/lang/Long;Ljava/io/InputStream;)Lkotlin/Unit;)((BufferedSink)$this$collect_u24lambda_u240, (MutableStateFlow)progress), (Continuation<? super Unit>)$continuation);
                ** if (v0 != var21_5) goto lbl49
lbl48:
                // 1 sources

                return var21_5;
lbl49:
                // 1 sources

                ** GOTO lbl71
            }
            case 1: {
                $i$a$--write$default-RemoteLogCollectionStep$collect$2 = $continuation.I$4;
                $i$a$-use-FileSystem$write$1$iv = $continuation.I$3;
                $i$f$use = $continuation.I$2;
                $i$f$-write = $continuation.I$1;
                mustCreate$iv = $continuation.I$0;
                $this$collect_u24lambda_u240 = (BufferedSink)$continuation.L$8;
                it$iv = (BufferedSink)$continuation.L$7;
                thrown$iv$iv = null;
                $this$use$iv$iv = (Closeable)$continuation.L$6;
                file$iv = (Path)$continuation.L$5;
                $this$iv = (FileSystem)$continuation.L$4;
                logContents = (Flow)$continuation.L$3;
                tempFile = (Path)$continuation.L$2;
                tempDirectory = (Path)$continuation.L$1;
                progress = (MutableStateFlow)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl71:
                    // 2 sources

                    var14_26 = Unit.INSTANCE;
                    try {
                        v1 = $this$use$iv$iv;
                        if (v1 != null) {
                            v1.close();
                        }
                        ** GOTO lbl101
                    }
                    catch (Throwable t$iv$iv) {
                        thrown$iv$iv = t$iv$iv;
                    }
                    ** GOTO lbl101
                    {
                        catch (Throwable t$iv$iv) {
                            try {
                                thrown$iv$iv = t$iv$iv;
                                var14_26 = null;
                            }
                            catch (Throwable var17_34) {
                                throw var17_34;
                            }
                            finally {
                                try {
                                    v2 = $this$use$iv$iv;
                                    if (v2 != null) {
                                        v2.close();
                                    }
                                }
                                catch (Throwable t$iv$iv) {
                                    if (thrown$iv$iv != null) ** GOTO lbl99
                                    thrown$iv$iv = t$iv$iv;
                                    ** GOTO lbl100
lbl99:
                                    // 1 sources

                                    ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
                                }
lbl100:
                                // 3 sources

                            }
                        }
                    }
lbl101:
                    // 3 sources

                    result$iv$iv = var14_26;
                    v3 = thrown$iv$iv;
                    if (v3 != null) {
                        throw v3;
                    }
                    var5_9 = tempDirectory;
                }
                catch (Exception ex) {
                    if (ex instanceof CancellationException) {
                        $i$f$currentCoroutineContext = false;
                        if (!JobKt.isActive((CoroutineContext)$continuation.getContext())) {
                            throw ex;
                        }
                    }
                    Logger.INSTANCE.warn((Throwable)ex, "Failed to collect remote logs for " + this.environmentId);
                    this.fileUtils.asyncDelete(tempDirectory);
                    var5_9 = null;
                }
                return var5_9;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final boolean isApplicable$lambda$0(EnvironmentDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTools().getAllowLogCollection();
    }

    private static final Unit collect$lambda$0$0(BufferedSink $this_write, MutableStateFlow $progress, String string, Long totalSize, InputStream remoteLogZipStream) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)remoteLogZipStream, (String)"remoteLogZipStream");
        if (totalSize == null) {
            throw new IllegalStateException("Refusing to download logs with no total size".toString());
        }
        if (totalSize > 0x80000000L) {
            double totalSizeInMB = (double)totalSize.longValue() / (double)1024 / (double)1024;
            double maxSizeInMB = 2048.0;
            throw new IllegalStateException(("Refusing to download logs larger than " + maxSizeInMB + "MB. Got " + totalSizeInMB + "MB").toString());
        }
        long notifyEachNBytes = Math.max(totalSize / (long)100, 1L);
        ProgressInputStream inputStream = new ProgressInputStream(remoteLogZipStream, notifyEachNBytes, arg_0 -> RemoteLogCollectionStep.collect$lambda$0$0$0($progress, totalSize, arg_0));
        ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)$this_write.outputStream(), (int)0, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final void collect$lambda$0$0$0(MutableStateFlow $progress, Long $totalSize, long it) {
        $progress.setValue((Object)Float.valueOf((float)it / (float)$totalSize.longValue()));
    }

    public /* synthetic */ RemoteLogCollectionStep(DevEnvironmentId environmentId, String remoteChannelId, LogsCollectorService logsCollectorService, EnvironmentDescriptorManager environmentDescriptorManager, FileSystem fileSystem, FileUtils fileUtils, DefaultConstructorMarker $constructor_marker) {
        this(environmentId, remoteChannelId, logsCollectorService, environmentDescriptorManager, fileSystem, fileUtils);
    }
}

