/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.deploy.logs;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.FileUtils;
import com.jetbrains.toolbox.agentNetworkApi.tools.ToolManipulationService;
import com.jetbrains.toolbox.agentNetworkApi.tools.dto.RemoteChannelId;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.ToolCounterpart;
import com.jetbrains.toolbox.gateway.ToolCounterpartManager;
import com.jetbrains.toolbox.gateway.deploy.logs.CounterpartLogCollectionStep;
import com.jetbrains.toolbox.gateway.deploy.logs.LogCollectionStep;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.tools.logs.ToolLogCollector;
import com.jetbrains.toolbox.tools.model.ChannelId;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nCounterpartLogCollectionStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CounterpartLogCollectionStep.kt\ncom/jetbrains/toolbox/gateway/deploy/logs/CounterpartLogCollectionStep\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class CounterpartLogCollectionStep
implements LogCollectionStep {
    @NotNull
    private final DevEnvironmentId environmentId;
    @Nullable
    private final String remoteChannelId;
    @NotNull
    private final ToolManipulationService toolManipulationService;
    @NotNull
    private final ToolCounterpartManager counterpartManager;
    @NotNull
    private final ToolLogCollector toolLogCollector;
    @NotNull
    private final FileUtils fileUtils;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final LocalizableString title;

    private CounterpartLogCollectionStep(DevEnvironmentId environmentId, String remoteChannelId, ToolManipulationService toolManipulationService, ToolCounterpartManager counterpartManager, ToolLogCollector toolLogCollector, FileUtils fileUtils, FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)environmentId, (String)"environmentId");
        Intrinsics.checkNotNullParameter((Object)toolManipulationService, (String)"toolManipulationService");
        Intrinsics.checkNotNullParameter((Object)counterpartManager, (String)"counterpartManager");
        Intrinsics.checkNotNullParameter((Object)toolLogCollector, (String)"toolLogCollector");
        Intrinsics.checkNotNullParameter((Object)fileUtils, (String)"fileUtils");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.environmentId = environmentId;
        this.remoteChannelId = remoteChannelId;
        this.toolManipulationService = toolManipulationService;
        this.counterpartManager = counterpartManager;
        this.toolLogCollector = toolLogCollector;
        this.fileUtils = fileUtils;
        this.fileSystem = fileSystem;
        this.title = LocalizableStringExKt.trl("Collecting local counterpart tool logs");
    }

    @Override
    @NotNull
    public LocalizableString getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public Object isApplicable(@NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((this.remoteChannelId != null ? 1 : 0) != 0);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object collect(@NotNull MutableStateFlow<Float> progress, @NotNull Continuation<? super Path> $completion) {
        if (!($completion instanceof collect.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ CounterpartLogCollectionStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.collect(null, (Continuation<? super Path>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!(this.remoteChannelId != null)) {
                    $i$a$-require-CounterpartLogCollectionStep$collect$2 = false;
                    $i$a$-require-CounterpartLogCollectionStep$collect$2 = "Remote channel id is null";
                    throw new IllegalArgumentException($i$a$-require-CounterpartLogCollectionStep$collect$2.toString());
                }
                Logger.INSTANCE.info("Collecting client logs for " + this.environmentId);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)progress);
                $continuation.label = 1;
                v0 = this.toolManipulationService.getToolInfo-BZ-RX3Y(this.remoteChannelId, (Continuation)$continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                progress = (MutableStateFlow)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                if ((info = (Pair)v0) == null) {
                    Logger.INSTANCE.error("Couldn't find the tool with channelId: " + RemoteChannelId.toString-impl((String)this.remoteChannelId) + " on the remote side");
                    return null;
                }
                clientChannel = this.counterpartManager.findTool-73xg5Po(ToolCounterpart.Companion.compatibleToolCounterpart(new ToolCounterpart.Build(((ApplicationType)info.getFirst()).unbox-impl(), ((BuildNumber)info.getSecond()).unbox-impl(), null)));
                if (clientChannel == null) {
                    Logger.INSTANCE.warn("Couldn't find local client for " + ApplicationType.toString-impl(((ApplicationType)info.getFirst()).unbox-impl()) + "-" + BuildNumber.toString-impl(((BuildNumber)info.getSecond()).unbox-impl()));
                    return null;
                }
                Logger.INSTANCE.info("Local client for " + this.environmentId + " has channelId " + ChannelId.toString-impl(clientChannel));
                tempDirectory = this.fileUtils.createTempDirectory("client-logs");
                clientLogDirectory = tempDirectory.resolve("Client");
                this.fileSystem.createDirectories(clientLogDirectory);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)progress);
                $continuation.L$1 = info;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)clientChannel);
                $continuation.L$3 = tempDirectory;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)clientLogDirectory);
                $continuation.label = 2;
                v1 = this.toolLogCollector.collectLogsForChannel-KCT93BI(clientChannel, clientLogDirectory, (Continuation<? super Boolean>)$continuation);
                ** if (v1 != var11_5) goto lbl49
lbl48:
                // 1 sources

                return var11_5;
lbl49:
                // 1 sources

                ** GOTO lbl60
            }
            case 2: {
                clientLogDirectory = (Path)$continuation.L$4;
                tempDirectory = (Path)$continuation.L$3;
                clientChannel = (String)$continuation.L$2;
                info = (Pair)$continuation.L$1;
                progress = (MutableStateFlow)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl60:
                    // 2 sources

                    var7_14 = tempDirectory;
                }
                catch (Exception e) {
                    Logger.INSTANCE.warn((Throwable)e, "Failed to collect client logs for " + ApplicationType.toString-impl(((ApplicationType)info.getFirst()).unbox-impl()) + "-" + BuildNumber.toString-impl(((BuildNumber)info.getSecond()).unbox-impl()));
                    this.fileUtils.asyncDelete(tempDirectory);
                    var7_14 = null;
                }
                return var7_14;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public /* synthetic */ CounterpartLogCollectionStep(DevEnvironmentId environmentId, String remoteChannelId, ToolManipulationService toolManipulationService, ToolCounterpartManager counterpartManager, ToolLogCollector toolLogCollector, FileUtils fileUtils, FileSystem fileSystem, DefaultConstructorMarker $constructor_marker) {
        this(environmentId, remoteChannelId, toolManipulationService, counterpartManager, toolLogCollector, fileUtils, fileSystem);
    }
}

