/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.deploy;

import com.jetbrains.toolbox.common.ActionProgress;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.common.security.ShaKt;
import com.jetbrains.toolbox.gateway.deploy.DeployUtil;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.network.DownloadManager;
import com.jetbrains.toolbox.network.DownloadResult;
import com.jetbrains.toolbox.network.DownloadSession;
import com.jetbrains.toolbox.network.FileDownloader;
import java.util.Locale;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.HexExtensionsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class DeployUtil {
    @NotNull
    public static final DeployUtil INSTANCE = new DeployUtil();
    @NotNull
    public static final String deployResultPrefix = "~RESULT: ";

    private DeployUtil() {
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object downloadFile(@NotNull FileSystem fileSystem, @NotNull DownloadManager downloadManager, @NotNull String url, @NotNull String sha256, @NotNull Path targetFile, @NotNull Continuation<? super Unit> $completion) {
        block16: {
            if (!($completion instanceof downloadFile.1)) ** GOTO lbl-1000
            var10_7 = $completion;
            if ((var10_7.label & -2147483648) != 0) {
                var10_7.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    /* synthetic */ Object result;
                    final /* synthetic */ DeployUtil this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.downloadFile(null, null, null, null, null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var11_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (DeployUtil.downloadFile$checkSha256(fileSystem, targetFile, sha256)) {
                        Logger.INSTANCE.info("File '" + targetFile + "' was already downloaded from '" + url + "', sha256 '" + sha256 + "'");
                        return Unit.INSTANCE;
                    }
                    $continuation.L$0 = fileSystem;
                    $continuation.L$1 = downloadManager;
                    $continuation.L$2 = url;
                    $continuation.L$3 = sha256;
                    $continuation.L$4 = targetFile;
                    $continuation.label = 1;
                    v0 = downloadManager.createSession((Continuation<? super DownloadSession>)$continuation);
                    if (v0 == var11_9) {
                        return var11_9;
                    }
                    ** GOTO lbl33
                }
                case 1: {
                    targetFile = (Path)$continuation.L$4;
                    sha256 = (String)$continuation.L$3;
                    url = (String)$continuation.L$2;
                    downloadManager = (DownloadManager)$continuation.L$1;
                    fileSystem = (FileSystem)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl33:
                    // 2 sources

                    $continuation.L$0 = fileSystem;
                    $continuation.L$1 = downloadManager;
                    $continuation.L$2 = url;
                    $continuation.L$3 = sha256;
                    $continuation.L$4 = targetFile;
                    $continuation.label = 2;
                    v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)v0), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DownloadResult>, Object>(downloadManager, url, targetFile, null){
                        int label;
                        final /* synthetic */ DownloadManager $downloadManager;
                        final /* synthetic */ String $url;
                        final /* synthetic */ Path $targetFile;
                        {
                            this.$downloadManager = $downloadManager;
                            this.$url = $url;
                            this.$targetFile = $targetFile;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = FileDownloader.getFile$default(this.$downloadManager.getFileDownloader(), this.$url, this.$targetFile, -1L, new ActionProgress(0, LocalizableStringExKt.notr(""), null, false, 0L, 28, null), null, false, false, (Continuation)this, 112, null);
                                    if (object2 != object) return object2;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return object2;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super DownloadResult> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v1 == var11_9) {
                        return var11_9;
                    }
                    ** GOTO lbl51
                }
                case 2: {
                    targetFile = (Path)$continuation.L$4;
                    sha256 = (String)$continuation.L$3;
                    url = (String)$continuation.L$2;
                    downloadManager = (DownloadManager)$continuation.L$1;
                    fileSystem = (FileSystem)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl51:
                    // 2 sources

                    if (Intrinsics.areEqual((Object)(var8_12 = (result = (DownloadResult)v1)), (Object)DownloadResult.Cancelled.INSTANCE)) {
                        throw new IllegalStateException(("Download was cancelled: " + url).toString());
                    }
                    if (!(var8_12 instanceof DownloadResult.Downloaded)) ** GOTO lbl57
                    if (!DeployUtil.downloadFile$checkSha256(fileSystem, targetFile, sha256)) {
                        throw new IllegalStateException(("File '" + targetFile + "' was downloaded from '" + url + "', but has an incorrect sha256 checksum").toString());
                    }
                    break block16;
lbl57:
                    // 1 sources

                    if (var8_12 instanceof DownloadResult.Failed) {
                        throw new IllegalStateException(("Download of '" + url + "' failed: " + ((DownloadResult.Failed)result).getError()).toString());
                    }
                    if (var8_12 instanceof DownloadResult.NotConnected) {
                        throw new IllegalStateException(("Not connected to download '" + url + "': " + ((DownloadResult.NotConnected)result).getError()).toString());
                    }
                    if (!Intrinsics.areEqual((Object)var8_12, (Object)DownloadResult.NotModified.INSTANCE)) break;
                    Logger.INSTANCE.warn("Re-downloading file from '" + url + "' since previous download does not match sha256 checksum: " + targetFile);
                    fileSystem.delete(targetFile);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)fileSystem);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)downloadManager);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)url);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)sha256);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)targetFile);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)result);
                    $continuation.label = 3;
                    v2 = this.downloadFile(fileSystem, downloadManager, url, sha256, targetFile, (Continuation<? super Unit>)$continuation);
                    if (v2 == var11_9) {
                        return var11_9;
                    }
                    ** GOTO lbl84
                }
                case 3: {
                    result = (DownloadResult)$continuation.L$5;
                    targetFile = (Path)$continuation.L$4;
                    sha256 = (String)$continuation.L$3;
                    url = (String)$continuation.L$2;
                    downloadManager = (DownloadManager)$continuation.L$1;
                    fileSystem = (FileSystem)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl84:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean downloadFile$checkSha256(FileSystem $fileSystem, Path file, String sha256) {
        try {
            if (!FileSystemExtKt.isReadable($fileSystem, file)) return false;
            String string = HexExtensionsKt.toHexString$default((byte[])ShaKt.sha256($fileSystem, file), null, (int)1, null);
            String string2 = sha256.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (!Intrinsics.areEqual((Object)string, (Object)string2)) return false;
            return true;
        }
        catch (Throwable t2) {
            Logger.INSTANCE.warn(t2, "Error checking sha256 of " + file + ": " + t2.getMessage());
            return false;
        }
    }
}

