/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.auth;

import com.jetbrains.toolbox.accounts.PluginAccountWrapper;
import com.jetbrains.toolbox.accounts.PluginSecureToken;
import com.jetbrains.toolbox.accounts.oauth.OAuth2Token;
import com.jetbrains.toolbox.accounts.oauth.OAuthTokenRefresherImpl;
import com.jetbrains.toolbox.api.core.auth.Account;
import com.jetbrains.toolbox.api.core.auth.RefreshConfiguration;
import com.jetbrains.toolbox.network.BasicDownloadManager;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginTokenRefresher<A extends Account>
extends OAuthTokenRefresherImpl<PluginAccountWrapper<? extends A>, PluginSecureToken> {
    @NotNull
    private final Function1<A, RefreshConfiguration> createRefreshConfig;

    public PluginTokenRefresher(@NotNull String displayName, @NotNull BasicDownloadManager downloadManager, @NotNull Clock clock, @NotNull Function1<? super A, ? extends RefreshConfiguration> createRefreshConfig) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(createRefreshConfig, (String)"createRefreshConfig");
        super(displayName, downloadManager, clock);
        this.createRefreshConfig = createRefreshConfig;
    }

    @Override
    @NotNull
    protected RefreshConfiguration createRefreshConfiguration(@NotNull PluginAccountWrapper<? extends A> account2) {
        Intrinsics.checkNotNullParameter(account2, (String)"account");
        return (RefreshConfiguration)this.createRefreshConfig.invoke(account2.getJavaPluginAccount());
    }

    @Override
    @NotNull
    protected PluginSecureToken updateToken(@NotNull PluginSecureToken previousToken, @NotNull OAuth2Token newToken2, @Nullable String requestId) {
        Intrinsics.checkNotNullParameter((Object)previousToken, (String)"previousToken");
        Intrinsics.checkNotNullParameter((Object)newToken2, (String)"newToken");
        return previousToken.updateFrom(newToken2);
    }
}

