/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.ui.DescriptionTree;
import com.jetbrains.toolbox.gateway.DevEnvironmentFeature;
import com.jetbrains.toolbox.gateway.error.EnvironmentError;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.rpc.model.HandshakeResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract sealed class RpcError
extends EnvironmentError {
    private RpcError() {
    }

    public /* synthetic */ RpcError(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @SourceDebugExtension(value={"SMAP\nRpcError.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RpcError.kt\ncom/jetbrains/toolbox/gateway/RpcError$HandshakeFailed\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n808#2,11:41\n*S KotlinDebug\n*F\n+ 1 RpcError.kt\ncom/jetbrains/toolbox/gateway/RpcError$HandshakeFailed\n*L\n29#1:41,11\n*E\n"})
    public static final class HandshakeFailed
    extends RpcError {
        @NotNull
        private final List<DevEnvironmentFeature> devEnvironmentFeatures;
        @NotNull
        private final HandshakeResult.Failed failedHandshake;
        @NotNull
        private final String message;
        @NotNull
        private final LocalizableString localized;
        @Nullable
        private final List<DescriptionTree> description;

        public HandshakeFailed(@NotNull List<? extends DevEnvironmentFeature> devEnvironmentFeatures, @NotNull HandshakeResult.Failed failedHandshake) {
            LocalizableString localizableString;
            Object object;
            Intrinsics.checkNotNullParameter(devEnvironmentFeatures, (String)"devEnvironmentFeatures");
            Intrinsics.checkNotNullParameter((Object)failedHandshake, (String)"failedHandshake");
            super((DefaultConstructorMarker)null);
            this.devEnvironmentFeatures = devEnvironmentFeatures;
            HandshakeResult.Failed failed = this.failedHandshake = failedHandshake;
            if (failed instanceof HandshakeResult.Error) {
                object = "Fatal error during handshake: " + ((HandshakeResult.Error)this.failedHandshake).getErrorMessage();
            } else if (failed instanceof HandshakeResult.ClientFailure) {
                object = "Handshake failed: Toolbox Agent doesn't meet the requirements";
            } else if (failed instanceof HandshakeResult.ServerFailure) {
                object = "Handshake failed: local Toolbox App doesn't meet the requirements";
            } else if (failed instanceof HandshakeResult.UpdateNeeded) {
                object = "Handshake failed: update local Toolbox App to at least " + ((HandshakeResult.UpdateNeeded)this.failedHandshake).getMinimalVersion().getNumber();
            } else if (failed instanceof HandshakeResult.ServerWillUpdate) {
                object = "Handshake failed: Toolbox Agent doesn't meet the requirements but will self-update";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            this.message = object;
            failed = this.failedHandshake;
            if (failed instanceof HandshakeResult.Error) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"errorMessage", (Object)((HandshakeResult.Error)this.failedHandshake).getErrorMessage())};
                localizableString = LocalizableStringExKt.trl("Fatal error during handshake: {{errorMessage}}", pairArray);
            } else if (failed instanceof HandshakeResult.ClientFailure) {
                localizableString = LocalizableStringExKt.trl("Handshake failed: Toolbox Agent doesn't meet requirements");
            } else if (failed instanceof HandshakeResult.ServerFailure) {
                localizableString = LocalizableStringExKt.trl("Handshake failed: local Toolbox App doesn't meet requirements");
            } else if (Intrinsics.areEqual((Object)failed, (Object)HandshakeResult.ServerWillUpdate.INSTANCE)) {
                localizableString = LocalizableStringExKt.trl("Handshake failed: Toolbox Agent doesn't meet the requirements but will self-update");
            } else if (failed instanceof HandshakeResult.UpdateNeeded) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"version", (Object)String.valueOf(((HandshakeResult.UpdateNeeded)this.failedHandshake).getMinimalVersion().getNumber()))};
                localizableString = LocalizableStringExKt.trl("Handshake failed: update local Toolbox App to at least {{version}}", pairArray);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            this.localized = localizableString;
            this.description = this.getForceDeployFix();
        }

        @NotNull
        public final HandshakeResult.Failed getFailedHandshake() {
            return this.failedHandshake;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public LocalizableString getLocalized() {
            return this.localized;
        }

        @Override
        @Nullable
        public List<DescriptionTree> getDescription() {
            return this.description;
        }

        /*
         * WARNING - void declaration
         */
        private final List<DescriptionTree> getForceDeployFix() {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.devEnvironmentFeatures;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DevEnvironmentFeature.Deployable)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            DevEnvironmentFeature.Deployable deployable = (DevEnvironmentFeature.Deployable)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (deployable == null) {
                return null;
            }
            DevEnvironmentFeature.Deployable deployableFeature = deployable;
            Object[] objectArray = new DescriptionTree[]{new DescriptionTree.Text((LocalizableString)LocalizableStringExKt.trl("Problem might be resolved by reconnecting forcefully which will redeploy the agent and kill all running agents on remote side")), new DescriptionTree.Action((LocalizableString)LocalizableStringExKt.trl("Force reconnect"), () -> HandshakeFailed.getForceDeployFix$lambda$0(deployableFeature))};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        private static final boolean getForceDeployFix$lambda$0(DevEnvironmentFeature.Deployable $deployableFeature) {
            $deployableFeature.redeploy(true);
            return true;
        }
    }
}

