/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway;

import com.jetbrains.toolbox.gateway.DevEnvironment;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.DevEnvironmentManager;
import com.jetbrains.toolbox.gateway.EnvironmentVisibilityManager;
import com.jetbrains.toolbox.gateway.utils.DevEnvironmentManagerExtensions;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nEnvironmentVisibilityManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvironmentVisibilityManagerImpl.kt\ncom/jetbrains/toolbox/gateway/EnvironmentVisibilityManagerImpl\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n72#2,2:59\n72#2,2:63\n1#3:61\n1#3:62\n1#3:65\n*S KotlinDebug\n*F\n+ 1 EnvironmentVisibilityManagerImpl.kt\ncom/jetbrains/toolbox/gateway/EnvironmentVisibilityManagerImpl\n*L\n17#1:59,2\n29#1:63,2\n17#1:61\n29#1:65\n*E\n"})
public final class EnvironmentVisibilityManagerImpl
implements EnvironmentVisibilityManager {
    @NotNull
    private final DevEnvironmentManager devEnvironmentManager;
    @NotNull
    private final MutableStateFlow<DevEnvironmentId> currentlyOpenedEnvironment;
    @NotNull
    private final ConcurrentHashMap<DevEnvironmentId, Set<AutoCloseable>> statusMap;
    @NotNull
    private final ConcurrentHashMap<DevEnvironmentId, Set<AutoCloseable>> clientMap;

    public EnvironmentVisibilityManagerImpl(@NotNull DevEnvironmentManager devEnvironmentManager) {
        Intrinsics.checkNotNullParameter((Object)devEnvironmentManager, (String)"devEnvironmentManager");
        this.devEnvironmentManager = devEnvironmentManager;
        this.currentlyOpenedEnvironment = StateFlowKt.MutableStateFlow(null);
        this.statusMap = new ConcurrentHashMap();
        this.clientMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AutoCloseable notifyVisibleStatus(@NotNull DevEnvironmentId devEnvironmentId) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)devEnvironmentId, (String)"devEnvironmentId");
        ConcurrentMap concurrentMap = this.statusMap;
        DevEnvironmentId key$iv = devEnvironmentId;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            Set default$iv = ConcurrentHashMap.newKeySet();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Set set = (Set)object;
        Intrinsics.checkNotNull((Object)set);
        return this.createVisibilityLifetime(devEnvironmentId, set);
    }

    @Override
    public void notifyEnvironmentOpened(@Nullable DevEnvironmentId id) {
        block1: {
            DevEnvironmentId it;
            DevEnvironmentId oldId = (DevEnvironmentId)this.currentlyOpenedEnvironment.getValue();
            this.currentlyOpenedEnvironment.setValue((Object)id);
            DevEnvironmentId devEnvironmentId = oldId;
            if (devEnvironmentId != null) {
                it = devEnvironmentId;
                boolean bl = false;
                this.refreshEnvironmentVisibility(it);
            }
            DevEnvironmentId devEnvironmentId2 = id;
            if (devEnvironmentId2 == null) break block1;
            it = devEnvironmentId2;
            boolean bl = false;
            this.refreshEnvironmentVisibility(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AutoCloseable notifyBackendConnection(@NotNull DevEnvironmentId id) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ConcurrentMap concurrentMap = this.clientMap;
        DevEnvironmentId key$iv = id;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            Set default$iv = ConcurrentHashMap.newKeySet();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Set set = (Set)object;
        Intrinsics.checkNotNull((Object)set);
        return this.createVisibilityLifetime(id, set);
    }

    private final AutoCloseable createVisibilityLifetime(DevEnvironmentId id, Set<AutoCloseable> set) {
        AutoCloseable lifetime2 = new AutoCloseable(set, this, id){
            final /* synthetic */ Set<AutoCloseable> $set;
            final /* synthetic */ EnvironmentVisibilityManagerImpl this$0;
            final /* synthetic */ DevEnvironmentId $id;
            {
                this.$set = $set;
                this.this$0 = $receiver;
                this.$id = $id;
            }

            public void close() {
                ((Collection)this.$set).remove(this);
                EnvironmentVisibilityManagerImpl.access$refreshEnvironmentVisibility(this.this$0, this.$id);
            }
        };
        ((Collection)set).add(lifetime2);
        this.refreshEnvironmentVisibility(id);
        return lifetime2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refreshEnvironmentVisibility(DevEnvironmentId id) {
        EnvironmentVisibilityManagerImpl environmentVisibilityManagerImpl = this;
        synchronized (environmentVisibilityManagerImpl) {
            DevEnvironment environment;
            boolean bl;
            boolean bl2;
            boolean bl3 = false;
            Set<AutoCloseable> set = this.statusMap.get(id);
            if (set != null) {
                Set<AutoCloseable> it = set;
                boolean bl4 = false;
                bl2 = it.size() > 0;
            } else {
                bl2 = false;
            }
            boolean isStatusVisible = bl2;
            boolean isContentVisible = Intrinsics.areEqual((Object)this.currentlyOpenedEnvironment.getValue(), (Object)id);
            Set<AutoCloseable> set2 = this.clientMap.get(id);
            if (set2 != null) {
                Set<AutoCloseable> it = set2;
                boolean bl5 = false;
                bl = it.size() > 0;
            } else {
                bl = false;
            }
            boolean isBackendConnectionRunning = bl;
            DevEnvironment devEnvironment = environment = DevEnvironmentManagerExtensions.INSTANCE.findEnvironment(this.devEnvironmentManager, id);
            if (devEnvironment != null) {
                devEnvironment.setVisibility(isStatusVisible, isContentVisible, isBackendConnectionRunning);
            } else {
                Logger.INSTANCE.warn("Couldn't set the visibility for environment: " + id + " because it doesn't exist");
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ void access$refreshEnvironmentVisibility(EnvironmentVisibilityManagerImpl $this, DevEnvironmentId id) {
        $this.refreshEnvironmentVisibility(id);
    }
}

