/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.fleet.core;

import com.jetbrains.toolbox.common.platform.OS;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;

public final class FleetPathsKt {
    @NotNull
    public static final Path fleetLogDir() {
        Path parent = FleetPathsKt.platformPath("Logs", "LOCALAPPDATA", "", "XDG_CACHE_HOME", ".cache", "");
        return OS.INSTANCE.isMac() ? parent : parent.resolve("log");
    }

    @NotNull
    public static final Path fleetCachesDir() {
        return FleetPathsKt.platformPath("Caches", "LOCALAPPDATA", "", "XDG_CACHE_HOME", ".cache", "");
    }

    @NotNull
    public static final Path fleetConfigDirectoryPath() {
        return FleetPathsKt.platformPath("Application Support", "APPDATA", "", "XDG_CONFIG_HOME", ".config", "");
    }

    private static final Path platformPath(String macDir, String winVar, String winSub, String xdgVar, String xdgDfl, String xdgSub) {
        String userHome = System.getProperty("user.home");
        return Path.Companion.get$default((Path.Companion)Path.Companion, (String)(switch (WhenMappings.$EnumSwitchMapping$0[OS.INSTANCE.getType().ordinal()]) {
            case 1 -> userHome + "/Library/" + macDir + "/JetBrains/Fleet";
            case 2 -> {
                Object dir = System.getenv(winVar);
                if (dir == null || ((CharSequence)dir).length() == 0) {
                    dir = userHome + "\\AppData\\" + (StringsKt.startsWith$default((String)winVar, (String)"LOCAL", (boolean)false, (int)2, null) ? "Local" : "Roaming");
                }
                dir = (String)dir + "\\JetBrains\\Fleet";
                if (((CharSequence)winSub).length() > 0) {
                    yield (String)dir + "\\" + winSub;
                }
                yield dir;
            }
            case 3 -> {
                Object dir = System.getenv(xdgVar);
                if (dir == null || ((CharSequence)dir).length() == 0) {
                    dir = userHome + "/" + xdgDfl;
                }
                dir = (String)dir + "/JetBrains/Fleet";
                if (((CharSequence)xdgSub).length() > 0) {
                    yield (String)dir + "/" + xdgSub;
                }
                yield dir;
            }
            default -> throw new IllegalStateException("Unknown OS".toString());
        }), (boolean)false, (int)1, null);
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Mac.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Windows.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

