/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.fileAssociationsWindows;

import com.jetbrains.toolbox.feed.FileAssociationsSupport;
import com.jetbrains.toolbox.fileAssociationsWindows.UtilKt;
import com.jetbrains.toolbox.fileAssociationsWindows.WindowsAssociations;
import com.jetbrains.toolbox.fileAssociationsWindows.WindowsAssociationsUninstallHandler;
import com.jetbrains.toolbox.fileAssociationsWindows.WindowsFileAssociationsUpdaterKt;
import com.jetbrains.toolbox.fileAssociationsWindows.WindowsProgIdChannelExtension;
import com.jetbrains.toolbox.tools.UninstallResult;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolUninstallHandler;
import java.util.Set;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class WindowsAssociationsUninstallHandler
implements ToolUninstallHandler {
    @NotNull
    private final WindowsAssociations windowsAssociations;

    public WindowsAssociationsUninstallHandler(@NotNull WindowsAssociations windowsAssociations) {
        Intrinsics.checkNotNullParameter((Object)windowsAssociations, (String)"windowsAssociations");
        this.windowsAssociations = windowsAssociations;
    }

    @Override
    @Nullable
    public Object onUninstall(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super UninstallResult> $completion) {
        String progId;
        FileAssociationsSupport fileAssociationsSupport = toolInstance.getTool().getFileAssociationsSupport();
        if (fileAssociationsSupport == null) {
            return UninstallResult.NotSupported.INSTANCE;
        }
        FileAssociationsSupport fileAssociationsSupport2 = fileAssociationsSupport;
        WindowsAssociations $this$onUninstall_u24lambda_u240 = this.windowsAssociations;
        boolean bl = false;
        WindowsProgIdChannelExtension windowsProgIdChannelExtension = UtilKt.getWindowsProgIdChannelExtension(toolInstance.getChannel());
        String string = progId = windowsProgIdChannelExtension != null ? windowsProgIdChannelExtension.getValue() : null;
        if (progId == null) {
            Logger.INSTANCE.warn("Can't find windowsProgIdChannelExtension, it should be already generated, skipping file associations deregistering");
        } else {
            WindowsFileAssociationsUpdaterKt.deregisterAppAndAssociations($this$onUninstall_u24lambda_u240, progId, toolInstance.getChannel().getInstallationDirectory(), fileAssociationsSupport2.getExtensionsWithoutDot(), (Function0<? extends Set<String>>)((Function0)onUninstall.2.1.INSTANCE));
        }
        return UninstallResult.Success.INSTANCE;
    }
}

